/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import org.flasck.flas.parsedForm.StructField;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class StructFieldMatcher
extends TypeSafeMatcher<StructField> {
    private final String type;
    private final String name;
    private int tyloc = -1;
    private int varloc = -1;
    private int assloc = -1;
    private Matcher<?> assExpr;

    public StructFieldMatcher(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public void describeTo(Description arg0) {
        arg0.appendText("StructField(");
        arg0.appendValue((Object)this.type);
        arg0.appendText(":");
        arg0.appendValue((Object)this.name);
        arg0.appendText(")");
        if (this.tyloc != -1) {
            arg0.appendText(" @{");
            arg0.appendValue((Object)this.tyloc);
            arg0.appendText(",");
            arg0.appendValue((Object)this.varloc);
            arg0.appendText("}");
        }
        if (this.assExpr != null) {
            arg0.appendText(" assign{");
            arg0.appendValue((Object)this.assloc);
            arg0.appendValue(this.assExpr);
            arg0.appendText("}");
        }
    }

    protected boolean matchesSafely(StructField arg0) {
        if (!arg0.type.name().equals(this.type)) {
            return false;
        }
        if (!arg0.name.equals(this.name)) {
            return false;
        }
        if (this.tyloc != -1 && this.tyloc != arg0.type.location().off) {
            return false;
        }
        if (this.varloc != -1 && this.varloc != arg0.location().off) {
            return false;
        }
        if (this.assloc != -1 && this.assloc != arg0.assOp.off) {
            return false;
        }
        return this.assExpr == null || this.assExpr.matches((Object)arg0.init);
    }

    public StructFieldMatcher locs(int ty, int var) {
        this.tyloc = ty;
        this.varloc = var;
        return this;
    }

    public StructFieldMatcher assign(int loc, Matcher<?> expr) {
        this.assloc = loc;
        this.assExpr = expr;
        return this;
    }

    public static StructFieldMatcher match(String type, String name) {
        return new StructFieldMatcher(type, name);
    }
}

