/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.StructDefn;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class StructDefnMatcher
extends TypeSafeMatcher<StructDefn> {
    private final String name;
    private final List<String> polys = new ArrayList<String>();
    private int kwloc = -1;
    private int typeloc = -1;
    private FieldsDefn.FieldsType objty = FieldsDefn.FieldsType.STRUCT;

    public StructDefnMatcher(String name) {
        this.name = name;
    }

    public void describeTo(Description arg0) {
        arg0.appendText("StructDefn(");
        arg0.appendValue((Object)this.objty);
        arg0.appendText(":");
        arg0.appendValue((Object)this.name);
        arg0.appendText(")");
        if (!this.polys.isEmpty()) {
            arg0.appendValue(this.polys);
        }
        if (this.kwloc != -1) {
            arg0.appendText("@{");
            arg0.appendValue((Object)this.kwloc);
            arg0.appendText(",");
            arg0.appendValue((Object)this.typeloc);
            arg0.appendText("}");
        }
    }

    protected boolean matchesSafely(StructDefn arg0) {
        if (arg0.type != this.objty) {
            return false;
        }
        if (!arg0.name.uniqueName().equals(this.name)) {
            return false;
        }
        if (arg0.polys().size() != this.polys.size()) {
            return false;
        }
        if (this.kwloc != -1 && this.kwloc != arg0.kw.off) {
            return false;
        }
        return this.typeloc == -1 || this.typeloc == arg0.location().off;
    }

    public StructDefnMatcher poly(String poly) {
        this.polys.add(poly);
        return this;
    }

    public StructDefnMatcher locs(int kw, int type) {
        this.kwloc = kw;
        this.typeloc = type;
        return this;
    }

    public StructDefnMatcher as(FieldsDefn.FieldsType ty) {
        this.objty = ty;
        return this;
    }

    public static StructDefnMatcher match(String name) {
        return new StructDefnMatcher(name);
    }
}

