/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ObjectMethodMatcher
extends TypeSafeMatcher<ObjectMethod> {
    private final NameOfThing scope;
    private final String name;
    private Integer hasArgs;
    private String handlerName;

    public ObjectMethodMatcher(NameOfThing scope, String name) {
        this.scope = scope;
        this.name = name;
    }

    public void describeTo(Description desc) {
        desc.appendText("ObjectMethod{");
        if (this.scope != null) {
            desc.appendValue((Object)this.scope.uniqueName());
            desc.appendText(".");
        }
        desc.appendValue((Object)this.name);
        if (this.hasArgs != null) {
            desc.appendText("/");
            desc.appendValue((Object)this.hasArgs);
        }
        if (this.handlerName != null) {
            desc.appendText("->");
            desc.appendValue((Object)this.handlerName);
        }
        desc.appendText("}");
    }

    protected boolean matchesSafely(ObjectMethod meth) {
        FunctionName fn = meth.name();
        if (fn.inContext == null != (this.scope == null)) {
            return false;
        }
        if (this.scope != null && !this.scope.uniqueName().equals(fn.inContext.uniqueName())) {
            return false;
        }
        if (!fn.name.equals(this.name)) {
            return false;
        }
        if (this.hasArgs != null && this.hasArgs.intValue() != meth.args().size()) {
            return false;
        }
        return this.handlerName == null || this.handlerName.equals(meth.handler.name().uniqueName());
    }

    public static ObjectMethodMatcher called(NameOfThing scope, String name) {
        return new ObjectMethodMatcher(scope, name);
    }

    public ObjectMethodMatcher withArgs(int cnt) {
        this.hasArgs = cnt;
        return this;
    }

    public ObjectMethodMatcher withHandler(String string) {
        this.handlerName = string;
        return this;
    }
}

