/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ObjectDefnMatcher
extends TypeSafeMatcher<ObjectDefn> {
    private final String name;
    private final List<String> polys = new ArrayList<String>();
    private int kwloc = -1;
    private int typeloc = -1;

    public ObjectDefnMatcher(String name) {
        this.name = name;
    }

    public void describeTo(Description arg0) {
        arg0.appendText("ObjectDefn(");
        arg0.appendValue((Object)this.name);
        arg0.appendText(")");
        if (!this.polys.isEmpty()) {
            arg0.appendValue(this.polys);
        }
        if (this.kwloc != -1) {
            arg0.appendText("@{");
            arg0.appendValue((Object)this.kwloc);
            arg0.appendText(",");
            arg0.appendValue((Object)this.typeloc);
            arg0.appendText("}");
        }
    }

    protected boolean matchesSafely(ObjectDefn arg0) {
        if (!arg0.name().uniqueName().equals(this.name)) {
            return false;
        }
        if (arg0.polys().size() != this.polys.size()) {
            return false;
        }
        if (this.kwloc != -1 && this.kwloc != arg0.kw.off) {
            return false;
        }
        return this.typeloc == -1 || this.typeloc == arg0.location().off;
    }

    public ObjectDefnMatcher poly(String poly) {
        this.polys.add(poly);
        return this;
    }

    public ObjectDefnMatcher locs(int kw, int type) {
        this.kwloc = kw;
        this.typeloc = type;
        return this;
    }

    public static ObjectDefnMatcher match(String name) {
        return new ObjectDefnMatcher(name);
    }
}

