/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.testsupport.matchers.ExprMatcher;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public abstract class GuardedMessagesMatcher
extends TypeSafeMatcher<GuardedMessages> {
    private InputPosition pos;

    public static GuardedMessagesMatcher of(final ExprMatcher matcher) {
        return new GuardedMessagesMatcher(){

            public void describeTo(Description desc) {
                desc.appendText("| ");
                if (matcher != null) {
                    matcher.describeTo(desc);
                }
                if (this.pos != null) {
                    desc.appendText("pos");
                    desc.appendValue((Object)this.pos);
                }
            }

            protected boolean matchesSafely(GuardedMessages msg) {
                if (matcher == null && msg.guard != null) {
                    return false;
                }
                if (matcher != null && !matcher.matches(msg.guard)) {
                    return false;
                }
                if (this.pos != null) {
                    if (msg.location() == null) {
                        return false;
                    }
                    if (this.pos.compareTo(msg.location()) != 0) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public GuardedMessagesMatcher location(String file, int line, int off, int end) {
        this.pos = new InputPosition(file, line, off, null, "");
        this.pos.endAt(end);
        return this;
    }
}

