/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import org.flasck.flas.parsedForm.FunctionDefinition;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class FunctionDefinitionMatcher
extends TypeSafeMatcher<FunctionDefinition> {
    private final String name;
    private Integer nargs;
    private Integer nintros;

    public FunctionDefinitionMatcher(String name) {
        this.name = name;
    }

    public FunctionDefinitionMatcher args(int nargs) {
        this.nargs = nargs;
        return this;
    }

    public FunctionDefinitionMatcher intros(int nintros) {
        this.nintros = nintros;
        return this;
    }

    public void describeTo(Description desc) {
        desc.appendText("Function[");
        desc.appendValue((Object)this.name);
        if (this.nargs != null) {
            desc.appendText("(");
            desc.appendValue((Object)this.nargs);
            desc.appendText(")");
        }
        if (this.nintros != null) {
            desc.appendText("{");
            desc.appendValue((Object)this.nintros);
            desc.appendText("}");
        }
        desc.appendText("]");
    }

    protected boolean matchesSafely(FunctionDefinition fd) {
        if (!fd.name().uniqueName().equals(this.name)) {
            return false;
        }
        if (this.nargs != null && !this.nargs.equals(fd.argCount())) {
            return false;
        }
        return this.nintros == null || this.nintros.equals(fd.intros().size());
    }

    public static FunctionDefinitionMatcher named(String name) {
        return new FunctionDefinitionMatcher(name);
    }
}

