/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.parsedForm.FunctionCaseDefn;
import org.flasck.flas.testsupport.matchers.PatternMatcher;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class FunctionCaseMatcher
extends TypeSafeMatcher<FunctionCaseDefn> {
    private final NameOfThing pkg;
    private final String name;
    private final List<PatternMatcher> patterns = new ArrayList<PatternMatcher>();

    public FunctionCaseMatcher(NameOfThing pkg, String name) {
        this.pkg = pkg;
        this.name = name;
    }

    public FunctionCaseMatcher pattern(PatternMatcher pattern) {
        this.patterns.add(pattern);
        return this;
    }

    public void describeTo(Description arg0) {
        arg0.appendText("{function ");
        arg0.appendValue((Object)this.pkg);
        arg0.appendValue((Object)this.name);
        arg0.appendValue(this.patterns);
        arg0.appendText("}");
    }

    protected boolean matchesSafely(FunctionCaseDefn arg0) {
        FunctionName fn = arg0.intro.name();
        if (!fn.name.equals(this.name)) {
            return false;
        }
        if (fn.inContext != null && this.pkg == null) {
            return false;
        }
        if (fn.inContext != null && !fn.inContext.equals(this.pkg)) {
            return false;
        }
        if (this.patterns.size() != arg0.intro.args.size()) {
            return false;
        }
        for (PatternMatcher p : this.patterns) {
            if (p.matches(arg0.intro.args.get(0))) continue;
            return false;
        }
        return true;
    }

    public static FunctionCaseMatcher called(NameOfThing pkg, String name) {
        return new FunctionCaseMatcher(pkg, name);
    }
}

