/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.parsedForm.ConstructorMatch;
import org.flasck.flas.testsupport.matchers.PatternMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CtorPatternMatcher
extends PatternMatcher {
    private final String ctor;
    private final List<FieldMatcher> patterns = new ArrayList<FieldMatcher>();

    public CtorPatternMatcher(String ctor) {
        this.ctor = ctor;
    }

    public void describeTo(Description arg0) {
        arg0.appendText("Ctor<");
        arg0.appendValue((Object)this.ctor);
        arg0.appendValue(this.patterns);
        arg0.appendText(">");
    }

    protected boolean matchesSafely(Pattern arg0) {
        if (arg0 instanceof ConstructorMatch) {
            ConstructorMatch cm = (ConstructorMatch)arg0;
            if (!this.ctor.equals(cm.ctor)) {
                return false;
            }
            if (this.patterns.size() != cm.args.size()) {
                return false;
            }
            for (int i = 0; i < this.patterns.size(); ++i) {
                if (this.patterns.get(i).matches(cm.args.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public CtorPatternMatcher field(String fld, Matcher<Pattern> m) {
        this.patterns.add(new FieldMatcher(fld, m));
        return this;
    }

    public static class FieldMatcher
    extends TypeSafeMatcher<ConstructorMatch.Field> {
        private final String fld;
        private final Matcher<Pattern> m;

        public FieldMatcher(String fld, Matcher<Pattern> m) {
            this.fld = fld;
            this.m = m;
        }

        public void describeTo(Description arg0) {
            arg0.appendText("Field[");
            arg0.appendValue((Object)this.fld);
            arg0.appendText(":");
            arg0.appendValue(this.m);
            arg0.appendText("]");
        }

        protected boolean matchesSafely(ConstructorMatch.Field field) {
            if (!this.fld.equals(field.field)) {
                return false;
            }
            return this.m.matches((Object)field.patt);
        }
    }
}

