/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.testsupport.matchers.ExprMatcher;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public abstract class AssignMessageMatcher
extends TypeSafeMatcher<AssignMessage> {
    private InputPosition pos;

    public static Builder to(String ... vars) {
        return new Builder(vars);
    }

    public AssignMessageMatcher location(String file, int line, int off, int end) {
        this.pos = new InputPosition(file, line, off, null, "");
        this.pos.endAt(end);
        return this;
    }

    public static class Builder {
        private String[] vars;

        public Builder(String[] vars) {
            this.vars = vars;
        }

        public AssignMessageMatcher with(final ExprMatcher matcher) {
            return new AssignMessageMatcher(){

                public void describeTo(Description desc) {
                    for (int i = 0; i < vars.length; ++i) {
                        desc.appendText(vars[i] + " ");
                    }
                    desc.appendText("<- ");
                    matcher.describeTo(desc);
                    if (this.pos != null) {
                        desc.appendText("pos");
                        desc.appendValue((Object)this.pos);
                    }
                }

                protected boolean matchesSafely(AssignMessage msg) {
                    if (!this.matchFrom(msg.slot, vars.length - 1)) {
                        return false;
                    }
                    if (!matcher.matches(msg.expr)) {
                        return false;
                    }
                    if (this.pos != null) {
                        if (msg.location() == null) {
                            return false;
                        }
                        if (this.pos.compareTo(msg.location()) != 0) {
                            return false;
                        }
                    }
                    return true;
                }

                private boolean matchFrom(Expr slot, int vi) {
                    if (vi == 0) {
                        if (!(slot instanceof UnresolvedVar)) {
                            return false;
                        }
                        UnresolvedVar uv = (UnresolvedVar)slot;
                        return vars[vi].equals(uv.var);
                    }
                    if (!(slot instanceof MemberExpr)) {
                        return false;
                    }
                    MemberExpr me = (MemberExpr)slot;
                    if (!this.matchFrom(me.from, vi - 1)) {
                        return false;
                    }
                    return vars[vi].equals(((UnresolvedVar)me.fld).var);
                }
            };
        }
    }
}

