/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testrunner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface TextMatcher {
    public boolean matches(String var1);

    public String getDescription();

    public static class Regexp
    implements TextMatcher {
        private final String pattern;

        public Regexp(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String html) {
            Matcher matcher = Pattern.compile(this.pattern, 32).matcher(html);
            return matcher.matches();
        }

        @Override
        public String getDescription() {
            return "matches /" + this.pattern + "/";
        }
    }

    public static class Exact
    implements TextMatcher {
        private final String str;

        public Exact(String str) {
            this.str = str;
        }

        @Override
        public boolean matches(String html) {
            return html.equals(this.str);
        }

        @Override
        public String getDescription() {
            return "'" + this.str + "'";
        }
    }
}

