/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testrunner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.codehaus.jettison.json.JSONException;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.UnitTestName;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.testrunner.BrowserJSJavaBridge;
import org.flasck.flas.testrunner.JSCaughtException;
import org.flasck.flas.testrunner.JSTestState;
import org.flasck.flas.testrunner.JVMRunner;
import org.flasck.flas.testrunner.TestResultWriter;
import org.flasck.jvm.fl.FlasTestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.sync.LockingCounter;

public class SingleJSTest {
    static final Logger logger = LoggerFactory.getLogger((String)"SingleJSTest");
    static String patienceChild = System.getProperty("org.flasck.patience.child");
    boolean wantTimeout = patienceChild == null || !patienceChild.equals("true");
    private BrowserJSJavaBridge bridge;
    private final LockingCounter counter;
    private final List<String> errors;
    private final TestResultWriter pw;
    private final NameOfThing utn;
    final JSTestState state;
    private boolean error = false;

    public SingleJSTest(BrowserJSJavaBridge bridge, LockingCounter counter, List<String> errors, TestResultWriter pw, NameOfThing name) {
        this.bridge = bridge;
        this.counter = counter;
        this.errors = errors;
        this.pw = pw;
        this.utn = name;
        this.state = new JSTestState(this);
    }

    public void create(CountDownLatch cdl) throws JSONException, InterruptedException {
        if (this.utn instanceof UnitTestName) {
            this.bridge.prepareUnitTest(this.utn.container(), this.utn.baseName());
        } else {
            this.bridge.prepareSystemTest(this.utn);
        }
        if (this.wantTimeout) {
            boolean isReady = cdl.await(25L, TimeUnit.SECONDS);
            if (!isReady) {
                throw new CantHappenException("the test steps were not made available");
            }
        } else {
            cdl.await();
        }
    }

    public void prepareStage(CountDownLatch cdl, SystemTestStage e) throws JSONException, InterruptedException {
        logger.info("prepareStage: cdl = " + cdl.getCount());
        this.bridge.prepareStage(e.name.baseName());
        boolean isReady = cdl.await(25L, TimeUnit.SECONDS);
        logger.info("prepareStage: cdl = " + cdl.getCount() + " isr = " + isReady);
        if (!isReady) {
            throw new CantHappenException("the test steps were not made available");
        }
    }

    public void step(String desc, String s) {
        if (this.error) {
            return;
        }
        ArrayList<Throwable> excs = new ArrayList<Throwable>();
        logger.info("calling " + desc + " step " + s);
        try {
            this.counter.start("JS runstep");
            this.runStep(s);
            this.counter.waitForZero(15000);
            logger.info("step " + s + " has finished");
        }
        catch (JSCaughtException t) {
            excs.add(t);
            logger.warn("step " + s + " failed with " + t.getMessage());
        }
        catch (Throwable t) {
            logger.warn("Error waiting for test to end", t);
            this.pw.error("JS", desc, t);
            this.errors.add("JS ERROR " + (desc == null ? "configure" : desc));
        }
        this.handleExceptions(desc, excs);
    }

    public void runStep(String step) throws InterruptedException, JSONException, TimeoutException {
        logger.info("running step " + step);
        this.bridge.runStep(step);
    }

    public void checkContextSatisfied(String desc) {
        ArrayList<Throwable> excs = new ArrayList<Throwable>();
        try {
            this.counter.start("JS assert satisfied");
            this.bridge.checkContextSatisfied();
            this.counter.waitForZero(15000);
        }
        catch (JSCaughtException t) {
            excs.add(t);
        }
        catch (Throwable t) {
            logger.warn("Error waiting for test to end", t);
            this.pw.error("JS", desc, t);
            this.errors.add("JS ERROR " + (desc == null ? "configure" : desc));
        }
        this.handleExceptions(desc, excs);
    }

    private void handleExceptions(String desc, List<Throwable> excs) {
        if (!excs.isEmpty()) {
            Throwable t = excs.get(0);
            if (this.state != null) {
                ++this.state.failed;
            }
            if (t instanceof FlasTestException) {
                JVMRunner.handleError("JS", this.errors, this.pw, null, desc, t);
                return;
            }
            if (t instanceof TimeoutException) {
                this.pw.fail("JS", "step timed out");
            } else {
                String jsex = t.getMessage();
                if (jsex == null) {
                    this.pw.error("JS", "unknown exception", t);
                } else {
                    if (jsex.startsWith("Error: NSV\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println(jsex.substring(jsex.indexOf(10) + 1));
                        return;
                    }
                    if (jsex.startsWith("Error: EXP\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println(jsex.substring(jsex.indexOf(10) + 1));
                        return;
                    }
                    if (jsex.startsWith("Error: UNUSED\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println("  Expectation not called: " + jsex.substring(jsex.indexOf(10) + 3));
                        return;
                    }
                    if (jsex.startsWith("Error: EXPCAN\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println(jsex.substring(jsex.indexOf(10) + 1));
                        return;
                    }
                    if (jsex.startsWith("Error: UECAN\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println(jsex.substring(jsex.indexOf(10) + 1));
                        return;
                    }
                    if (jsex.startsWith("Error: MATCH\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println(jsex.substring(jsex.indexOf(10) + 1));
                        return;
                    }
                    if (jsex.startsWith("Error: NEWDIV\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println("incorrect number of divs created");
                        this.pw.println(jsex.substring(jsex.indexOf(10) + 1));
                        return;
                    }
                    if (jsex.startsWith("Error: NOHDLR\n")) {
                        this.pw.fail("JS", desc);
                        this.errors.add("JS FAIL " + desc);
                        this.pw.println(jsex.substring(jsex.indexOf(10) + 1));
                        return;
                    }
                }
            }
            this.pw.error("JS", desc, t);
            this.errors.add("JS ERROR " + (desc == null ? "configure" : desc));
        }
    }

    public boolean ok() {
        return !this.error && this.state.failed == 0;
    }
}

