/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testrunner;

import java.io.File;
import java.io.FileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.servlet.basic.InputStreamResponder;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.ziwsh.intf.Param;

public class RunTestHandler
extends InputStreamResponder
implements RequestProcessor,
RequestPathParameters {
    static final Logger logger = LoggerFactory.getLogger((String)"JSRunner");
    private final File basePath;
    private final File flasck;
    private String test;

    public RunTestHandler(@Param(value="path") File basePath, @Param(value="flasck") File flasck) {
        this.basePath = new File(basePath.getPath().replace("%20", " "));
        this.flasck = flasck;
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if ("*".equals(name)) {
            this.test = value;
        }
    }

    public void process(Responder r) throws Exception {
        File f = this.test.startsWith("/html/flasck") ? new File(this.flasck, this.test.substring(5)) : new File(this.basePath, this.test);
        logger.info("requested file " + f + " exists: " + f.exists());
        String contentType = null;
        if (f.getName().endsWith(".html")) {
            contentType = "text/html";
        } else if (f.getName().endsWith(".js")) {
            contentType = "text/javascript";
        } else if (f.getName().endsWith(".css")) {
            contentType = "text/css";
        }
        if (this.test == null) {
            r.setStatus(400);
            r.write("cannot run test without a valid path", null);
            r.done();
        } else if (contentType == null) {
            r.setStatus(400);
            r.write("cannot find content type for " + this.test, null);
            r.done();
        } else {
            this.sendBinary(r, new FileInputStream(f), contentType, f.length());
        }
    }

    public void hasSegment(String segment) {
    }

    public void integerValue(String name, int value, ParameterSource source) {
    }

    public void doubleValue(String name, double value, ParameterSource source) {
    }
}

