/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testrunner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.flasck.flas.Configuration;
import org.flasck.flas.compiler.jsgen.packaging.JSStorage;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.testrunner.BridgeGenHandler;
import org.flasck.flas.testrunner.BrowserJSJavaBridge;
import org.flasck.flas.testrunner.CommonTestRunner;
import org.flasck.flas.testrunner.JSCaughtException;
import org.flasck.flas.testrunner.JSTestState;
import org.flasck.flas.testrunner.RunTestHandler;
import org.flasck.flas.testrunner.SingleJSTest;
import org.flasck.flas.testrunner.TestResultWriter;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.FileContentObject;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.ziniki.server.CentralServerStore;
import org.ziniki.server.NewConnectionHandler;
import org.ziniki.server.di.DehydratedHandler;
import org.ziniki.server.di.Instantiatable;
import org.ziniki.server.di.Instantiator;
import org.ziniki.server.di.MakeAHandler;
import org.ziniki.server.grizzly.GrizzlyTDAServer;
import org.ziniki.server.grizzly.GrizzlyTDAWebSocketHandler;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.path.SimplePathTree;
import org.ziniki.server.tda.Transport;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.servlet.tda.TDAConfiguration;
import org.ziniki.ziwsh.intf.WSProcessor;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.sync.LockingCounter;
import org.zinutils.utils.FileUtils;

public class JSRunner
extends CommonTestRunner<JSTestState> {
    static String jsPortNum = System.getProperty("org.flasck.jsrunner.port");
    static int jsPort = jsPortNum != null ? Integer.parseInt(jsPortNum) : 14040;
    static String showOption = System.getProperty("org.ziniki.chrome.show");
    static boolean headless = showOption == null || !showOption.equalsIgnoreCase("true");
    static String chromeRoot = System.getProperty("org.ziniki.chrome.root");
    static String chromeDriver = System.getProperty("org.ziniki.chrome.driver");
    static String chromeBinary = System.getProperty("org.ziniki.chrome.binary");
    static String headlessBinary = System.getProperty("org.ziniki.headless.binary");
    static String patienceChild = System.getProperty("org.flasck.patience.child");
    boolean wantTimeout = patienceChild == null || !patienceChild.equals("true");
    private final JSStorage jse;
    private BrowserJSJavaBridge bridge = null;
    private WebDriver wd = null;
    private WebDriver.Navigation nav;
    private List<String> testSteps;
    private CountDownLatch cdl;
    private File flasckPath;
    private File basePath;
    private String htmlUri;
    final ClassLoader classloader;
    private boolean useCachebuster = false;
    private String jstestdir;
    private String specifiedTestName;
    final LockingCounter counter = new LockingCounter();
    private boolean haveflascklib;
    private GrizzlyTDAServer server;

    public JSRunner(Configuration config, Repository repository, JSStorage jse, Map<String, String> templates, ClassLoader cl) throws Exception {
        super(config, repository);
        if (chromeRoot == null || !new File(chromeRoot).exists()) {
            throw new InvalidUsageException("must specify org.ziniki.chrome.root as a directory with driver and binary");
        }
        if (chromeDriver == null || !new File(chromeRoot, chromeDriver).exists()) {
            throw new InvalidUsageException("must specify org.ziniki.chrome.driver as a directory under chrome_root with driver");
        }
        if (!(headless || chromeBinary != null && new File(chromeRoot, chromeBinary).exists())) {
            throw new InvalidUsageException("must specify org.ziniki.chrome.binary as a directory under chrome_root with chrome binary");
        }
        if (headless && (headlessBinary == null || !new File(chromeRoot, headlessBinary).exists())) {
            throw new InvalidUsageException("must specify org.ziniki.headless.binary as a directory under chrome_root with headless binary");
        }
        System.setProperty("webdriver.chrome.driver", chromeRoot + "/" + chromeDriver);
        if (config != null) {
            this.jstestdir = config.jsTestDir();
            this.specifiedTestName = config.specifiedTestName;
            this.haveflascklib = config.flascklibDir != null;
        } else {
            this.jstestdir = System.getProperty("user.dir");
            this.specifiedTestName = null;
        }
        this.jse = jse;
        this.classloader = cl;
        this.flasckPath = new File(new File(System.getProperty("user.dir")), "src/main/resources");
        this.buildHTML(templates);
    }

    public void launch() throws Exception {
        if (this.server == null) {
            this.startServer();
            this.startDriver();
            this.visitUri(this.htmlUri);
        }
    }

    public void stepsForTest(List<String> steps) {
        this.testSteps = steps;
        this.cdl.countDown();
    }

    public void systemTestPrepared() {
        this.cdl.countDown();
    }

    private void startServer() throws Exception {
        this.server = new GrizzlyTDAServer(jsPort);
        SimplePathTree tree = new SimplePathTree();
        TreeMap items = new TreeMap();
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("class", BridgeGenHandler.class.getName());
        map.put("server", this.server);
        map.put("moduleDir", this.config.moduleDir);
        map.put("sources", this.jse.packageNames());
        map.put("unitTests", this.jse.unitTests());
        map.put("systemTests", this.jse.systemTests());
        map.put("modules", this.config.modules);
        tree.add("/gen/*", (MakeAHandler)new DehydratedHandler((Instantiatable)new Instantiator("gen", map), items));
        map = new TreeMap();
        map.put("class", RunTestHandler.class.getName());
        map.put("path", this.basePath);
        map.put("flasck", this.flasckPath);
        tree.add("/test/*", (MakeAHandler)new DehydratedHandler((Instantiatable)new Instantiator("test", map), items));
        this.server.httpMappingTree((PathTree)tree);
        SimplePathTree wstree = new SimplePathTree();
        wstree.add("/bridge", (MakeAHandler)new MakeAHandler<WSProcessor>(){

            public WSProcessor instantiate(TDAConfiguration c) throws Exception {
                BrowserJSJavaBridge bridge;
                JSRunner.this.bridge = bridge = new BrowserJSJavaBridge(JSRunner.this, JSRunner.this.classloader, JSRunner.this.config.projectDir, JSRunner.this.counter);
                return bridge;
            }
        });
        NewConnectionHandler<WSReceiver> handler = new NewConnectionHandler<WSReceiver>(){

            public void newConnection(Transport transport, WSReceiver handler) {
                transport.addReceiver(handler);
            }
        };
        this.server.wsMappingTree((CentralServerStore)new GrizzlyTDAWebSocketHandler(), (PathTree)wstree, (NewConnectionHandler)handler);
        this.server.start();
    }

    public void startDriver() {
        ChromeOptions options = new ChromeOptions();
        if (headless) {
            options.addArguments(new String[]{"--headless=new"});
            options.setBinary(new File(new File(chromeRoot), headlessBinary));
        } else {
            options.setBinary(new File(new File(chromeRoot), chromeBinary));
        }
        this.wd = new ChromeDriver(options);
        this.nav = this.wd.navigate();
    }

    private void visitUri(String uri) throws InterruptedException {
        this.cdl = new CountDownLatch(1);
        this.nav.to("http://localhost:" + jsPort + "/" + uri);
        if (this.wantTimeout) {
            boolean isReady = this.cdl.await(25L, TimeUnit.SECONDS);
            if (!isReady) {
                this.server.stop();
                this.server = null;
                throw new CantHappenException("the test server did not become available");
            }
        } else {
            this.cdl.await();
        }
    }

    public void ready() {
        this.cdl.countDown();
    }

    @Override
    public void runUnitTest(TestResultWriter pw, UnitTestCase utc) {
        if (!utc.shouldRunJS()) {
            logger.warn("not running " + utc.description + " in JS because it contains services");
            return;
        }
        String desc = utc.description;
        try {
            this.launch();
            if (!this.haveflascklib) {
                pw.fail("JS", desc + ": cannot run tests without flascklib");
                return;
            }
            SingleJSTest t1 = new SingleJSTest(this.bridge, this.counter, this.errors, pw, utc.name);
            this.cdl = new CountDownLatch(1);
            t1.create(this.cdl);
            String name = "dotest";
            this.runSteps(pw, desc, t1, name);
        }
        catch (Exception ex) {
            pw.error("JS", desc + ": " + ex.getMessage(), ex);
        }
    }

    private void runSteps(TestResultWriter pw, String desc, SingleJSTest t1, String name) {
        List<String> steps = this.testSteps;
        if (desc != null) {
            pw.begin("JS", desc);
        }
        for (String s : steps) {
            if (t1.state != null && t1.state.failed > 0) break;
            if (desc != null) {
                pw.begin("JS", desc + ": " + s);
            }
            t1.step(desc, s);
        }
        t1.checkContextSatisfied(desc);
        if (desc != null && t1.ok()) {
            pw.pass("JS", desc);
        } else if (!t1.ok() && this.errors.isEmpty()) {
            this.errors.add("JS ERROR " + (desc == null ? "configure" : desc));
        }
    }

    public void error(String err) {
        System.out.println("error = " + err);
        this.counter.raise((RuntimeException)new JSCaughtException(err));
    }

    @Override
    protected JSTestState createSystemTest(TestResultWriter pw, SystemTest st) {
        pw.systemTest("JS", st);
        try {
            this.launch();
            SingleJSTest t1 = new SingleJSTest(this.bridge, this.counter, this.errors, pw, st.name());
            this.cdl = new CountDownLatch(1);
            t1.create(this.cdl);
            return t1.state;
        }
        catch (Exception ex) {
            pw.error("JS", "desc: " + ex.getMessage(), ex);
            return null;
        }
    }

    @Override
    protected void runSystemTestStage(TestResultWriter pw, JSTestState state, SystemTest st, SystemTestStage e) {
        try {
            this.cdl = new CountDownLatch(1);
            state.test.prepareStage(this.cdl, e);
            this.runSteps(pw, e.desc, state.test, e.name.baseName());
        }
        catch (Exception ex) {
            pw.error("JS", "desc: " + ex.getMessage(), ex);
        }
        if (!state.test.ok()) {
            ++state.failed;
        }
    }

    @Override
    protected void cleanupSystemTest(TestResultWriter pw, JSTestState state, SystemTest st) {
        if (state.failed == 0) {
            pw.passedSystemTest("JS", st);
        } else {
            pw.println("JS " + st.name().uniqueName() + " " + state.failed + " stages failed");
        }
    }

    private void buildHTML(Map<String, String> templates) {
        try {
            String testName = this.specifiedTestName != null ? this.config.specifiedTestName : "test";
            List css = null;
            File webdir = new File(this.jstestdir + "/web");
            if (webdir.exists()) {
                css = FileUtils.findFilesMatching((File)webdir, (String)"*.css");
            }
            String testDir = this.jstestdir + "/html";
            FileUtils.cleanDirectory((File)new File(testDir));
            String testDirJS = testDir + "/js";
            File testDirCSS = new File(testDir + "/css");
            FileUtils.assertDirectory((File)new File(testDirJS));
            File html = new File(testDir, testName + ".html");
            this.basePath = this.config.projectDir;
            if (this.basePath == null) {
                this.basePath = new File(System.getProperty("user.dir"));
            } else if (!this.basePath.isAbsolute()) {
                this.basePath = FileUtils.combine((File)new File(System.getProperty("user.dir")), (File)this.basePath);
            }
            this.basePath = new File(this.basePath.getPath().replace(" ", "%20"));
            this.htmlUri = "test/html/" + testName + ".html";
            PrintWriter pw = new PrintWriter(html);
            pw.println("<!DOCTYPE html>");
            pw.println("<html>");
            pw.println("<head>");
            pw.println("<link rel=\"icon\" href=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAIAAACQd1PeAAAADElEQVQI12P4//8/AAX+Av7czFnnAAAAAElFTkSuQmCC\">");
            pw.println("<script type='importmap'>");
            pw.println("{");
            pw.println("\t\"imports\": {");
            boolean prev = false;
            Iterable<ContentObject> jsfiles = this.jse.jsIncludes("mock");
            ArrayList<FileContentObject> thenUse = new ArrayList<FileContentObject>();
            File jsdir = new File(testDir, "js");
            for (ContentObject contentObject : jsfiles) {
                File copyTo = new File(jsdir, contentObject.key());
                FileUtils.copyStreamToFile((InputStream)contentObject.asStream(), (File)copyTo);
                FileContentObject as = new FileContentObject(copyTo);
                thenUse.add(as);
                this.importMapName(pw, prev, (ContentObject)as);
                prev = true;
            }
            if (prev) {
                pw.println("");
            }
            pw.println("\t}");
            pw.println("}");
            pw.println("</script>");
            if (css != null && !css.isEmpty()) {
                FileUtils.assertDirectory((File)testDirCSS);
                for (File file : css) {
                    FileUtils.copy((File)file, (File)testDirCSS);
                    pw.println("  <link rel='stylesheet' type='text/css' href='/test/html/css/" + file.getName() + "'>");
                }
            }
            for (Map.Entry entry : templates.entrySet()) {
                this.renderTemplate(pw, (String)entry.getKey(), (String)entry.getValue());
            }
            for (ContentObject contentObject : thenUse) {
                this.includeAsScript(pw, contentObject);
            }
            pw.println("<script src='/gen/run.js' type='module'></script>");
            pw.println("</head>");
            pw.println("<body>");
            pw.println("</body>");
            pw.println("</html>");
            pw.close();
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    private void renderTemplate(PrintWriter pw, String name, String template) {
        pw.println("<template id='" + name.replace(".html", "") + "'>");
        pw.println(template);
        pw.println("</template>");
    }

    private void importMapName(PrintWriter pw, boolean prev, ContentObject co) {
        if (prev) {
            pw.println(",");
        }
        String path = this.fcoFileName(co);
        pw.print("\t\t\"/js/" + new File(path).getName() + "\": \"/test/html/" + path + "\"");
    }

    private void includeAsScript(PrintWriter pw, ContentObject co) {
        String path = this.fcoFileName(co);
        pw.println("<script src='" + path + "' type='module'></script>");
    }

    private String fcoFileName(ContentObject co) {
        Object path = co.url();
        if (co instanceof FileContentObject) {
            if (((String)(path = ((String)path).replace("file://", ""))).startsWith(this.flasckPath.toString())) {
                path = ((String)path).replace(this.flasckPath.toString() + "/", "");
            } else if (((String)path).startsWith(this.basePath.toString())) {
                if (((String)(path = ((String)path).replace(this.basePath.toString(), ""))).startsWith("/html/")) {
                    path = ((String)path).replace("/html/", "");
                }
            } else {
                throw new CantHappenException("what is this path? " + (String)path);
            }
        }
        if (this.useCachebuster) {
            path = (String)path + "?cachebuster=" + System.currentTimeMillis();
        }
        return path;
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.stop(1, TimeUnit.SECONDS);
        }
        if (this.wd != null) {
            this.wd.close();
            this.wd.quit();
        }
        if (this.bridge != null) {
            this.bridge.waitForShutdown();
        }
    }
}

