/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testrunner;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.Configuration;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.parsedForm.ut.UnitTestPackage;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.testrunner.Expectation;
import org.flasck.flas.testrunner.Invocation;
import org.flasck.flas.testrunner.TestResultWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.UtilException;
import org.zinutils.utils.FileUtils;

public abstract class CommonTestRunner<T extends CommonState> {
    protected static Logger logger = LoggerFactory.getLogger((String)"TestRunner");
    protected final Configuration config;
    protected final String compiledPkg;
    protected final String testPkg;
    protected final Map<String, CardDefinition> cdefns = new TreeMap<String, CardDefinition>();
    protected final List<Expectation> expectations = new ArrayList<Expectation>();
    protected final List<Invocation> invocations = new ArrayList<Invocation>();
    protected final List<String> errors = new ArrayList<String>();
    protected final Repository repository;

    public CommonTestRunner(Configuration config, Repository repository) {
        this.config = config;
        this.repository = repository;
        this.testPkg = null;
        this.compiledPkg = null;
    }

    public void runAllUnitTests(final Map<File, TestResultWriter> writers) {
        this.repository.traverse(new LeafAdapter(){
            TestResultWriter pw;

            @Override
            public void visitUnitTestPackage(UnitTestPackage e) {
                String nn = e.name().baseName().replace("_ut_", "");
                File f = new File(nn);
                this.pw = (TestResultWriter)writers.get(f);
                if (this.pw == null) {
                    File trd = CommonTestRunner.this.config.writeTestReportsTo();
                    if (trd == null) {
                        this.pw = new TestResultWriter(false, System.out);
                    } else {
                        FileUtils.assertDirectory((File)trd);
                        File out = new File(trd, FileUtils.ensureExtension((String)f.getName(), (String)".tr"));
                        try {
                            this.pw = new TestResultWriter(true, out);
                        }
                        catch (FileNotFoundException ex) {
                            CommonTestRunner.this.config.errors.message((InputPosition)null, "cannot create output file " + out);
                        }
                    }
                    if (this.pw != null) {
                        writers.put(f, this.pw);
                    }
                }
            }

            @Override
            public void visitUnitTest(UnitTestCase e) {
                if (this.pw != null) {
                    CommonTestRunner.this.runUnitTest(this.pw, e);
                }
            }
        });
    }

    public void runAllSystemTests(final Map<File, TestResultWriter> writers) {
        this.repository.traverse(new LeafAdapter(){
            TestResultWriter pw;

            @Override
            public void visitSystemTest(SystemTest e) {
                String nn = e.name().baseName().replaceFirst(".*_st_", "");
                File f = new File(nn);
                this.pw = (TestResultWriter)writers.get(f);
                if (this.pw == null) {
                    File trd = CommonTestRunner.this.config.writeTestReportsTo();
                    if (trd == null) {
                        this.pw = new TestResultWriter(false, System.out);
                    } else {
                        FileUtils.assertDirectory((File)trd);
                        File out = new File(trd, FileUtils.ensureExtension((String)f.getName(), (String)".tr"));
                        try {
                            this.pw = new TestResultWriter(true, out);
                        }
                        catch (FileNotFoundException ex) {
                            CommonTestRunner.this.config.errors.message((InputPosition)null, "cannot create output file " + out);
                        }
                    }
                    if (this.pw != null) {
                        writers.put(f, this.pw);
                    }
                }
                if (this.pw != null) {
                    CommonTestRunner.this.runSystemTest(this.pw, e);
                }
            }
        });
    }

    public void reportErrors(ErrorReporter reporter) {
        for (String s : this.errors) {
            reporter.message((InputPosition)null, s);
        }
    }

    public abstract void runUnitTest(TestResultWriter var1, UnitTestCase var2);

    public void runSystemTest(TestResultWriter pw, SystemTest st) {
        logger.info(this.getClass().getSimpleName() + " running system test " + st);
        T state = this.createSystemTest(pw, st);
        if (state == null) {
            return;
        }
        if (st.configure != null) {
            this.runSystemTestStage(pw, state, st, st.configure);
        }
        for (SystemTestStage e : st.stages) {
            this.runSystemTestStage(pw, state, st, e);
        }
        if (st.cleanup != null) {
            this.runSystemTestStage(pw, state, st, st.cleanup);
        }
        this.cleanupSystemTest(pw, state, st);
    }

    protected abstract T createSystemTest(TestResultWriter var1, SystemTest var2);

    protected abstract void runSystemTestStage(TestResultWriter var1, T var2, SystemTest var3, SystemTestStage var4);

    protected abstract void cleanupSystemTest(TestResultWriter var1, T var2, SystemTest var3);

    protected void assertAllInvocationsCalled() {
        for (Invocation invocation : this.invocations) {
            System.out.println("Should have expected: " + invocation);
        }
        this.invocations.clear();
        for (Expectation expectation : this.expectations) {
            System.out.println("Expected, not called: " + expectation);
        }
        if (!this.expectations.isEmpty()) {
            throw new UtilException("Not all expectations happened");
        }
    }

    public static class CommonState {
        int failed;
    }
}

