/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testrunner;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.testrunner.JSJavaBridge;
import org.flasck.flas.testrunner.JSRunner;
import org.flasck.jvm.fl.JVMTestPlugin;
import org.flasck.jvm.fl.TestModuleLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.ziwsh.intf.WSResponder;
import org.zinutils.bytecode.BCEClassLoader;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.reflection.Reflection;
import org.zinutils.sync.LockingCounter;

public class BrowserJSJavaBridge
implements JSJavaBridge,
WSReceiver,
TestModuleLoader {
    protected static Logger logger = LoggerFactory.getLogger((String)"TestRunner");
    protected static Logger debugLogger = LoggerFactory.getLogger((String)"DebugLog");
    static String patienceChild = System.getProperty("org.flasck.patience.child");
    boolean wantTimeout = patienceChild == null || !patienceChild.equals("true");
    private final JSRunner controller;
    private final ClassLoader classloader;
    private final File root;
    private final LockingCounter counter;
    protected final List<String> errors = new ArrayList<String>();
    private final Map<String, Object> modules = new HashMap<String, Object>();
    private Map<String, Object> conns = new TreeMap<String, Object>();
    private int next = 1;
    private WSResponder responder;
    private boolean readyWhenZero = false;
    private CountDownLatch shutdownCounter = new CountDownLatch(1);
    private Iterable<JVMTestPlugin> plugins;

    BrowserJSJavaBridge(JSRunner controller, ClassLoader classloader, File root, LockingCounter counter) {
        this.controller = controller;
        this.classloader = classloader;
        this.root = root;
        this.counter = counter;
        this.plugins = ServiceLoader.load(JVMTestPlugin.class);
        for (JVMTestPlugin p : this.plugins) {
            p.ready((TestModuleLoader)this, classloader);
        }
        if (classloader instanceof BCEClassLoader) {
            for (JVMTestPlugin p : ((BCEClassLoader)classloader).services(JVMTestPlugin.class)) {
                p.ready((TestModuleLoader)this, classloader);
            }
        }
    }

    public void open(WSResponder responder) {
        this.responder = responder;
        logger.info("opened bridge " + this + " with " + responder);
    }

    public void onText(WSResponder responder, String text) {
        logger.info("received " + text);
        try {
            JSONObject jo = new JSONObject(text);
            String action = jo.getString("action");
            if (jo.has("conn")) {
                String c = jo.getString("conn");
                int reqId = jo.getInt("requestId");
                Object module = this.conns.get(c);
                JSONArray ja = jo.getJSONArray("args");
                Object[] args = new Object[ja.length()];
                for (int i = 0; i < ja.length(); ++i) {
                    args[i] = ja.get(i);
                }
                Object resp = Reflection.call((Object)module, (String)action, (Object[])args);
                if (resp == null || !(resp instanceof JSONObject)) {
                    resp = new JSONObject();
                }
                ((JSONObject)resp).put("action", (Object)"response").put("respondingTo", reqId);
                this.sendJson(resp.toString());
                return;
            }
            switch (action) {
                case "ready": {
                    if (this.counter.isZero()) {
                        this.controller.ready();
                        break;
                    }
                    this.readyWhenZero = true;
                    break;
                }
                case "steps": {
                    JSONArray arr = jo.getJSONArray("steps");
                    ArrayList<String> steps = new ArrayList<String>();
                    for (int i = 0; i < arr.length(); ++i) {
                        steps.add(arr.getString(i));
                    }
                    this.controller.stepsForTest(steps);
                    break;
                }
                case "systemTestPrepared": {
                    this.controller.systemTestPrepared();
                    break;
                }
                case "error": {
                    this.controller.error(jo.getString("error"));
                    break;
                }
                case "log": 
                case "debugmsg": {
                    logger.warn(jo.getString("message"));
                    break;
                }
                case "lock": {
                    this.lock(jo.getString("msg"));
                    break;
                }
                case "unlock": {
                    this.unlock(jo.getString("msg"));
                    break;
                }
                case "module": {
                    String name = jo.getString("name");
                    Object ret = this.module(name);
                    String conn = "conn" + this.next++;
                    this.conns.put(conn, ret);
                    this.sendJson(new JSONObject().put("action", (Object)"haveModule").put("name", (Object)name).put("clz", (Object)"ZinTestModule").put("conn", (Object)conn).toString());
                    break;
                }
                default: {
                    throw new InvalidUsageException("there is no action '" + action + "'");
                }
            }
        }
        catch (Throwable ex) {
            logger.error("error processing " + text, ex);
        }
    }

    public void prepareUnitTest(NameOfThing pkg, String test) throws JSONException {
        this.sendJson(new JSONObject().put("action", (Object)"prepareUnitTest").put("wrapper", (Object)pkg.uniqueName()).put("testname", (Object)test).toString());
    }

    public void prepareSystemTest(NameOfThing pkg) throws JSONException {
        this.sendJson(new JSONObject().put("action", (Object)"prepareSystemTest").put("testclz", (Object)pkg.uniqueName()).toString());
    }

    public void prepareStage(String baseName) throws JSONException {
        this.sendJson(new JSONObject().put("action", (Object)"prepareStage").put("stage", (Object)baseName).toString());
    }

    public void runStep(String step) throws JSONException {
        this.sendJson(new JSONObject().put("action", (Object)"runStep").put("step", (Object)step).toString());
    }

    public void checkContextSatisfied() throws JSONException {
        this.sendJson(new JSONObject().put("action", (Object)"assertSatisfied").toString());
    }

    public void error() {
        logger.error("error on chrome ws");
    }

    @Override
    public void error(String s) {
        this.errors.add(s);
    }

    @Override
    public void log(String s) {
        logger.info(s);
    }

    @Override
    public void debugmsg(String s) {
        debugLogger.info(s);
    }

    public void register(String ctr, String impl) {
    }

    public void configureModule(String name, Class<?> clz) {
        try {
            this.modules.put(name, Reflection.callStatic(clz, (String)"createChrome", (Object[])new Object[]{this, this.classloader, this.root}));
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public Object module(String name) {
        if (!this.modules.containsKey(name)) {
            throw new InvalidUsageException("there is no loaded module '" + name + "'");
        }
        return this.modules.get(name);
    }

    @Override
    public void sendJson(String json) {
        logger.info("sending " + json);
        this.responder.send(json);
    }

    public void lock(String msg) {
        this.counter.lock("lock " + msg);
        logger.info("lock " + msg + ": counter = " + this.counter.getCount());
    }

    public void unlock(String msg) {
        this.counter.release("unlock " + msg);
        logger.info("unlock " + msg + ": counter = " + this.counter.getCount());
        if (this.counter.isZero() && this.readyWhenZero) {
            this.controller.ready();
            this.readyWhenZero = false;
        }
    }

    @Override
    public LockingCounter getTestCounter() {
        return this.counter;
    }

    public void close(Object t) {
        logger.info("closed bridge " + this + " with " + this.responder);
        for (Object m : this.conns.values()) {
            logger.info("need to clean up module " + m);
            if (!(m instanceof Closeable)) continue;
            try {
                ((Closeable)m).close();
            }
            catch (IOException ex) {
                logger.error("error closing module " + m, (Throwable)ex);
            }
        }
        this.responder = null;
        this.shutdownCounter.countDown();
    }

    public void waitForShutdown() {
        try {
            if (this.wantTimeout) {
                if (!this.shutdownCounter.await(15L, TimeUnit.SECONDS)) {
                    logger.error("timed out waiting for bridge to be closed");
                }
            } else {
                this.shutdownCounter.await();
            }
        }
        catch (InterruptedException ex) {
            logger.error("interrupted waiting for bridge to be closed");
        }
    }
}

