/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testrunner;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.ziniki.server.grizzly.GrizzlyTDAServer;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.utils.FileUtils;

public class BridgeGenHandler
implements RequestProcessor {
    private final GrizzlyTDAServer server;
    private final File moduleDir;
    private final Iterable<PackageName> sources;
    private final List<UnitTestCase> unittests;
    private final List<SystemTest> systests;
    private final List<String> modules;

    public BridgeGenHandler(@Param(value="server") GrizzlyTDAServer server, @Param(value="moduleDir") File moduleDir, @Param(value="sources") Iterable<PackageName> sources, @Param(value="unitTests") List<UnitTestCase> unittests, @Param(value="systemTests") List<SystemTest> systests, @Param(value="modules") List<String> modules) {
        this.server = server;
        this.moduleDir = moduleDir;
        this.sources = sources;
        this.unittests = unittests;
        this.systests = systests;
        this.modules = modules;
    }

    /*
     * WARNING - void declaration
     */
    public void process(Responder r) throws Exception {
        void var7_23;
        void var7_21;
        void var4_7;
        r.setStatus(200);
        r.setContentType("text/javascript");
        StringBuilder sb = new StringBuilder();
        sb.append("import { WSBridge } from '/js/flasjava.js';\n");
        for (NameOfThing nameOfThing : this.sources) {
            sb.append("import { " + nameOfThing.jsName() + " } from '/js/" + nameOfThing.uniqueName() + ".js';\n");
        }
        int mk = 0;
        boolean bl = false;
        for (String string : this.modules) {
            File mock;
            File file = new File(this.moduleDir, string);
            if (!file.isDirectory()) {
                throw new InvalidUsageException("there is no module called " + string + " in " + this.moduleDir);
            }
            File file2 = new File(file, "js");
            File core = new File(file2, "core");
            if (core.isDirectory()) {
                for (File f : FileUtils.findFilesMatching((File)core, (String)"*.js")) {
                    sb.append("import { module_init as module_init_" + mk++ + " } from '/js/" + f.getName() + "';\n");
                }
            }
            if (!(mock = new File(file2, "mock")).isDirectory()) continue;
            for (File f : FileUtils.findFilesMatching((File)mock, (String)"*.js")) {
                sb.append("import { installer as installer_" + (int)(++var4_7) + " } from '/js/" + f.getName() + "';\n");
            }
        }
        sb.append("\n");
        sb.append("var bridge = new WSBridge('localhost', " + this.server.getPort() + ");\n");
        HashSet<NameOfThing> uns = new HashSet<NameOfThing>();
        for (UnitTestCase unitTestCase : this.unittests) {
            uns.add(unitTestCase.name.container());
        }
        for (NameOfThing nameOfThing : uns) {
            sb.append("bridge.addUnitTest('" + nameOfThing.uniqueName() + "', " + nameOfThing.jsName() + ");\n");
        }
        HashSet<PackageName> hashSet = new HashSet<PackageName>();
        for (SystemTest systemTest : this.systests) {
            hashSet.add(systemTest.name());
        }
        for (NameOfThing nameOfThing : hashSet) {
            sb.append("bridge.addSystemTest('" + nameOfThing.uniqueName() + "', " + nameOfThing.jsName() + ");\n");
        }
        boolean bl2 = false;
        while (var7_21 < mk) {
            sb.append("module_init_" + (int)var7_21 + "(bridge.runner);\n");
            ++var7_21;
        }
        boolean bl3 = false;
        while (var7_23 < var4_7) {
            sb.append("installer_" + (int)var7_23 + "(bridge);\n");
            ++var7_23;
        }
        sb.append("bridge.send({ action: 'ready' });\n");
        String string = sb.toString();
        r.setContentLength((long)string.getBytes().length);
        r.write(string, null);
        r.done();
    }
}

