/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.TokenDefinition;
import org.flasck.flas.testing.golden.ParsedTokens;
import org.flasck.flas.testing.golden.grammar.MatchResult;
import org.flasck.flas.testing.golden.grammar.SeqElement;
import org.zinutils.exceptions.CantHappenException;

public class TokenElement
implements SeqElement {
    private final Grammar g;
    private final TokenDefinition td;

    public TokenElement(Grammar g, TokenDefinition td) {
        this.g = g;
        this.td = td;
    }

    @Override
    public MatchResult matchAgainst(ParsedTokens.GrammarStep mi) {
        if (mi instanceof ParsedTokens.GrammarToken) {
            ParsedTokens.GrammarToken tok = (ParsedTokens.GrammarToken)mi;
            if (this.td.isToken(this.g, tok.type, tok.text)) {
                return MatchResult.SINGLE_MATCH_ADVANCE;
            }
            return MatchResult.SINGLE_MATCH_FAILED;
        }
        throw new CantHappenException("not a token");
    }

    public String toString() {
        return "MatchToken[" + this.td.token() + "]";
    }

    @Override
    public boolean canBeSkipped() {
        return false;
    }

    public boolean canBeKeyword(String keyword) {
        return this.td.isToken(this.g, null, keyword);
    }
}

