/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.IndentDefinition;
import org.flasck.flas.grammar.ManyDefinition;
import org.flasck.flas.grammar.OptionalDefinition;
import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.grammar.SequenceDefinition;
import org.flasck.flas.grammar.TokenDefinition;
import org.flasck.flas.testing.golden.grammar.GrammarChooser;
import org.flasck.flas.testing.golden.grammar.ManyElement;
import org.flasck.flas.testing.golden.grammar.RefElement;
import org.flasck.flas.testing.golden.grammar.SeqElement;
import org.flasck.flas.testing.golden.grammar.TokenElement;
import org.flasck.flas.testing.golden.grammar.TrackProduction;
import org.zinutils.exceptions.NotImplementedException;

public class SeqReduction
implements Iterable<SeqElement> {
    private final GrammarChooser chooser;
    public final String reducesAs;
    private final List<SeqElement> matchers = new ArrayList<SeqElement>();

    public SeqReduction(GrammarChooser chooser, Grammar g, SequenceDefinition d, String name, List<Boolean> os) {
        this.chooser = chooser;
        ArrayList<String> optionNames = new ArrayList<String>();
        os = new ArrayList<Boolean>(os);
        for (int n = 0; n < d.length(); ++n) {
            SeqElement add;
            Definition x = d.nth(n);
            if (x instanceof IndentDefinition || (add = this.convert(g, x, os, optionNames)) == null) continue;
            this.matchers.add(add);
        }
        String rn = d.reducesAs(optionNames);
        this.reducesAs = rn == null ? name : rn;
        chooser.addReduction(this.reducesAs, this);
    }

    private SeqElement convert(Grammar g, Definition x, List<Boolean> os, List<String> optionNames) {
        if (x instanceof TokenDefinition) {
            TokenDefinition td = (TokenDefinition)x;
            return new TokenElement(g, td);
        }
        if (x instanceof ManyDefinition) {
            ManyDefinition md = (ManyDefinition)x;
            return new ManyElement(this.chooser, g, md);
        }
        if (x instanceof RefDefinition) {
            RefDefinition rd = (RefDefinition)x;
            return new RefElement(this.chooser, rd);
        }
        if (x instanceof OptionalDefinition) {
            OptionalDefinition od = (OptionalDefinition)x;
            boolean include = os.remove(0);
            if (!include) {
                return null;
            }
            optionNames.add(od.reducesAs());
            return this.convert(g, od.childRule(), os, optionNames);
        }
        throw new NotImplementedException("converting " + x + " of " + x.getClass());
    }

    public boolean canBeKeyword(String keyword) {
        if (!this.canMatchOneToken()) {
            return false;
        }
        if (this.matchers.get(0) instanceof TokenElement) {
            return ((TokenElement)this.matchers.get(0)).canBeKeyword(keyword);
        }
        return false;
    }

    public boolean canMatchOneToken() {
        int cnt = 0;
        for (SeqElement m : this.matchers) {
            if (!(m instanceof TokenElement) && !(m instanceof RefElement)) continue;
            ++cnt;
        }
        return cnt <= 1;
    }

    public TrackProduction choose(String rule) {
        if (!this.canMatchOneToken()) {
            return null;
        }
        for (SeqElement m : this.matchers) {
            if (m instanceof RefElement) {
                return ((RefElement)m).choose(rule);
            }
            if (!(m instanceof ManyElement)) continue;
            return ((ManyElement)m).choose(rule);
        }
        return null;
    }

    @Override
    public Iterator<SeqElement> iterator() {
        return this.matchers.iterator();
    }

    public String toString() {
        return this.reducesAs + ":Seq";
    }
}

