/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.IndentDefinition;
import org.flasck.flas.grammar.OptionalDefinition;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.grammar.SequenceDefinition;
import org.flasck.flas.testing.golden.grammar.GrammarChooser;
import org.flasck.flas.testing.golden.grammar.IndentAs;
import org.flasck.flas.testing.golden.grammar.SeqReduction;
import org.flasck.flas.testing.golden.grammar.TokenProduction;
import org.flasck.flas.testing.golden.grammar.TrackProduction;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.exceptions.CantHappenException;

public class SeqProduction
implements TrackProduction {
    private final GrammarChooser chooser;
    private final Grammar grammar;
    private final String name;
    private final SequenceDefinition d;
    private final Map<String, SeqReduction> reduceAs = new TreeMap<String, SeqReduction>();
    private TrackProduction indent;

    public SeqProduction(GrammarChooser chooser, Grammar g, String name, SequenceDefinition d) {
        this.chooser = chooser;
        this.grammar = g;
        this.name = name;
        this.d = d;
    }

    public SeqProduction(GrammarChooser chooser, Grammar g, String reduction, SeqReduction reducer) {
        this.chooser = chooser;
        this.grammar = g;
        this.name = reduction;
        this.d = null;
        this.reduceAs.put(reduction, reducer);
    }

    @Override
    public void initWhenReady(Production prod) {
        List<List<Boolean>> opts = this.figureOptions();
        for (List<Boolean> os : opts) {
            SeqReduction that = new SeqReduction(this.chooser, this.grammar, this.d, this.name, os);
            this.reduceAs.put(that.reducesAs, that);
        }
        this.indent = this.figureIndent();
    }

    private List<List<Boolean>> figureOptions() {
        ArrayList<List<Boolean>> ret = new ArrayList<List<Boolean>>();
        int cnt = 0;
        for (int i = 0; i < this.d.length(); ++i) {
            if (!(this.d.nth(i) instanceof OptionalDefinition)) continue;
            ++cnt;
        }
        for (int j = 0; j < 1 << cnt; ++j) {
            ArrayList<Boolean> it = new ArrayList<Boolean>();
            ret.add(it);
            for (int k = 0; k < cnt; ++k) {
                it.add(0, (j & 1 << k) != 0);
            }
        }
        return ret;
    }

    private TrackProduction figureIndent() {
        Definition last = this.d.nth(this.d.length() - 1);
        if (!(last instanceof IndentDefinition)) {
            if (!this.d.borrowFinalIndent()) {
                return null;
            }
            RefDefinition rd = (RefDefinition)last;
            String refersTo = rd.ruleName();
            Production other = this.grammar.findRule(refersTo);
            SequenceDefinition od = (SequenceDefinition)other.defn;
            last = od.nth(od.length() - 1);
        }
        IndentDefinition id = (IndentDefinition)last;
        String r = id.reducesTo();
        Definition rd = id.indented();
        TrackProduction rule = null;
        if (rd instanceof RefDefinition) {
            RefDefinition rrd = (RefDefinition)rd;
            rule = this.chooser.rule(rrd.ruleName());
            if (rule instanceof TokenProduction) {
                r = rrd.ruleName();
            }
        } else {
            throw new CantHappenException("rd is " + rd.getClass());
        }
        if (r == null) {
            return rule;
        }
        return new IndentAs(r, rule);
    }

    public String name() {
        return this.name;
    }

    @Override
    public TrackProduction choose(String rule) {
        if (this.name.equals(rule)) {
            return this;
        }
        if (this.reduceAs.containsKey(rule)) {
            return this;
        }
        if (this.reduceAs.size() == 1) {
            return ((SeqReduction)CollectionUtils.any(this.reduceAs.values())).choose(rule);
        }
        return null;
    }

    @Override
    public boolean canBeKeyword(String keyword) {
        for (SeqReduction e : this.reduceAs.values()) {
            if (!e.canBeKeyword(keyword)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSeqReducer(String rule) {
        return this.reduceAs.containsKey(rule);
    }

    public SeqReduction get(String name) {
        if (!this.reduceAs.containsKey(name)) {
            throw new CantHappenException("there is no reduction for " + name);
        }
        return this.reduceAs.get(name);
    }

    public TrackProduction indented() {
        return this.indent;
    }

    public String toString() {
        return this.name + "[]";
    }
}

