/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.testing.golden.ParsedTokens;
import org.flasck.flas.testing.golden.grammar.GrammarChooser;
import org.flasck.flas.testing.golden.grammar.GrammarTree;
import org.flasck.flas.testing.golden.grammar.MatchResult;
import org.flasck.flas.testing.golden.grammar.SeqElement;
import org.flasck.flas.testing.golden.grammar.TrackProduction;

public class RefElement
implements SeqElement {
    private final GrammarChooser chooser;
    private final String rule;

    public RefElement(GrammarChooser chooser, RefDefinition rd) {
        this.chooser = chooser;
        this.rule = rd.ruleName();
    }

    @Override
    public MatchResult matchAgainst(ParsedTokens.GrammarStep mi) {
        if (mi instanceof GrammarTree) {
            GrammarTree t = (GrammarTree)mi;
            if (t.reducedToRule().equals(this.rule)) {
                return MatchResult.MATCH_NESTED;
            }
            TrackProduction tracker = this.chooser.rule(this.rule);
            TrackProduction ret = tracker.choose(t.reducedToRule());
            if (ret == null) {
                return MatchResult.SINGLE_MATCH_FAILED;
            }
            return MatchResult.MATCH_NESTED;
        }
        if (mi instanceof ParsedTokens.GrammarToken) {
            ParsedTokens.GrammarToken tok = (ParsedTokens.GrammarToken)mi;
            TrackProduction tracker = this.chooser.rule(this.rule);
            TrackProduction ret = tracker.choose(tok.type);
            if (ret != null) {
                return MatchResult.SINGLE_MATCH_ADVANCE;
            }
            ret = tracker.choose(tok.text);
            if (ret != null) {
                return MatchResult.SINGLE_MATCH_ADVANCE;
            }
            return MatchResult.SINGLE_MATCH_FAILED;
        }
        return MatchResult.SINGLE_MATCH_FAILED;
    }

    public String refersTo() {
        return this.rule;
    }

    public String toString() {
        return "RefElement[" + this.rule + "]";
    }

    @Override
    public boolean canBeSkipped() {
        return false;
    }

    public TrackProduction choose(String want) {
        if (!this.chooser.hasRule(want)) {
            return null;
        }
        TrackProduction ret = this.chooser.rule(this.rule);
        if (want.equals(this.rule)) {
            return ret;
        }
        return ret.choose(want);
    }
}

