/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.OrProduction;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.grammar.SequenceDefinition;
import org.flasck.flas.grammar.TokenDefinition;
import org.flasck.flas.testing.golden.grammar.GrammarChooser;
import org.flasck.flas.testing.golden.grammar.SeqProduction;
import org.flasck.flas.testing.golden.grammar.SeqReduction;
import org.flasck.flas.testing.golden.grammar.TokenProduction;
import org.flasck.flas.testing.golden.grammar.TrackProduction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;

public class OrChoice
implements TrackProduction {
    public static final Logger logger = LoggerFactory.getLogger((String)"GrammarChecker");
    private final Grammar grammar;
    private final GrammarChooser chooser;
    private final String prod;
    private final List<TrackProduction> choices = new ArrayList<TrackProduction>();

    public OrChoice(Grammar grammar, GrammarChooser grammarChooser, OrProduction rule) {
        this.grammar = grammar;
        this.chooser = grammarChooser;
        this.prod = rule.name;
    }

    @Override
    public void initWhenReady(Production prod) {
        int k = 0;
        for (Definition d : ((OrProduction)prod).allOptions()) {
            if (d instanceof RefDefinition) {
                this.choices.add(this.chooser.rule(((RefDefinition)d).ruleName()));
                continue;
            }
            if (d instanceof TokenDefinition) {
                String ruleName = "tok_" + k;
                ++k;
                this.choices.add(new TokenProduction(this.grammar, ruleName, (TokenDefinition)d));
                continue;
            }
            if (d instanceof SequenceDefinition) {
                Object ruleName;
                SequenceDefinition sd = (SequenceDefinition)d;
                if (sd.reducesAs() != null) {
                    ruleName = sd.reducesAs();
                } else {
                    ruleName = "seq_" + k;
                    ++k;
                }
                TrackProduction cnv = this.chooser.convert((String)ruleName, sd);
                cnv.initWhenReady(prod);
                this.choices.add(cnv);
                continue;
            }
            throw new HaventConsideredThisException("or with " + d.getClass());
        }
    }

    @Override
    public TrackProduction choose(String rule) {
        logger.info("or rule " + this.prod + " looking for " + rule);
        if (this.prod.equals(rule)) {
            return this;
        }
        for (TrackProduction d : this.choices) {
            logger.info("considering " + d);
            TrackProduction k = d.choose(rule);
            if (k == null) continue;
            return k;
        }
        logger.info("none found");
        return null;
    }

    public SeqReduction getSequence(String rule) {
        TrackProduction sp = this.choose(rule);
        if (sp == null) {
            return null;
        }
        if (sp instanceof SeqProduction) {
            return ((SeqProduction)sp).get(rule);
        }
        throw new CantHappenException(rule + " was not a sequence");
    }

    public String toString() {
        return this.prod + ":||";
    }
}

