/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.ManyDefinition;
import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.grammar.TokenDefinition;
import org.flasck.flas.testing.golden.ParsedTokens;
import org.flasck.flas.testing.golden.grammar.GrammarChooser;
import org.flasck.flas.testing.golden.grammar.GrammarTree;
import org.flasck.flas.testing.golden.grammar.MatchResult;
import org.flasck.flas.testing.golden.grammar.SeqElement;
import org.flasck.flas.testing.golden.grammar.TokenElement;
import org.flasck.flas.testing.golden.grammar.TrackProduction;
import org.zinutils.exceptions.CantHappenException;

public class ManyElement
implements SeqElement {
    private final TrackProduction matchRef;
    private final TokenElement matchTok;

    public ManyElement(GrammarChooser chooser, Grammar g, ManyDefinition md) {
        Definition child = md.repeats();
        if (child instanceof RefDefinition) {
            String rule = ((RefDefinition)child).ruleName();
            this.matchRef = chooser.rule(rule);
            this.matchTok = null;
        } else if (child instanceof TokenDefinition) {
            this.matchRef = null;
            this.matchTok = new TokenElement(g, (TokenDefinition)child);
        } else {
            throw new CantHappenException("cannot have a many of " + child.getClass());
        }
    }

    @Override
    public MatchResult matchAgainst(ParsedTokens.GrammarStep mi) {
        if (mi instanceof ParsedTokens.GrammarToken) {
            ParsedTokens.GrammarToken tok = (ParsedTokens.GrammarToken)mi;
            if (this.matchTok != null) {
                return this.encode(this.matchTok.matchAgainst(tok));
            }
            if (this.matchRef != null) {
                if (this.matchRef.choose(tok.type) != null) {
                    return MatchResult.MANY_MATCH_MAYBE_MORE;
                }
                return MatchResult.MANY_NO_MATCH_TRY_NEXT;
            }
            throw new CantHappenException("what are we matching?");
        }
        if (mi instanceof GrammarTree) {
            GrammarTree tree = (GrammarTree)mi;
            if (this.matchRef == null) {
                throw new CantHappenException("matching a tree against a token does not work");
            }
            if (this.matchRef.choose(tree.reducedToRule()) != null) {
                return MatchResult.MATCH_NESTED_MAYBE_MORE;
            }
            return MatchResult.MANY_NO_MATCH_TRY_NEXT;
        }
        throw new CantHappenException("step is a " + mi.getClass());
    }

    private MatchResult encode(MatchResult matched) {
        switch (matched) {
            case SINGLE_MATCH_ADVANCE: {
                return MatchResult.MANY_MATCH_MAYBE_MORE;
            }
            case SINGLE_MATCH_FAILED: {
                return MatchResult.MANY_NO_MATCH_TRY_NEXT;
            }
        }
        throw new CantHappenException("token matcher should not return that");
    }

    public boolean matchesRef() {
        return this.matchRef != null;
    }

    public TrackProduction matchRef() {
        return this.matchRef;
    }

    public TrackProduction choose(String want) {
        if (this.matchRef != null) {
            return this.matchRef.choose(want);
        }
        return null;
    }

    @Override
    public boolean canBeSkipped() {
        return true;
    }

    public String toString() {
        return "ManyElt[" + this.matchRef + ":" + this.matchTok + "]";
    }
}

