/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.testing.golden.ParsedTokens;
import org.zinutils.exceptions.CantHappenException;

public class GrammarTree
implements ParsedTokens.GrammarStep {
    private final ParsedTokens.ReductionRule reducedTo;
    private final List<ParsedTokens.GrammarStep> members = new ArrayList<ParsedTokens.GrammarStep>();
    private final List<GrammarTree> indents;

    public GrammarTree(ParsedTokens.ReductionRule rr) {
        this.reducedTo = rr;
        this.indents = new ArrayList<GrammarTree>();
    }

    public GrammarTree(String topRule, List<GrammarTree> ret) {
        this.reducedTo = new ParsedTokens.ReductionRule(topRule);
        this.indents = ret;
    }

    public void dump(PrintWriter pw, String ind, boolean isIndented) {
        pw.print(ind);
        if (isIndented) {
            pw.print(">> ");
        }
        pw.print(this.reducedTo.ruleName());
        pw.println();
        String nested = ind + "   ";
        for (ParsedTokens.GrammarStep s : this.members) {
            if (s instanceof GrammarTree) {
                ((GrammarTree)s).dump(pw, nested, false);
                continue;
            }
            if (!(s instanceof ParsedTokens.GrammarToken)) continue;
            ParsedTokens.GrammarToken tok = (ParsedTokens.GrammarToken)s;
            pw.print(nested);
            pw.print(tok.type + ": _" + tok.text + "_ [" + tok.location().lineNo + "." + tok.location().off + "]");
            pw.println();
        }
        for (GrammarTree t : this.indents) {
            t.dump(pw, nested, true);
        }
    }

    public void push(ParsedTokens.GrammarStep si) {
        if (this.isIndented(si.location(), this.location()) && !this.ftt(si)) {
            if (!(si instanceof GrammarTree)) {
                throw new CantHappenException("can't push " + si + " because it is directly indented not reduced");
            }
            this.indents.add(0, (GrammarTree)si);
        } else {
            this.members.add(0, si);
        }
    }

    private boolean ftt(ParsedTokens.GrammarStep si) {
        if (!(si instanceof ParsedTokens.GrammarToken)) {
            return false;
        }
        ParsedTokens.GrammarToken t = (ParsedTokens.GrammarToken)si;
        return t.type.equals("FREETEXT");
    }

    private boolean isIndented(InputPosition item, InputPosition relativeTo) {
        if (item.lineNo == relativeTo.lineNo) {
            return false;
        }
        if (item.lineNo < relativeTo.lineNo) {
            throw new CantHappenException("cannot come before the relative line");
        }
        if (item.indent.tabs == relativeTo.indent.tabs) {
            return false;
        }
        if (item.indent.tabs < relativeTo.indent.tabs) {
            throw new CantHappenException("cannot be indented less than relative line");
        }
        return item.indent.spaces <= 0;
    }

    @Override
    public InputPosition location() {
        return this.reducedTo.location();
    }

    public String reducedToRule() {
        return this.reducedTo.ruleName();
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    public boolean isSingleton() {
        return this.members.size() == 1 && this.members.get(0) instanceof GrammarTree && !this.isSpecial(((GrammarTree)this.members.get((int)0)).reducedTo.ruleName());
    }

    private boolean isSpecial(String ruleName) {
        switch (ruleName) {
            case "assign-method-action": 
            case "message-method-action": 
            case "function-case-with-guard": 
            case "function-case-default": {
                return true;
            }
        }
        return false;
    }

    public boolean isTerminal() {
        return this.members.size() == 1 && this.members.get(0) instanceof ParsedTokens.GrammarToken;
    }

    public GrammarTree singleton() {
        if (this.members.size() != 1) {
            throw new CantHappenException("singleton should have one member");
        }
        if (!(this.members.get(0) instanceof GrammarTree)) {
            throw new CantHappenException("singleton member should be a tree");
        }
        return (GrammarTree)this.members.get(0);
    }

    public ParsedTokens.GrammarToken terminal() {
        if (this.members.size() != 1) {
            throw new CantHappenException("terminal should have one member");
        }
        if (!(this.members.get(0) instanceof ParsedTokens.GrammarToken)) {
            throw new CantHappenException("terminal member should be a token, not " + this.members.get(0));
        }
        return (ParsedTokens.GrammarToken)this.members.get(0);
    }

    public Iterator<ParsedTokens.GrammarStep> members() {
        return this.members.iterator();
    }

    public boolean hasIndents() {
        return !this.indents.isEmpty();
    }

    public Iterator<GrammarTree> indents() {
        return this.indents.iterator();
    }

    public String toString() {
        return this.location() + ": " + this.reducedTo + this.members;
    }
}

