/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.testing.golden.grammar.GrammarChooser;
import org.flasck.flas.testing.golden.grammar.OrChoice;
import org.flasck.flas.testing.golden.grammar.SeqProduction;
import org.flasck.flas.testing.golden.grammar.SeqReduction;
import org.flasck.flas.testing.golden.grammar.TrackProduction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;

public class GrammarNavigator {
    public static final Logger logger = LoggerFactory.getLogger((String)"GrammarChecker");
    private final List<TrackProduction> stack = new ArrayList<TrackProduction>();

    public GrammarNavigator(GrammarChooser grammar) {
        this.push(grammar.rule("file"));
    }

    public void push(TrackProduction rule) {
        logger.info("pushing " + rule);
        this.stack.add(0, rule);
    }

    public void pop() {
        TrackProduction rule = this.stack.remove(0);
        logger.info("popped " + rule);
    }

    public boolean isAtEnd() {
        return true;
    }

    public TrackProduction findChooseableRule(String rule) {
        TrackProduction top = this.stack.get(0);
        TrackProduction r = top.choose(rule);
        if (r != null) {
            return r;
        }
        return null;
    }

    public SeqReduction sequence(String rule) {
        TrackProduction top = this.stack.get(0);
        if (top instanceof SeqProduction) {
            return ((SeqProduction)top).get(rule);
        }
        if (top instanceof OrChoice) {
            OrChoice c = (OrChoice)top;
            return c.getSequence(rule);
        }
        throw new CantHappenException("the top eleement was not a SeqReduction but " + top.getClass());
    }

    public String toString() {
        return "GrammarNavigator: " + this.stack;
    }
}

