/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.doc.grammar.GenerateGrammarDoc;
import org.flasck.flas.grammar.ActionDefinition;
import org.flasck.flas.grammar.Definition;
import org.flasck.flas.grammar.Grammar;
import org.flasck.flas.grammar.ManyDefinition;
import org.flasck.flas.grammar.OrProduction;
import org.flasck.flas.grammar.Production;
import org.flasck.flas.grammar.RefDefinition;
import org.flasck.flas.grammar.SequenceDefinition;
import org.flasck.flas.grammar.TokenDefinition;
import org.flasck.flas.testing.golden.ParsedTokens;
import org.flasck.flas.testing.golden.grammar.GrammarNavigator;
import org.flasck.flas.testing.golden.grammar.GrammarTree;
import org.flasck.flas.testing.golden.grammar.ManyProduction;
import org.flasck.flas.testing.golden.grammar.OrChoice;
import org.flasck.flas.testing.golden.grammar.RefProduction;
import org.flasck.flas.testing.golden.grammar.SeqProduction;
import org.flasck.flas.testing.golden.grammar.SeqReduction;
import org.flasck.flas.testing.golden.grammar.TokenProduction;
import org.flasck.flas.testing.golden.grammar.TrackProduction;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class GrammarChooser {
    private final Grammar orig;
    private final Map<String, TrackProduction> grammar = new TreeMap<String, TrackProduction>();
    private final Map<String, SeqProduction> reductions = new TreeMap<String, SeqProduction>();

    public GrammarChooser(Grammar grammar) {
        this.orig = grammar;
        GenerateGrammarDoc.checkTokens(grammar);
        GenerateGrammarDoc.checkProductions(grammar);
        this.populateGrammar(grammar);
    }

    private void populateGrammar(Grammar g) {
        for (Production p : g.productions()) {
            this.grammar.put(p.name, this.makeThing(p));
        }
        for (Production p : g.productions()) {
            TrackProduction ret = this.grammar.get(p.name);
            if (ret == null) continue;
            ret.initWhenReady(p);
        }
    }

    private TrackProduction makeThing(Production rule) {
        if (rule instanceof OrProduction) {
            return new OrChoice(this.orig, this, (OrProduction)rule);
        }
        return this.convert(rule.name, rule.defn);
    }

    public TrackProduction convert(String name, Definition defn) {
        Definition d = this.simplify(defn);
        if (d instanceof ManyDefinition) {
            return new ManyProduction(this, name, (ManyDefinition)d);
        }
        if (d instanceof RefDefinition) {
            return new RefProduction(this, name, (RefDefinition)d);
        }
        if (d instanceof SequenceDefinition) {
            return new SeqProduction(this, this.orig, name, (SequenceDefinition)d);
        }
        if (d instanceof TokenDefinition) {
            return new TokenProduction(this.orig, name, (TokenDefinition)d);
        }
        throw new CantHappenException("can't handle " + name + " " + d.getClass());
    }

    private Definition simplify(Definition defn) {
        if (defn instanceof SequenceDefinition) {
            ArrayList<Definition> ret = new ArrayList<Definition>();
            SequenceDefinition seq = (SequenceDefinition)defn;
            for (int i = 0; i < seq.length(); ++i) {
                Definition x = seq.nth(i);
                if (x instanceof ActionDefinition) continue;
                ret.add(x);
            }
            if (!seq.hasExplicitReduceAs() && ret.size() == 1) {
                return (Definition)ret.get(0);
            }
            return seq.cloneWith(ret);
        }
        return defn;
    }

    public void addReduction(String reduction, SeqReduction reducer) {
        if (this.reductions.containsKey(reduction)) {
            return;
        }
        this.reductions.put(reduction, new SeqProduction(this, this.orig, reduction, reducer));
    }

    public GrammarNavigator newNavigator() {
        return new GrammarNavigator(this);
    }

    public boolean hasRule(String want) {
        return this.grammar.containsKey(want);
    }

    public TrackProduction rule(String rule) {
        if (!this.grammar.containsKey(rule)) {
            throw new CantHappenException("there is no rule " + rule);
        }
        return this.grammar.get(rule);
    }

    public SeqProduction findReduction(GrammarTree tree) {
        String rule = tree.reducedToRule();
        SeqProduction ret = this.reductions.get(rule);
        if (ret != null) {
            return ret;
        }
        TrackProduction prod = this.grammar.get(rule);
        if (prod != null) {
            if (prod instanceof SeqProduction) {
                return (SeqProduction)prod;
            }
            if (prod instanceof OrChoice) {
                if (!tree.isSingleton()) {
                    throw new CantHappenException("the tree is not a singleton");
                }
                ParsedTokens.GrammarStep s = tree.members().next();
                if (!(s instanceof GrammarTree)) {
                    throw new CantHappenException("the singleton is not a tree");
                }
                TrackProduction choice = ((OrChoice)prod).choose(((GrammarTree)s).reducedToRule());
                if (choice == null) {
                    return null;
                }
                if (choice instanceof SeqProduction) {
                    return (SeqProduction)choice;
                }
                throw new NotImplementedException("have found " + choice + ": " + choice.getClass());
            }
            throw new NotImplementedException("the prod is " + prod + ": " + prod.getClass());
        }
        throw new CantHappenException("there is nothing matching " + tree);
    }
}

