/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden.grammar;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.grammar.GrammarSupport;
import org.flasck.flas.testing.golden.FileReconstructor;
import org.flasck.flas.testing.golden.ParsedTokens;
import org.flasck.flas.testing.golden.grammar.GrammarChooser;
import org.flasck.flas.testing.golden.grammar.GrammarNavigator;
import org.flasck.flas.testing.golden.grammar.GrammarTree;
import org.flasck.flas.testing.golden.grammar.ManyElement;
import org.flasck.flas.testing.golden.grammar.MatchResult;
import org.flasck.flas.testing.golden.grammar.OrChoice;
import org.flasck.flas.testing.golden.grammar.RefElement;
import org.flasck.flas.testing.golden.grammar.SeqElement;
import org.flasck.flas.testing.golden.grammar.SeqProduction;
import org.flasck.flas.testing.golden.grammar.SeqReduction;
import org.flasck.flas.testing.golden.grammar.TokenProduction;
import org.flasck.flas.testing.golden.grammar.TrackProduction;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.FileUtils;

public class GrammarChecker {
    public static final Logger logger = LoggerFactory.getLogger((String)"GrammarChecker");
    private final File parseTokens;
    private final File reconstruct;
    private final GrammarChooser grammar;

    public GrammarChecker(File parseTokens, File reconstruct) {
        this.parseTokens = parseTokens;
        this.reconstruct = reconstruct;
        this.grammar = new GrammarChooser(GrammarSupport.loadGrammar());
    }

    public Map<String, GrammarTree> checkParseTokenLogic(boolean expectErrors) {
        if (this.parseTokens == null || this.reconstruct == null) {
            return null;
        }
        TreeMap<String, GrammarTree> ret = new TreeMap<String, GrammarTree>(new MyPreferredTestSorting());
        for (File f : FileUtils.findFilesMatching((File)this.parseTokens, (String)"*")) {
            ParsedTokens toks = ParsedTokens.read(f);
            try {
                toks.write(new File(f.getParentFile(), f.getName() + "-sorted"));
            }
            catch (FileNotFoundException ex) {
                Assert.fail((String)("could not write sorted tokens to " + ex.getMessage()));
            }
            this.reconstructFile(toks, new File(this.reconstruct, f.getName()));
            if (expectErrors) continue;
            String ext = FileUtils.extension((String)f.getName());
            GrammarTree reduced = this.computeReductions(this.getTopRule(ext), toks);
            try {
                this.dumpTree(new File(f.getParentFile(), f.getName() + "-tree"), reduced);
            }
            catch (FileNotFoundException ex) {
                Assert.fail((String)("could not write parse tree to " + ex.getMessage()));
            }
            ret.put(f.getName(), reduced);
        }
        return ret;
    }

    private void reconstructFile(ParsedTokens toks, File output) {
        FileReconstructor r = new FileReconstructor(toks, output);
        r.reconstruct();
    }

    private GrammarTree computeReductions(String topRule, ParsedTokens toks) {
        this.assertNoOverlappingRules(toks);
        this.assertTLFs(toks);
        this.assertAllTokensReduced(toks);
        return this.reduceToSingleTree(topRule, toks);
    }

    private void assertNoOverlappingRules(ParsedTokens toks) {
        InputPosition lastEndedAt = null;
        for (ParsedTokens.ReductionRule rr : toks.mostReduced()) {
            if (lastEndedAt != null && lastEndedAt.compareTo(rr.start()) >= 0) {
                Assert.fail((String)("overlapping reductions: " + lastEndedAt + " X " + rr));
            }
            lastEndedAt = rr.last();
        }
    }

    private void assertTLFs(ParsedTokens toks) {
        for (ParsedTokens.ReductionRule rr : toks.mostReduced()) {
            if (rr.start().indent.tabs == 1 && rr.start().indent.spaces == 0) continue;
            Assert.fail((String)("TLFs must have an indent of (1,0): " + rr));
        }
    }

    private void assertAllTokensReduced(ParsedTokens toks) {
        block0: for (ParsedTokens.GrammarToken t : toks.tokens()) {
            for (ParsedTokens.ReductionRule rr : toks.reductions()) {
                if (!rr.includes(t.pos)) continue;
                continue block0;
            }
            if (t.type.equals("comment")) continue;
            Assert.fail((String)("token not reduced: " + t));
        }
    }

    private GrammarTree reduceToSingleTree(String topRule, ParsedTokens toks) {
        ArrayList<GrammarTree> ret = new ArrayList<GrammarTree>();
        ArrayList<ParsedTokens.GrammarStep> srstack = new ArrayList<ParsedTokens.GrammarStep>();
        for (ParsedTokens.GrammarStep s : toks) {
            if (s instanceof ParsedTokens.GrammarToken) {
                ParsedTokens.GrammarToken nt = (ParsedTokens.GrammarToken)s;
                if (nt.isComment()) continue;
                srstack.add(0, nt);
                continue;
            }
            ParsedTokens.ReductionRule rr = (ParsedTokens.ReductionRule)s;
            GrammarTree tree = new GrammarTree(rr);
            ArrayList<ParsedTokens.GrammarStep> shifted = new ArrayList<ParsedTokens.GrammarStep>();
            while (!srstack.isEmpty()) {
                ParsedTokens.GrammarStep si = (ParsedTokens.GrammarStep)srstack.get(0);
                if (rr.includes(si.location())) {
                    tree.push(si);
                    srstack.remove(0);
                    continue;
                }
                if (si.location().compareTo(rr.location()) <= 0) break;
                shifted.add(si);
                srstack.remove(0);
            }
            srstack.add(0, tree);
            srstack.addAll(0, shifted);
        }
        while (!srstack.isEmpty()) {
            ret.add(0, (GrammarTree)srstack.remove(0));
        }
        return new GrammarTree(topRule, ret);
    }

    public void dumpTree(File file, GrammarTree top) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(file);
        top.dump(pw, "", false);
        pw.close();
    }

    public void checkGrammar(Map<String, GrammarTree> fileOrchards) {
        for (Map.Entry<String, GrammarTree> e : fileOrchards.entrySet()) {
            this.checkProductionsAgainstGrammar(e.getValue());
        }
    }

    private String getTopRule(String ext) {
        switch (ext) {
            case ".fl": {
                return "source-file";
            }
            case ".fa": {
                return "assembly-file";
            }
            case ".ut": {
                return "unit-test-file";
            }
            case ".st": {
                return "system-test-file";
            }
        }
        throw new CantHappenException("there is no top rule for file type " + ext);
    }

    private void checkProductionsAgainstGrammar(GrammarTree file) {
        GrammarNavigator gn = this.grammar.newNavigator();
        this.handleFileOfType(file, gn);
        if (!gn.isAtEnd()) {
            Assert.fail((String)"defn was not at end");
        }
    }

    private void handleFileOfType(GrammarTree tree, GrammarNavigator gn) {
        this.traverseTree(tree, gn);
    }

    private void traverseTree(GrammarTree tree, GrammarNavigator gn) {
        String rule = tree.reducedToRule();
        logger.info("traversing tree with " + rule + " and " + gn);
        TrackProduction prod = gn.findChooseableRule(rule);
        if (prod == null) {
            throw new CantHappenException("there is no chooseable rule to match " + rule + " in " + gn);
        }
        gn.push(prod);
        boolean scopeOnly = false;
        if (tree.isSingleton() && !prod.isSeqReducer(rule)) {
            this.traverseTree((GrammarTree)tree.members().next(), gn);
        } else if (tree.isTerminal()) {
            if (!this.matchTerminal(prod, tree.terminal())) {
                this.matchLineSegment(rule, tree, gn);
            }
        } else if (tree.hasMembers()) {
            this.matchLineSegment(rule, tree, gn);
        } else {
            scopeOnly = true;
        }
        if (tree.hasIndents()) {
            logger.info("tree " + rule + " has indents, scopeOnly = " + scopeOnly);
            if (!scopeOnly) {
                if (!(prod instanceof SeqProduction)) {
                    if (prod instanceof OrChoice && tree.isSingleton()) {
                        String reduction = ((GrammarTree)tree.members().next()).reducedToRule();
                        prod = prod.choose(reduction);
                    }
                    if (!(prod instanceof SeqProduction)) {
                        throw new CantHappenException("tree has indents but rule " + rule + " is not a SeqProduction, but " + prod + " " + prod.getClass());
                    }
                }
                SeqProduction sp = (SeqProduction)prod;
                TrackProduction indent = sp.indented();
                Assert.assertNotNull((String)("have a tree indent in " + rule + " but not in rule: " + gn), (Object)indent);
                gn.push(indent);
            }
            logger.info("now going to go through the indents");
            Iterator<GrammarTree> it = tree.indents();
            while (it.hasNext()) {
                GrammarTree ind = it.next();
                logger.info("processing indent for " + rule + ": " + ind);
                this.traverseTree(ind, gn);
            }
            if (!scopeOnly) {
                gn.pop();
            }
        }
        gn.pop();
    }

    private void matchLineSegment(String rule, GrammarTree tree, GrammarNavigator gn) {
        Iterator<ParsedTokens.GrammarStep> mit = tree.members();
        SeqReduction sr = gn.sequence(rule);
        Iterator<SeqElement> sit = sr.iterator();
        ParsedTokens.GrammarStep mi = null;
        SeqElement si = null;
        block8: while ((mi != null || mit.hasNext()) && (si != null || sit.hasNext())) {
            if (mi == null) {
                mi = mit.next();
            }
            if (si == null) {
                si = sit.next();
            }
            MatchResult mr = si.matchAgainst(mi);
            switch (mr) {
                case SINGLE_MATCH_ADVANCE: {
                    si = null;
                    mi = null;
                    continue block8;
                }
                case MANY_MATCH_MAYBE_MORE: {
                    mi = null;
                    continue block8;
                }
                case MANY_NO_MATCH_TRY_NEXT: {
                    si = null;
                    continue block8;
                }
                case MATCH_NESTED: {
                    this.matchNested(gn, mi, si);
                    mi = null;
                    si = null;
                    continue block8;
                }
                case MATCH_NESTED_MAYBE_MORE: {
                    this.matchNested(gn, mi, si);
                    mi = null;
                    continue block8;
                }
                case SINGLE_MATCH_FAILED: {
                    throw new CantHappenException("the grammar did not match at " + mi + " == " + si);
                }
            }
            throw new NotImplementedException("match result " + mr);
        }
        if (mi != null || mit.hasNext()) {
            if (mi == null) {
                mi = mit.next();
            }
            throw new CantHappenException("the tree has remaining members which were not consumed by the grammar: " + mi);
        }
        while (sit.hasNext()) {
            si = sit.next();
            if (si.canBeSkipped()) continue;
            throw new CantHappenException("the grammar expects the tree to have more members which were not there: " + si);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void matchNested(GrammarNavigator gn, ParsedTokens.GrammarStep mi, SeqElement si) {
        if (!(mi instanceof GrammarTree)) throw new CantHappenException("MATCH_NESTED is only for trees, I think");
        GrammarTree tree = (GrammarTree)mi;
        String inRule = tree.reducedToRule();
        if (tree.isSingleton()) {
            GrammarTree inner;
            String reducedAs;
            TrackProduction prod = this.grammar.rule(inRule);
            TrackProduction tp = prod.choose(reducedAs = (inner = (GrammarTree)tree.members().next()).reducedToRule());
            if (tp == null) {
                throw new CantHappenException("there is no reduction for " + reducedAs + " in " + inRule);
            }
            if (tp instanceof SeqProduction) {
                gn.push(tp);
                boolean matched = false;
                if (tree.isTerminal()) {
                    matched = this.matchTerminal(tp, tree.terminal());
                }
                if (!matched) {
                    this.matchLineSegment(reducedAs, inner, gn);
                }
                gn.pop();
                return;
            } else {
                if (!(tp instanceof OrChoice)) return;
                if (inner.isTerminal()) {
                    this.matchTerminal(tp, inner.terminal());
                    return;
                } else {
                    this.matchNested(gn, inner, si);
                }
            }
            return;
        } else if (si instanceof ManyElement) {
            ManyElement me = (ManyElement)si;
            if (!me.matchesRef()) return;
            gn.push(me.matchRef());
            this.matchLineSegment(inRule, tree, gn);
            gn.pop();
            return;
        } else if (si instanceof RefElement) {
            RefElement re = (RefElement)si;
            TrackProduction tp = this.grammar.rule(re.refersTo());
            gn.push(tp);
            boolean matched = false;
            if (tree.isTerminal()) {
                matched = this.matchTerminal(tp, tree.terminal());
            }
            if (!matched) {
                this.matchLineSegment(inRule, tree, gn);
            }
            gn.pop();
            return;
        } else {
            if (!tree.isTerminal()) throw new CantHappenException("what is happening in this case?");
            throw new NotImplementedException("handle terminal case");
        }
    }

    private boolean matchTerminal(TrackProduction tp, ParsedTokens.GrammarToken tok) {
        TokenProduction rule = (TokenProduction)tp.choose(tok.type);
        if (rule != null) {
            return rule.matches(tok.text);
        }
        return tp.canBeKeyword(tok.text);
    }

    public class MyPreferredTestSorting
    implements Comparator<String> {
        String[] exts = new String[]{".fl", ".fa", ".ut", ".st"};

        @Override
        public int compare(String lhs, String rhs) {
            String lext = FileUtils.extension((String)lhs);
            String rext = FileUtils.extension((String)rhs);
            int lp = Arrays.binarySearch(this.exts, 0, this.exts.length, lext);
            int rp = Arrays.binarySearch(this.exts, 0, this.exts.length, rext);
            if (lp == -1 || rp == -1) {
                throw new CantHappenException("can't find " + lext + " = " + lp + " or " + rext + " = " + rp);
            }
            if (lp < rp) {
                return -1;
            }
            if (rp > lp) {
                return 1;
            }
            return lhs.compareTo(rhs);
        }
    }
}

