/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.flasck.flas.Configuration;
import org.junit.Assert;
import org.zinutils.system.RunProcess;
import org.zinutils.utils.Crypto;
import org.zinutils.utils.FileUtils;

public class TestEnvironment {
    private File tc2;
    public final File testReportTo;
    private File errors;
    private boolean useJSRunner;
    private boolean useJVMRunner;
    private File rootdir;
    private File testReports;
    private boolean checkNothing;
    private boolean checkEverything;
    private File goldtc;
    private File goldfd;
    private File tmpfd;

    public TestEnvironment(File jvmdir, String root, boolean useJSRunner, boolean useJVMRunner, boolean checkNothing, boolean checkEverything) throws FileNotFoundException, IOException {
        this.rootdir = new File(root, "test.golden");
        this.useJSRunner = useJSRunner;
        this.useJVMRunner = useJVMRunner;
        this.checkNothing = checkNothing;
        this.checkEverything = checkEverything;
        this.goldfd = new File(root, "flimstore");
        this.tmpfd = new File(root, "flimstore-tmp");
        this.goldtc = new File(root, "tc");
        this.tc2 = new File(root, "tc-tmp");
        this.testReports = new File(root, "testReports");
        this.testReportTo = new File(root, "testReports-tmp");
        this.errors = new File(root, "errors-tmp");
    }

    public boolean haveTests() {
        return this.rootdir.isDirectory() && (!FileUtils.findFilesMatching((File)this.rootdir, (String)"*.ut").isEmpty() || !FileUtils.findFilesMatching((File)this.rootdir, (String)"*.st").isEmpty() || !FileUtils.findFilesMatching((File)this.rootdir, (String)"*.pt").isEmpty());
    }

    public void cleanUp() {
        FileUtils.deleteDirectoryTree((File)this.errors);
        TestEnvironment.clean(this.tc2);
    }

    public static void clean(File dir) {
        FileUtils.cleanDirectory((File)dir);
        FileUtils.assertDirectory((File)dir);
    }

    public void checkTestResults(boolean errorsExpected) {
        if (this.haveTests() && (this.useJSRunner || this.useJVMRunner)) {
            FileUtils.assertDirectory((File)this.testReports);
            for (String f : this.testReportTo.list()) {
                FileUtils.assertFile((File)new File(this.testReports, f));
            }
            this.assertGolden(errorsExpected, this.testReports, this.testReportTo, fn -> true, false);
        }
    }

    public void assertGolden(boolean errorsExpected, File golden, File genned, Predicate<String> requireNamedGolden, boolean allowWSDiffs) {
        if (this.checkNothing) {
            return;
        }
        if (!golden.isDirectory()) {
            if (!this.checkEverything || errorsExpected) {
                return;
            }
            Assert.fail((String)("There is no golden directory " + golden));
        }
        if (!genned.isDirectory()) {
            if (!this.checkEverything || errorsExpected) {
                return;
            }
            Assert.fail((String)("There is no generated directory " + genned));
        }
        ArrayList<File> missing = new ArrayList<File>();
        for (File f : genned.listFiles()) {
            if (new File(golden, f.getName()).exists() || !requireNamedGolden.test(f.getName())) continue;
            System.out.println("--- missing " + f);
            if (FileUtils.extension((String)f.getName()).equals(".jar")) {
                System.out.println(" ... is binary");
            } else {
                FileUtils.cat((File)f);
            }
            System.out.println("---");
            missing.add(f);
        }
        if (!missing.isEmpty()) {
            Assert.fail((String)("There is no golden file for the generated " + missing));
        }
        for (File f : golden.listFiles()) {
            String genhash;
            File gen = new File(genned, f.getName());
            if (!gen.exists() && errorsExpected) continue;
            Assert.assertTrue((String)("There is no generated file for the golden " + f), (boolean)gen.exists());
            if (".jar".equals(FileUtils.extension((String)f.getName()))) continue;
            String goldhash = Crypto.hashTrim((File)f);
            if (!goldhash.equals(genhash = Crypto.hashTrim((File)gen))) {
                RunProcess proc = new RunProcess("diff");
                proc.arg("-C5");
                if (allowWSDiffs) {
                    proc.arg("-b");
                }
                proc.arg(f.getPath());
                proc.arg(gen.getPath());
                proc.redirectStdout((OutputStream)System.out);
                proc.redirectStderr((OutputStream)System.err);
                proc.execute();
                int code = proc.getExitCode();
                if (code == 0) continue;
            }
            Assert.assertEquals((String)("Files " + f + " and " + gen + " differed"), (Object)goldhash, (Object)genhash);
        }
    }

    public void checkFlimStore(boolean errorsExpected) throws IOException {
        if (!this.goldfd.exists()) {
            return;
        }
        if (!this.tmpfd.exists()) {
            Assert.fail((String)"flim store was not created");
        }
        this.assertGolden(errorsExpected, this.goldfd, this.tmpfd, fn -> !fn.contains("._ut") && !fn.contains("._st"), false);
    }

    public void checkTypes(boolean expectingErrors) throws IOException {
        if (!new Configuration(null, (String[])new String[0]).doTypeCheck) {
            return;
        }
        File goldtf = new File(this.goldtc, "types");
        File gentf = new File(this.tc2, "types");
        if (!(!expectingErrors || goldtf.exists() && gentf.exists())) {
            return;
        }
        FileUtils.assertDirectory((File)this.goldtc);
        FileUtils.assertFile((File)goldtf);
        this.assertGolden(expectingErrors, this.goldtc, this.tc2, fn -> true, false);
    }

    public void checkReconstructions(File sources, File reconstructions) {
        this.assertGolden(false, sources, reconstructions, fn -> false, true);
    }
}

