/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.flasck.flas.blockForm.Indent;
import org.flasck.flas.blockForm.InputPosition;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class ParsedTokens
implements Iterable<GrammarStep> {
    private Set<GrammarToken> tokens = new TreeSet<GrammarToken>();
    private List<GrammarStep> readingOrder = new ArrayList<GrammarStep>();

    private ParsedTokens() {
    }

    public static ParsedTokens read(File tokens) {
        TreeSet<ReductionRule> starting = new TreeSet<ReductionRule>(new Comparator<ReductionRule>(){

            @Override
            public int compare(ReductionRule o1, ReductionRule o2) {
                int cmp = o1.start().compareTo(o2.start());
                if (cmp != 0) {
                    return cmp;
                }
                return Integer.compare(o1.lineNumber, o2.lineNumber);
            }
        });
        String inFile = tokens.getName();
        ParsedTokens ret = new ParsedTokens();
        TreeMap<InputPosition, Integer> tokenLines = new TreeMap<InputPosition, Integer>();
        try (LineNumberReader lnr = new LineNumberReader(new FileReader(tokens));){
            String s;
            InputPosition pos = null;
            GrammarStep pendingRule = null;
            while ((s = lnr.readLine()) != null) {
                if (pos == null) {
                    pos = ParsedTokens.readPos(inFile, s);
                    continue;
                }
                if (pendingRule != null) {
                    ParsedTokens.readPos(inFile, s);
                    pos = null;
                    pendingRule = null;
                    continue;
                }
                GrammarStep step = ParsedTokens.readToken(pos, s);
                if (step instanceof GrammarToken) {
                    tokenLines.put(pos, lnr.getLineNumber());
                    pos = null;
                    continue;
                }
                pendingRule = step;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TreeSet onlyTokenLines = new TreeSet(tokenLines.values());
        try (LineNumberReader lnr = new LineNumberReader(new FileReader(tokens));){
            String s;
            InputPosition pos = null;
            ReductionRule pendingRule = null;
            while ((s = lnr.readLine()) != null) {
                if (pos == null) {
                    pos = ParsedTokens.readPos(inFile, s);
                    continue;
                }
                if (pendingRule != null) {
                    InputPosition endPos = ParsedTokens.readPos(inFile, s);
                    pendingRule.range(pos, endPos);
                    starting.add(pendingRule);
                    ret.readingOrder.add(pendingRule);
                    pendingRule = null;
                    pos = null;
                    continue;
                }
                GrammarStep step = ParsedTokens.readToken(pos, s);
                if (step instanceof GrammarToken) {
                    if (!onlyTokenLines.contains(lnr.getLineNumber())) {
                        pos = null;
                        continue;
                    }
                    GrammarToken tok = (GrammarToken)step;
                    if (ret.tokens.contains(tok)) {
                        throw new CantHappenException("should have skipped the other one");
                    }
                    ret.tokens.add(tok);
                    ret.readingOrder.add(tok);
                    pos = null;
                    continue;
                }
                if (step instanceof ReductionRule) {
                    pendingRule = (ReductionRule)step;
                    pendingRule.lineNo(lnr.getLineNumber());
                    continue;
                }
                throw new NotImplementedException();
            }
            File ff = new File(tokens.getParentFile(), tokens.getName() + "-reading");
            PrintWriter pw = new PrintWriter(ff);
            for (GrammarStep gs : ret.readingOrder) {
                pw.println(gs);
            }
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static InputPosition readPos(String file, String s) {
        int idx1 = s.indexOf(":");
        int idx2 = s.indexOf(".", idx1);
        int idx3 = s.indexOf(":", idx2);
        int line = Integer.parseInt(s.substring(0, idx1));
        int tabs = Integer.parseInt(s.substring(idx1 + 1, idx2));
        int spaces = Integer.parseInt(s.substring(idx2 + 1, idx3));
        int offset = Integer.parseInt(s.substring(idx3 + 1));
        return new InputPosition(file, line, offset, new Indent(tabs, spaces), s);
    }

    private static GrammarStep readToken(InputPosition pos, String s) {
        if (s.startsWith("token ")) {
            int idx = s.indexOf(" ") + 1;
            int idx2 = s.indexOf(" ", idx);
            return new GrammarToken(pos, s.substring(idx, idx2), s.substring(idx2 + 1));
        }
        if (s.startsWith("reduction ")) {
            int idx = s.indexOf(" ") + 1;
            return new ReductionRule(s.substring(idx));
        }
        throw new CantHappenException("what is this? " + s);
    }

    public void write(File file) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(file);
        for (GrammarStep s : this) {
            if (s instanceof GrammarToken) {
                pw.println("   SHIFT  " + s);
                continue;
            }
            ReductionRule rr = (ReductionRule)s;
            if (rr.isMostReduced()) {
                pw.print("MR ");
            } else {
                pw.print("   ");
            }
            pw.println("REDUCE " + rr);
        }
        pw.close();
    }

    @Override
    public Iterator<GrammarStep> iterator() {
        return this.readingOrder.iterator();
    }

    public Iterable<GrammarToken> tokens() {
        return this.tokens;
    }

    public Iterable<ReductionRule> mostReduced() {
        return new Iterable<ReductionRule>(){

            @Override
            public Iterator<ReductionRule> iterator() {
                return new Iterator<ReductionRule>(){
                    Iterator<GrammarStep> it;
                    ReductionRule next;
                    {
                        this.it = ParsedTokens.this.readingOrder.iterator();
                        this.next = this.findNext();
                    }

                    private ReductionRule findNext() {
                        while (this.it.hasNext()) {
                            GrammarStep ret = this.it.next();
                            if (!(ret instanceof ReductionRule) || !((ReductionRule)ret).isMostReduced()) continue;
                            return (ReductionRule)ret;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public ReductionRule next() {
                        ReductionRule ret = this.next;
                        this.next = this.findNext();
                        return ret;
                    }
                };
            }
        };
    }

    public Iterable<ReductionRule> reductions() {
        return new Iterable<ReductionRule>(){

            @Override
            public Iterator<ReductionRule> iterator() {
                return new Iterator<ReductionRule>(){
                    Iterator<GrammarStep> it;
                    ReductionRule next;
                    {
                        this.it = ParsedTokens.this.readingOrder.iterator();
                        this.next = this.findNext();
                    }

                    private ReductionRule findNext() {
                        while (this.it.hasNext()) {
                            GrammarStep ret = this.it.next();
                            if (!(ret instanceof ReductionRule)) continue;
                            return (ReductionRule)ret;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public ReductionRule next() {
                        ReductionRule ret = this.next;
                        this.next = this.findNext();
                        return ret;
                    }
                };
            }
        };
    }

    public static interface GrammarStep {
        public InputPosition location();
    }

    public static class GrammarToken
    implements GrammarStep,
    Comparable<GrammarToken> {
        public final InputPosition pos;
        public final String type;
        public final String text;

        public GrammarToken(InputPosition pos, String type, String text) {
            this.pos = pos;
            this.type = type;
            this.text = text;
        }

        @Override
        public int compareTo(GrammarToken o) {
            return this.pos.compareTo(o.pos);
        }

        @Override
        public InputPosition location() {
            return this.pos;
        }

        public int lineNo() {
            return this.pos.lineNo;
        }

        public int tabs() {
            return this.pos.indent.tabs;
        }

        public int spaces() {
            return this.pos.indent.spaces;
        }

        public int offset() {
            return this.pos.off;
        }

        public boolean isComment() {
            return "comment".equals(this.type);
        }

        public String toString() {
            return this.pos.toString() + " " + this.type + ":***" + this.text + "***";
        }
    }

    public static class ReductionRule
    implements GrammarStep {
        private final String rule;
        private InputPosition first;
        private InputPosition last;
        private int lineNumber;
        private boolean mostReduced;

        public ReductionRule(String rule) {
            this.rule = rule;
        }

        public void makeMostReduced() {
            if (this.first.indent == null) {
                throw new CantHappenException("Can't make rule " + this.rule + " with null indent most reduced");
            }
            if (this.first.indent.tabs != 1 || this.first.indent.spaces != 0) {
                throw new CantHappenException("Can't make rule " + this.rule + " most reduced with indent " + this.first.indent + " at line " + this.first.lineNo);
            }
            if (this.first.off != 0) {
                throw new CantHappenException("Can't make rule " + this.rule + " most reduced with offset " + this.first.off + " at line " + this.first.lineNo);
            }
            this.mostReduced = true;
        }

        public boolean isMostReduced() {
            return this.mostReduced;
        }

        public void range(InputPosition first, InputPosition last) {
            this.first = first;
            this.last = last;
        }

        public void lineNo(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        @Override
        public InputPosition location() {
            return this.first;
        }

        public InputPosition start() {
            return this.first;
        }

        public InputPosition last() {
            return this.last;
        }

        public boolean includes(InputPosition pos) {
            return pos.compareTo(this.first) >= 0 && pos.compareTo(this.last) <= 0;
        }

        public String ruleName() {
            return this.rule;
        }

        public String toString() {
            return this.rule + ": " + this.first + " -- " + this.last;
        }
    }
}

