/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.flasck.flas.Main;
import org.flasck.flas.compiler.PhaseTo;
import org.flasck.flas.errors.ErrorResultException;
import org.flasck.flas.testing.golden.Interceptor;
import org.flasck.flas.testing.golden.TestEnvironment;
import org.flasck.flas.testing.golden.grammar.GrammarChecker;
import org.flasck.flas.testing.golden.grammar.GrammarTree;
import org.junit.Assert;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.InitializationError;
import org.zinutils.bytecode.ByteCodeCreator;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.bytecode.IExpr;
import org.zinutils.bytecode.NewMethodDefiner;
import org.zinutils.cgharness.CGHClassLoader;
import org.zinutils.cgharness.CGHClassLoaderImpl;
import org.zinutils.cgharness.CGHarnessRunnerHelper;
import org.zinutils.cgharness.TestMethodContentProvider;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.utils.FileNameComparator;
import org.zinutils.utils.FileUtils;
import org.zinutils.utils.StringUtil;

public class GoldenCGRunner
extends BlockJUnit4ClassRunner {
    static String checkOption = System.getProperty("org.flasck.golden.check");
    static boolean checkEverything = checkOption == null || !checkOption.equalsIgnoreCase("false");
    static boolean checkNothing = checkOption != null && checkOption.equalsIgnoreCase("nothing");
    static String tdaOption = System.getProperty("org.flasck.golden.tda");
    static String useRunner = System.getProperty("org.flasck.golden.runner");
    static boolean useJSRunner = useRunner == null || useRunner.equals("js") || useRunner.equals("both");
    static boolean useJVMRunner = useRunner == null || useRunner.equals("jvm") || useRunner.equals("both");
    static String buildDroidOpt = System.getProperty("org.flasck.golden.buildDroid");
    static String maxcnt = System.getProperty("org.flasck.golden.cnt");
    static String flascklibOption = System.getProperty("org.flasck.golden.flascklib");
    static String flascklib = flascklibOption != null ? flascklibOption : "src/main/resources/flasck";
    private static int MAXCNT = maxcnt == null ? Integer.MAX_VALUE : Integer.parseInt(maxcnt);
    protected static Interceptor interceptor = null;
    private static String checkGrammarOption = System.getProperty("checkGrammar");
    private static boolean checkGrammar = checkGrammarOption == null || checkGrammarOption.equals("check");
    private static String moduleDir = System.getProperty("org.flasck.module.dir");
    public static final File jvmdir;

    public GoldenCGRunner(Class<?> clz) throws InitializationError, IOException, ErrorResultException {
        super(GoldenCGRunner.figureTests(clz));
    }

    private static Class<?> figureTests(Class<?> clz) throws IOException, ErrorResultException {
        ByteCodeEnvironment bce = new ByteCodeEnvironment();
        CGHClassLoaderImpl cl = new CGHClassLoaderImpl();
        Pattern p = null;
        String match = System.getProperty("org.flasck.golden.pattern");
        if (match != null && match.length() > 0) {
            p = Pattern.compile(match);
        }
        DecimalFormat df = new DecimalFormat("000");
        int cnt = 1;
        Set<File> sf = new TreeSet<File>((Comparator<File>)new FileNameComparator());
        for (Object f : FileUtils.findFilesMatching((File)new File("src/golden"), (String)"test.golden")) {
            if (!((File)f).isDirectory() || ((File)f).getParentFile().getName().equals("apps")) continue;
            sf.add(((File)f).getParentFile());
        }
        for (Object f : FileUtils.findFilesMatching((File)new File("src/golden"), (String)"packages")) {
            sf.add(((File)f).getParentFile());
        }
        sf = GoldenCGRunner.trackOrdering(sf);
        ByteCodeCreator bcc = CGHarnessRunnerHelper.emptyTestClass((ByteCodeEnvironment)bce, (String)clz.getName());
        bcc.addRTVAnnotation("org.junit.FixMethodOrder").addEnumParam((Enum)MethodSorters.NAME_ASCENDING);
        for (File dir : sf) {
            if (p == null || p.matcher(dir.getPath()).find()) {
                GoldenCGRunner.addGoldenTest(bcc, "ut" + df.format(cnt++) + "_", dir);
            }
            if (cnt <= MAXCNT) continue;
            break;
        }
        Class ret = CGHarnessRunnerHelper.generate((CGHClassLoader)cl, (ByteCodeCreator)bcc);
        return ret;
    }

    private static Set<File> trackOrdering(Set<File> sf) throws IOException {
        Set<File> ret;
        File orig = new File("testorder");
        if (orig.exists()) {
            ret = new LinkedHashSet<File>();
            try (LineNumberReader lnr = new LineNumberReader(new FileReader(orig));){
                String s;
                while ((s = lnr.readLine()) != null) {
                    File t = new File(s);
                    if (!t.isDirectory()) continue;
                    ret.add(t);
                }
            }
            ret.addAll(sf);
        } else {
            ret = sf;
        }
        File out = new File("testorder.new");
        try (PrintWriter pw = new PrintWriter(out);){
            for (File f : ret) {
                pw.println(f.getPath());
            }
        }
        Files.move(out.toPath(), orig.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return ret;
    }

    private static void addGoldenTest(ByteCodeCreator bcc, String prefix, File f) {
        boolean ignoreTest = new File(f, "ignore").exists();
        String phase = new File(f, "phase").exists() ? FileUtils.readFile((File)new File(f, "phase")) : PhaseTo.COMPLETE.toString();
        boolean runjvm = !new File(f, "jsonly").exists();
        boolean runjs = !new File(f, "jvmonly").exists();
        StringBuilder name = GoldenCGRunner.makeNameForTest(f);
        name.insert(0, prefix);
        GoldenCGRunner.addTests(bcc, f, name.toString(), ignoreTest, runjvm, runjs, phase);
    }

    private static StringBuilder makeNameForTest(File f) {
        StringBuilder name = new StringBuilder();
        for (File f1 = FileUtils.makeRelativeTo((File)f, (File)new File("src/golden")); f1 != null; f1 = f1.getParentFile()) {
            name.insert(0, StringUtil.capitalize((String)f1.getName()));
        }
        return name;
    }

    private static void addTests(ByteCodeCreator bcc, final File f, String name, boolean ignoreTest, final boolean runJvm, final boolean runJs, final String phase) {
        CGHarnessRunnerHelper.addMethod((ByteCodeCreator)bcc, (String)name, (boolean)ignoreTest, (TestMethodContentProvider)new TestMethodContentProvider(){

            public void defineMethod(NewMethodDefiner done) {
                done.callStatic(GoldenCGRunner.class.getName(), "void", "runGolden", new IExpr[]{done.stringConst(f.getPath()), done.boolConst(runJvm), done.boolConst(runJs), done.stringConst(phase)}).flush();
            }
        });
    }

    public static void runGolden(String s, boolean runJvm, boolean runJs, String phase) throws Exception {
        System.out.println("GoldenTest[" + s + "]:");
        TestEnvironment te = new TestEnvironment(jvmdir, s, useJSRunner && runJs, useJVMRunner && runJvm, checkNothing, checkEverything);
        te.cleanUp();
        if (interceptor != null) {
            interceptor.before(s);
        }
        File actualErrors = new File(s, "errors-tmp");
        File expectedErrors = new File(s, "errors");
        File tr = new File(s, "testReports-tmp");
        File packages = new File(s, "packages");
        File flimstore = new File(s, "flimstore");
        File flimstoreTo = new File(s, "flimstore-tmp");
        File flimfrom = new File(s, "flim-imports");
        File incldirs = new File(s, "imports");
        File modules = new File(s, "modules");
        File parseTokens = new File(s, "parsetokens");
        File reconstruct = new File(s, "reconstruct");
        FileUtils.cleanDirectory((File)actualErrors);
        FileUtils.cleanDirectory((File)tr);
        FileUtils.cleanDirectory((File)parseTokens);
        FileUtils.cleanDirectory((File)reconstruct);
        FileUtils.assertDirectory((File)actualErrors);
        FileUtils.assertDirectory((File)tr);
        FileUtils.assertDirectory((File)parseTokens);
        FileUtils.assertDirectory((File)reconstruct);
        FileUtils.deleteDirectoryTree((File)flimstoreTo);
        if (flimfrom.exists()) {
            FileUtils.assertDirectory((File)flimstoreTo);
        }
        List packageList = new ArrayList();
        if (packages.exists()) {
            packageList = FileUtils.readFileAsLines((File)packages);
        }
        if (flimstore.exists()) {
            TreeSet<String> create = new TreeSet<String>();
            for (File f : FileUtils.findFilesMatching((File)flimstore, (String)"*")) {
                create.add(f.getName());
            }
            create.removeAll(packageList);
            if (!create.isEmpty()) {
                FileUtils.assertDirectory((File)flimstoreTo);
                for (File f : FileUtils.findFilesMatching((File)flimstore, (String)"*")) {
                    FileUtils.copy((File)f, (File)flimstoreTo);
                }
            }
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("--project-dir", s, "--no-gen-apps", "--flascklib", flascklib, "--testReports", "testReports-tmp", "--errors", "errors-tmp/errors", "--types", "tc-tmp/types"));
        for (File wf : new File(s).listFiles()) {
            if (!wf.isDirectory() || !wf.getName().startsWith("web")) continue;
            args.add("--web");
            args.add(wf.getName());
        }
        if (!useJVMRunner || !runJvm) {
            args.add("--no-unit-jvm");
            args.add("--no-system-jvm");
        }
        if (useJSRunner && runJs) {
            args.add("--unit-js");
            args.add("--system-js");
        }
        if (flimstore.exists() || flimstoreTo.exists()) {
            args.add("--flim");
            args.add(flimstoreTo.getPath());
        }
        if (flimfrom.exists()) {
            for (String ff : FileUtils.readFileAsLines((File)flimfrom)) {
                if (ff.startsWith(".")) continue;
                args.add("--import");
                args.add("src/golden/" + ff + "/flimstore");
            }
        }
        if (incldirs.exists()) {
            for (String fi : FileUtils.readFileAsLines((File)incldirs)) {
                args.add("--import");
                args.add(fi);
            }
        }
        if (modules.exists()) {
            if (moduleDir == null) {
                throw new InvalidUsageException("cannot use modules without specifying -Dorg.flasck.module.dir");
            }
            args.add("--moduledir");
            args.add(moduleDir);
            for (String m : FileUtils.readFileAsLines((File)modules)) {
                args.add("--module");
                args.add(m);
            }
        }
        if (interceptor != null) {
            interceptor.addIncludes(args);
        }
        args.add("--testname");
        args.add(s.replace("/", "-").replace("src-golden-", ""));
        if (packages.exists()) {
            args.addAll(packageList);
        } else {
            args.add("test.golden");
        }
        Main.standardCompiler(parseTokens, args.toArray(new String[args.size()]));
        GoldenCGRunner.checkExpectedErrors(te, tr, expectedErrors, actualErrors);
        GrammarChecker r = new GrammarChecker(parseTokens, reconstruct);
        Map<String, GrammarTree> fileOrchards = r.checkParseTokenLogic(expectedErrors.isDirectory());
        if (checkGrammar) {
            r.checkGrammar(fileOrchards);
        }
        AssertionError tmp = null;
        try {
            te.checkTestResults(expectedErrors.isDirectory());
            te.checkFlimStore(expectedErrors.isDirectory());
            te.checkTypes(expectedErrors.isDirectory());
        }
        catch (AssertionError ex) {
            tmp = ex;
        }
        if (checkGrammar && !expectedErrors.isDirectory()) {
            File golden = new File(s, "test.golden");
            if (golden.exists()) {
                te.checkReconstructions(golden, reconstruct);
            }
            for (String p : packageList) {
                te.checkReconstructions(new File(s, p), reconstruct);
            }
        }
        if (tmp != null) {
            throw tmp;
        }
    }

    private static boolean checkExpectedErrors(TestEnvironment te, File tr, File expectedErrors, File actualErrors) {
        File aef = new File(actualErrors, "errors");
        if (expectedErrors.isDirectory()) {
            te.assertGolden(false, expectedErrors, actualErrors, fn -> true, false);
            return false;
        }
        if (aef.length() > 0L) {
            if (tr != null) {
                for (File f : FileUtils.findFilesMatching((File)tr, (String)"*.tr")) {
                    System.out.println("----- there are errors below, but the test logs may be relevant: " + f.getName());
                    FileUtils.cat((File)f);
                    System.out.println("-----");
                }
            }
            FileUtils.cat((File)aef);
            Assert.fail((String)"unexpected compilation errors");
            return false;
        }
        return true;
    }

    static {
        Main.setLogLevels();
        File jd = new File("../FLASJvm");
        if (!jd.exists() && !(jd = new File("../../FLASJvm")).exists()) {
            System.err.println("There is no directory for the FLASJvm code");
            jd = null;
        }
        jvmdir = jd;
    }
}

