/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testing.golden;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import org.flasck.flas.testing.golden.ParsedTokens;
import org.zinutils.exceptions.WrappedException;

public class FileReconstructor {
    private final ParsedTokens toks;
    private final File output;
    int lineNo = 1;
    boolean indented = false;
    int offset = 0;

    public FileReconstructor(ParsedTokens toks, File output) {
        this.toks = toks;
        this.output = output;
    }

    public void reconstruct() {
        try (PrintWriter pw = new PrintWriter(this.output);){
            for (ParsedTokens.GrammarToken t : this.toks.tokens()) {
                this.showToken(pw, t);
            }
            pw.println();
        }
        catch (FileNotFoundException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    private void showToken(PrintWriter pw, ParsedTokens.GrammarToken t) {
        while (t.lineNo() > this.lineNo) {
            pw.println();
            ++this.lineNo;
            this.indented = false;
            this.offset = 0;
        }
        if (!this.indented) {
            int i;
            for (i = 0; i < t.tabs(); ++i) {
                pw.print("\t");
            }
            for (i = 0; i < t.spaces(); ++i) {
                pw.print(" ");
            }
            this.indented = true;
        }
        while (this.offset < t.offset()) {
            pw.print(" ");
            ++this.offset;
        }
        pw.print(t.text);
        this.offset += t.text.length();
    }
}

