/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractImplementor;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.ContractProvider;
import org.flasck.flas.parsedForm.Implements;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.ut.UnitTestSend;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.CantHappenException;

public class UTSendChecker
extends LeafAdapter
implements ResultAware {
    private final NestedVisitor sv;
    private final ErrorReporter errors;
    private final UnitTestSend send;

    public UTSendChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, String fnCxt, UnitTestSend s) {
        this.errors = errors;
        this.sv = sv;
        this.send = s;
        sv.push(this);
        sv.push(new ExpressionChecker(errors, repository, new FunctionGroupTCState(repository, new DependencyGroup(new LogicHolder[0])), sv, fnCxt, false));
    }

    @Override
    public void result(Object r) {
        Implements ic;
        boolean isAllowed;
        PosType type = (PosType)r;
        Type ty = type.type;
        boolean bl = isAllowed = ty instanceof ContractImplementor || ty instanceof ContractProvider;
        if (!isAllowed && ty instanceof ContractDecl && ((ContractDecl)ty).type == ContractDecl.ContractType.HANDLER) {
            isAllowed = true;
        }
        if (!isAllowed) {
            this.errors.message(this.send.card.location(), "cannot send contract messages to " + this.send.card.var);
            return;
        }
        ContractDecl cd = null;
        NameOfThing cn = this.send.contract.namedDefn().name();
        if (ty instanceof ContractImplementor && (ic = ((ContractImplementor)((Object)ty)).implementsContract(cn)) != null) {
            cd = ic.actualType();
        }
        if (ty instanceof ContractProvider && (ic = ((ContractProvider)((Object)ty)).providesContract(cn)) != null) {
            cd = ic.actualType();
        }
        if (ty instanceof ContractDecl) {
            cd = (ContractDecl)ty;
        }
        if (cd != null) {
            int nargs;
            String meth;
            boolean haveHandler;
            boolean bl2 = haveHandler = this.send.handler != null;
            if (this.send.expr instanceof UnresolvedVar) {
                UnresolvedVar uv = (UnresolvedVar)this.send.expr;
                meth = uv.var;
                nargs = 0;
            } else if (this.send.expr instanceof ApplyExpr) {
                ApplyExpr ae = (ApplyExpr)this.send.expr;
                meth = ((UnresolvedVar)ae.fn).var;
                nargs = ae.args.size();
            } else {
                throw new CantHappenException("What is this? " + this.send.expr.getClass());
            }
            ContractMethodDecl method = cd.getMethod(meth);
            if (method == null) {
                this.errors.message(this.send.card.location(), "contract " + cn + " does not offer method " + meth);
                return;
            }
            if (haveHandler && method.handler == null) {
                this.errors.message(this.send.card.location(), "contract method " + cn + "." + meth + " does not expect a handler");
                return;
            }
            if (!haveHandler && method.handler != null) {
                this.errors.message(this.send.card.location(), "contract method " + cn + "." + meth + " expects a handler");
                return;
            }
            if (nargs != method.args.size()) {
                this.errors.message(this.send.card.location(), "contract method " + cn + "." + meth + " expects " + method.args.size() + " not " + nargs);
                return;
            }
        } else {
            this.errors.message(this.send.card.location(), this.send.card.var + " does not offer contract " + cn);
            return;
        }
    }

    @Override
    public void leaveUnitTestSend(UnitTestSend s) {
        this.sv.result(null);
    }
}

