/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ut.UnitTestAssert;
import org.flasck.flas.parsedForm.ut.UnitTestIdentical;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.NotImplementedException;

public class UTAChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private final String fnCxt;
    private final List<Type> results = new ArrayList<Type>();

    public UTAChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, String fnCxt) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.fnCxt = fnCxt;
        sv.push(this);
    }

    @Override
    public void visitAssertExpr(boolean isValue, Expr e) {
        this.sv.push(new ExpressionChecker(this.errors, this.repository, new FunctionGroupTCState(this.repository, new DependencyGroup(new LogicHolder[0])), this.sv, this.fnCxt, false));
    }

    @Override
    public void result(Object r) {
        Type t = ((ExpressionChecker.ExprResult)r).type;
        this.results.add(t);
    }

    @Override
    public void postUnitTestAssert(UnitTestAssert a) {
        this.assertOrIdentical(a.expr, a.value);
    }

    @Override
    public void postUnitTestIdentical(UnitTestIdentical a) {
        this.assertOrIdentical(a.expr, a.value);
    }

    private void assertOrIdentical(Expr pexpr, Expr pvalue) {
        if (this.results.size() != 2) {
            throw new NotImplementedException();
        }
        Type value = this.results.get(0);
        Type expr = this.results.get(1);
        if (value instanceof ErrorType || expr instanceof ErrorType) {
            this.sv.result(null);
            return;
        }
        if (value != expr) {
            if (expr instanceof UnifiableType) {
                ((UnifiableType)expr).incorporatedBy(pexpr.location(), value);
            } else if (!expr.incorporates(pvalue.location(), value) && !this.isError(value)) {
                this.errors.message(pvalue.location(), "value is of type " + value.signature() + " that cannot be the result of an expression of type " + expr.signature());
            }
        }
        this.sv.result(null);
    }

    private boolean isError(Type value) {
        if (value == LoadBuiltins.error || value instanceof ErrorType) {
            return true;
        }
        if (value instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)value;
            for (Type t : pi.polys()) {
                if (!this.isError(t)) continue;
                return true;
            }
        }
        return false;
    }
}

