/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.NamedType;

public class UDDChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private final String fnCxt;
    private NamedType actualType;

    public UDDChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, String fnCxt) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.fnCxt = fnCxt;
        sv.push(this);
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        this.actualType = var.namedDefn();
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        this.sv.push(new ExpressionChecker(this.errors, this.repository, new FunctionGroupTCState(this.repository, new DependencyGroup(new LogicHolder[0])), this.sv, this.fnCxt, false));
    }

    @Override
    public void result(Object r) {
        ExpressionChecker.ExprResult exprType = (ExpressionChecker.ExprResult)r;
        if (!this.actualType.incorporates(exprType.pos, exprType.type)) {
            if (!(exprType.type instanceof ErrorType)) {
                this.errors.message(exprType.pos, "cannot store " + exprType.type.signature() + " in data " + this.actualType.signature());
            }
            this.sv.result(null);
            return;
        }
    }

    @Override
    public void leaveUnitDataDeclaration(UnitDataDeclaration udd) {
        this.sv.result(null);
    }
}

