/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.Arrays;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Primitive;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.NotImplementedException;

public class TypeHelpers {
    public static Type listMessage(InputPosition pos) {
        return new PolyInstance(pos, LoadBuiltins.list, Arrays.asList(LoadBuiltins.message));
    }

    public static boolean isPrimitive(Type type) {
        return type instanceof Primitive;
    }

    public static boolean isPrimitiveString(Type type) {
        if (type instanceof Primitive) {
            return ((Primitive)type).getName().baseName().equals("String");
        }
        return false;
    }

    public static boolean isList(Type type) {
        if (type == LoadBuiltins.nil) {
            return true;
        }
        if (!(type instanceof PolyInstance)) {
            return false;
        }
        PolyInstance pi = (PolyInstance)type;
        if (pi.struct().equals(LoadBuiltins.list)) {
            return true;
        }
        return pi.struct().equals(LoadBuiltins.cons);
    }

    public static boolean isListLike(Type type) {
        return TypeHelpers.isList(type) || TypeHelpers.isCrobag(type);
    }

    private static boolean isCrobag(Type type) {
        if (type instanceof PolyInstance) {
            type = ((PolyInstance)type).struct();
        }
        return type instanceof ObjectDefn && ((ObjectDefn)type).name().uniqueName().equals("Crobag");
    }

    public static boolean isListString(Type type) {
        if (!(type instanceof PolyInstance)) {
            return false;
        }
        PolyInstance pi = (PolyInstance)type;
        if (!pi.struct().equals(LoadBuiltins.list)) {
            return false;
        }
        Type ty = pi.polys().get(0);
        return ty.equals(LoadBuiltins.string);
    }

    public static boolean isListCard(Type etype) {
        if (!(etype instanceof PolyInstance)) {
            return false;
        }
        PolyInstance pi = (PolyInstance)etype;
        if (!pi.struct().equals(LoadBuiltins.list)) {
            return false;
        }
        Type ty = pi.polys().get(0);
        return ty.equals(LoadBuiltins.card);
    }

    public static Type extractListPoly(Type etype) {
        if (TypeHelpers.isListLike(etype)) {
            return ((PolyInstance)etype).polys().get(0);
        }
        throw new NotImplementedException("not a list");
    }

    public static boolean isListMessage(InputPosition pos, Type check) {
        Apply ac;
        if (check instanceof ErrorType) {
            return false;
        }
        if (check == LoadBuiltins.nil) {
            return true;
        }
        if (check instanceof Apply && (ac = (Apply)check).argCount() == 1 && ac.tys.get(0) == LoadBuiltins.contract) {
            check = ac.tys.get(1);
        }
        if (check instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)check;
            NamedType nt = pi.struct();
            if (nt == LoadBuiltins.cons || nt == LoadBuiltins.list) {
                Type pv = pi.polys().get(0);
                if (LoadBuiltins.message.incorporates(pos, pv)) {
                    return true;
                }
            } else {
                return false;
            }
        }
        if (LoadBuiltins.listMessages.incorporates(pos, check)) {
            return true;
        }
        return LoadBuiltins.message.incorporates(pos, check);
    }

    public static boolean isEntity(Type arg) {
        if (arg instanceof StructDefn) {
            StructDefn s = (StructDefn)arg;
            return s.type == FieldsDefn.FieldsType.ENTITY;
        }
        if (arg instanceof Primitive) {
            return ((Primitive)arg).name().uniqueName().equals("Entity");
        }
        return false;
    }
}

