/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.io.PrintWriter;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.repository.LeafAdapter;

public class TypeDumper
extends LeafAdapter {
    private final PrintWriter pw;

    public TypeDumper(PrintWriter pw) {
        this.pw = pw;
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        if (fn.intros().isEmpty()) {
            return;
        }
        this.pw.print(fn.name().uniqueName());
        this.pw.print(" :: ");
        if (fn.type() == null) {
            this.pw.print("<<UNDEFINED>>");
        } else {
            this.pw.print(fn.type().signature());
        }
        if (fn.constNess() != null && fn.constNess().isConstant()) {
            this.pw.print(" [const]");
        }
        this.pw.println();
    }

    @Override
    public void visitObjectMethod(ObjectMethod om) {
        if (!om.generate) {
            return;
        }
        this.pw.print(om.name().uniqueName());
        this.pw.print(" :: ");
        if (!om.hasType() || om.type() == null) {
            this.pw.print("<<UNDEFINED>>");
        } else {
            this.pw.print(om.type().signature());
        }
        if (om.constNess() != null && om.constNess().isConstant()) {
            this.pw.print(" [const]");
        }
        this.pw.println();
    }

    @Override
    public void visitObjectCtor(ObjectCtor oc) {
        if (!oc.generate) {
            return;
        }
        this.pw.print(oc.name().uniqueName());
        this.pw.print(" :: ");
        if (!oc.hasType() || oc.type() == null) {
            this.pw.print("<<UNDEFINED>>");
        } else {
            this.pw.print(oc.type().signature());
        }
        if (oc.constNess() != null && oc.constNess().isConstant()) {
            this.pw.print(" [const]");
        }
        this.pw.println();
    }

    @Override
    public void visitTuple(TupleAssignment e) {
    }

    @Override
    public void visitTupleMember(TupleMember tm) {
        this.pw.print(tm.name().uniqueName());
        this.pw.print(" :: ");
        if (tm.type() == null) {
            this.pw.print("<<UNDEFINED>>");
        } else {
            this.pw.print(tm.type().signature());
        }
        if (tm.constNess() != null && tm.constNess().isConstant()) {
            this.pw.print(" [const]");
        }
        this.pw.println();
    }
}

