/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AccessorHolder;
import org.flasck.flas.parsedForm.FieldAccessor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PolyHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.CallOnResolution;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Primitive;
import org.flasck.flas.tc3.StructFieldConstraints;
import org.flasck.flas.tc3.StructTypeConstraints;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeHelpers;
import org.flasck.flas.tc3.UnifiableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.graphs.DirectedAcyclicGraph;

public class TypeConstraintSet
implements UnifiableType {
    private static final Logger logger = LoggerFactory.getLogger((String)"TCUnification");
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final InputPosition pos;
    private final String motive;
    private final String id;
    private final Set<PosType> incorporatedBys = new HashSet<PosType>();
    private final Map<NamedType, StructTypeConstraints> ctors = new TreeMap<NamedType, StructTypeConstraints>(NamedType.nameComparator);
    private final Set<PosType> types = new HashSet<PosType>();
    private final Set<UnifiableApplication> applications = new HashSet<UnifiableApplication>();
    private Type resolvedTo;
    private int usedOrReturned = 0;
    private final TreeSet<Comment> comments = new TreeSet();
    private final Set<PosType> tys = new HashSet<PosType>();
    private TypeConstraintSet redirectedTo;
    private final Set<UnifiableType> acquired = new HashSet<UnifiableType>();
    private final Set<UnifiableType> polyvars = new HashSet<UnifiableType>();
    private final List<ErrorConstraint> errorConstraints = new ArrayList<ErrorConstraint>();
    private Comparator<Type> signatureComparator = new Comparator<Type>(){

        @Override
        public int compare(Type o1, Type o2) {
            return o1.signature().compareTo(o2.signature());
        }
    };
    private final boolean needAll;
    private final List<CallOnResolution> onResolved = new ArrayList<CallOnResolution>();
    private List<FieldOf> fieldExprs = new ArrayList<FieldOf>();
    static final Comparator<? super PosType> posNameComparator = new Comparator<PosType>(){

        @Override
        public int compare(PosType o1, PosType o2) {
            if (o1.pos == null) {
                if (o2.pos != null) {
                    return -1;
                }
            } else {
                if (o2.pos == null) {
                    return 1;
                }
                int cp = o1.pos.compareTo(o2.pos);
                if (cp != 0) {
                    return cp;
                }
            }
            return o1.type.toString().compareTo(o2.type.toString());
        }
    };

    public TypeConstraintSet(RepositoryReader r, CurrentTCState state, InputPosition pos, String id, String motive, boolean unionNeedsAll) {
        this.repository = r;
        this.state = state;
        this.pos = pos;
        this.id = id;
        this.motive = motive;
        this.needAll = unionNeedsAll;
        this.comments.add(new Comment(pos, id + " created because " + motive, null));
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public InputPosition location() {
        return this.pos;
    }

    @Override
    public String motive() {
        return this.motive;
    }

    public boolean isResolved() {
        return this.resolvedTo != null;
    }

    @Override
    public Type resolvedTo() {
        if (this.redirectedTo != null) {
            return this.redirectedTo().resolvedTo();
        }
        if (this.resolvedTo == null) {
            throw new InvalidUsageException("wait until " + this.id + " is resolved");
        }
        return this.resolvedTo;
    }

    private Type resolvingTo(HashSet<UnifiableType> workingOn) {
        if (this.redirectedTo != null) {
            return ((TypeConstraintSet)this.redirectedTo()).resolvingTo(workingOn);
        }
        if (this.resolvedTo != null) {
            return this.resolvedTo;
        }
        if (workingOn.contains(this)) {
            return null;
        }
        throw new InvalidUsageException("wait until " + this.id + " is resolved: working on " + workingOn);
    }

    @Override
    public boolean mustBeMessage(ErrorReporter errors) {
        throw new NotImplementedException();
    }

    @Override
    public boolean enhance() {
        boolean again = false;
        block0: while (true) {
            ArrayList<PosType> refs = new ArrayList<PosType>();
            for (PosType pt : this.types) {
                Type t = pt.type;
                if (!(t instanceof TypeConstraintSet)) continue;
                TypeConstraintSet other = (TypeConstraintSet)t;
                boolean needsMe = true;
                for (PosType t2 : other.types) {
                    if (t2.type == this) {
                        needsMe = false;
                        continue;
                    }
                    if (this.types.contains(t2)) continue;
                    refs.add(t2);
                }
                if (!needsMe) continue;
                other.sameAs(this.pos, this);
                again = true;
            }
            if (refs.isEmpty()) {
                return again;
            }
            again = true;
            this.types.addAll(refs);
            Iterator<PosType> iterator = refs.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                PosType t = iterator.next();
                if (!(t.type instanceof TypeConstraintSet)) continue;
                this.comments.addAll(((TypeConstraintSet)t.type).comments);
            }
            break;
        }
    }

    @Override
    public void acquireOthers(List<UnifiableType> considered) {
        HashSet<PosType> ts1 = new HashSet<PosType>(this.types);
        ts1.addAll(this.incorporatedBys);
        for (PosType pt : ts1) {
            Type t = pt.type;
            if (!(t instanceof TypeConstraintSet)) continue;
            TypeConstraintSet ut = (TypeConstraintSet)t;
            if (considered.contains(ut)) {
                ut.redirectedTo().acquire(this);
                continue;
            }
            this.acquire(ut);
        }
        Iterator<PosType> i = this.types.iterator();
        while (i.hasNext()) {
            if (!(i.next().type instanceof TypeConstraintSet)) continue;
            i.remove();
        }
    }

    @Override
    public UnifiableType redirectedTo() {
        if (this.redirectedTo != null) {
            return this.redirectedTo.redirectedTo();
        }
        return this;
    }

    @Override
    public boolean isRedirected() {
        return this.redirectedTo != null;
    }

    @Override
    public void acquire(UnifiableType ut) {
        if (ut == this) {
            return;
        }
        if (this.isRedirected()) {
            this.redirectedTo().acquire(ut);
            return;
        }
        TypeConstraintSet tcs = (TypeConstraintSet)ut;
        if (tcs.redirectedTo != null) {
            this.acquire(tcs.redirectedTo());
            return;
        }
        tcs.redirectedTo = this;
        this.applications.addAll(tcs.applications);
        this.comments.addAll(tcs.comments);
        this.ctors.putAll(tcs.ctors);
        this.incorporatedBys.addAll(tcs.incorporatedBys);
        for (PosType ty : tcs.types) {
            if (ty.type instanceof UnifiableType) continue;
            this.types.add(ty);
        }
        this.usedOrReturned += tcs.usedOrReturned;
        this.acquired.add(tcs);
        this.acquired.addAll(tcs.acquired);
        this.errorConstraints.addAll(tcs.errorConstraints);
        this.onResolved.addAll(tcs.onResolved);
        this.fieldExprs.addAll(tcs.fieldExprs);
    }

    @Override
    public void expandUsed() {
        if (this.usedOrReturned == 0) {
            return;
        }
        for (PosType pt : this.types) {
            this.expandUsage(pt.type);
        }
        for (StructTypeConstraints e : this.ctors.values()) {
            for (StructField sf : e.fields()) {
                this.expandUsage(e.get(sf));
            }
        }
        for (PosType pt : this.incorporatedBys) {
            this.expandUsage(pt.type);
        }
    }

    private void expandUsage(Type type) {
        if (type instanceof TypeConstraintSet) {
            TypeConstraintSet ut = (TypeConstraintSet)type;
            if (ut.usedOrReturned == 0) {
                ut.usedOrReturned = 1;
                ut.expandUsed();
            }
        } else if (type instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)type;
            for (Type e : pi.polys()) {
                this.expandUsage(e);
            }
        }
    }

    @Override
    public void expandUnions() {
        ArrayList<PosType> addMore = new ArrayList<PosType>();
        for (PosType pt : this.types) {
            this.expandUnion(addMore, pt);
        }
        this.types.addAll(addMore);
        addMore = new ArrayList();
        for (PosType pt : this.incorporatedBys) {
            this.expandUnion(addMore, pt);
        }
        this.incorporatedBys.addAll(addMore);
    }

    private void expandUnion(List<PosType> addMore, PosType pt) {
        block8: {
            PolyInstance pi;
            Type t;
            InputPosition pos;
            block7: {
                pos = pt.pos;
                t = pt.type;
                if (!(t instanceof UnionTypeDefn)) break block7;
                UnionTypeDefn utd = (UnionTypeDefn)t;
                for (TypeReference c : utd.cases) {
                    NamedType sd = c.namedDefn();
                    addMore.add(new PosType(pos, sd));
                }
                break block8;
            }
            if (!(t instanceof PolyInstance) || !((pi = (PolyInstance)t).struct() instanceof UnionTypeDefn)) break block8;
            UnionTypeDefn utd = (UnionTypeDefn)pi.struct();
            HashMap<PolyType, Type> mt = new HashMap<PolyType, Type>();
            for (int p = 0; p < utd.polys().size(); ++p) {
                mt.put(utd.polys().get(p), pi.polys().get(p));
            }
            for (TypeReference c : utd.cases) {
                if (c.namedDefn() instanceof StructDefn) {
                    StructDefn sd = (StructDefn)c.namedDefn();
                    if (sd.hasPolys()) {
                        throw new CantHappenException("should be polyinstance");
                    }
                    addMore.add(new PosType(pos, sd));
                    continue;
                }
                if (c.namedDefn() instanceof PolyInstance) {
                    PolyInstance pc = (PolyInstance)c.namedDefn();
                    ArrayList<Type> pm = new ArrayList<Type>();
                    for (Type p : pc.polys()) {
                        pm.add((Type)mt.get(p));
                    }
                    addMore.add(new PosType(pos, new PolyInstance(pos, pc.struct(), pm)));
                    continue;
                }
                throw new HaventConsideredThisException("expecting struct or polyinstance");
            }
        }
    }

    @Override
    public void mergePolyVars() {
        PolyInstance pi;
        ListMap groups = new ListMap();
        for (PosType pt : this.types) {
            if (!(pt.type instanceof PolyInstance) || !((pi = (PolyInstance)pt.type).struct() instanceof PolyHolder)) continue;
            groups.add((Object)((PolyHolder)pi.struct()), (Object)pi);
        }
        for (PosType pt : this.incorporatedBys) {
            if (!(pt.type instanceof PolyInstance) || !((pi = (PolyInstance)pt.type).struct() instanceof PolyHolder)) continue;
            groups.add((Object)((PolyHolder)pi.struct()), (Object)pi);
        }
        for (NamedType nt : this.ctors.keySet()) {
            if (!(nt instanceof PolyInstance) || !((pi = (PolyInstance)nt).struct() instanceof PolyHolder)) continue;
            groups.add((Object)((PolyHolder)pi.struct()), (Object)pi);
        }
        for (PolyHolder e : groups.keySet()) {
            List list = groups.get((Object)e);
            if (list.size() <= 1) continue;
            for (int i = 0; i < e.polys().size(); ++i) {
                ArrayList<PosType> tojoin = new ArrayList<PosType>();
                for (PolyInstance pi2 : list) {
                    tojoin.add(new PosType(pi2.location(), pi2.polys().get(i)));
                }
                this.state.consolidate(((PosType)tojoin.get(0)).location(), tojoin);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectInfo(ErrorReporter errors, DirectedAcyclicGraph<UnifiableType> dag) {
        UnifiableType ut;
        logger.debug("collecting info on " + this.id + ": " + this.motive);
        HashSet<PosType> ts1 = new HashSet<PosType>(this.types);
        ts1.addAll(this.incorporatedBys);
        for (PosType posType : ts1) {
            Type type = posType.type;
            logger.debug("  have type " + type);
            if (type == null) {
                throw new NotImplementedException("should not be null");
            }
            if (type instanceof UnifiableType) {
                UnifiableType unifiableType = ((UnifiableType)type).redirectedTo();
                dag.ensure((Object)unifiableType);
                if (this != unifiableType) {
                    dag.ensureLink((Object)this, (Object)unifiableType);
                }
            }
            if (type instanceof PolyInstance) {
                PolyInstance polyInstance = (PolyInstance)type;
                this.linkToPVs(dag, polyInstance);
                this.tys.add(posType);
                continue;
            }
            if (type instanceof StructDefn && ((StructDefn)type).hasPolys()) {
                StructDefn structDefn = (StructDefn)type;
                ArrayList<Type> arrayList = new ArrayList<Type>();
                for (PolyType p : structDefn.polys()) {
                    arrayList.add(LoadBuiltins.any);
                }
                this.tys.add(new PosType(posType.pos, new PolyInstance(this.pos, structDefn, arrayList)));
                continue;
            }
            if (type instanceof Apply) {
                Apply apply = (Apply)type;
                for (Type type2 : apply.tys) {
                    if (type2 instanceof PolyInstance) {
                        this.linkToPVs(dag, (PolyInstance)type2);
                        continue;
                    }
                    if (!(type2 instanceof UnifiableType)) continue;
                    ut = (UnifiableType)type2;
                    dag.ensure((Object)ut);
                    dag.ensureLink((Object)this, (Object)ut);
                }
                this.tys.add(posType);
                continue;
            }
            this.tys.add(posType);
        }
        for (Map.Entry entry : this.ctors.entrySet()) {
            NamedType namedType = (NamedType)entry.getKey();
            logger.debug("  have ctor " + namedType);
            if (namedType instanceof StructDefn && !((StructDefn)namedType).hasPolys()) {
                this.tys.add(new PosType(this.pos, namedType));
                continue;
            }
            if (!(namedType instanceof PolyInstance)) continue;
            this.linkPVs(dag, namedType);
            this.tys.add(new PosType(this.pos, namedType));
        }
        if (this.applications.size() == 1) {
            UnifiableApplication ua = this.applications.iterator().next();
            this.tys.add(ua.asApply());
            logger.debug("  [have 1 application: " + ua + "]");
            for (Type type : ua.args) {
                if (type instanceof UnifiableType) {
                    UnifiableType unifiableType = ((UnifiableType)type).redirectedTo();
                    logger.debug("  have apply dependency on: " + unifiableType.id());
                    dag.ensure((Object)unifiableType);
                    dag.ensureLink((Object)this, (Object)unifiableType);
                    continue;
                }
                if (!(type instanceof PolyInstance)) continue;
                PolyInstance polyInstance = (PolyInstance)type;
                for (Type type3 : polyInstance.polys()) {
                    if (!(type3 instanceof UnifiableType)) continue;
                    ut = ((UnifiableType)type3).redirectedTo();
                    dag.ensure((Object)ut);
                    dag.ensureLink((Object)this, (Object)ut);
                }
            }
            if (ua.ret instanceof UnifiableType) {
                UnifiableType unifiableType = ((UnifiableType)ua.ret).redirectedTo();
                logger.debug("  have apply dependency on: " + unifiableType.id());
                dag.ensure((Object)unifiableType);
                dag.ensureLink((Object)this, (Object)unifiableType);
            } else if (ua.ret instanceof PolyInstance) {
                PolyInstance polyInstance = (PolyInstance)ua.ret;
                for (Type type : polyInstance.polys()) {
                    if (!(type instanceof UnifiableType)) continue;
                    UnifiableType unifiableType = ((UnifiableType)type).redirectedTo();
                    dag.ensure((Object)unifiableType);
                    dag.ensureLink((Object)this, (Object)unifiableType);
                }
            }
        } else if (!this.applications.isEmpty()) {
            void var6_31;
            int cnt = Integer.MAX_VALUE;
            for (UnifiableApplication unifiableApplication : this.applications) {
                cnt = Math.min(cnt, unifiableApplication.args.size());
            }
            ArrayList<TreeSet<? super PosType>> arrayList = new ArrayList<TreeSet<? super PosType>>();
            boolean bl = false;
            while (var6_31 < cnt) {
                arrayList.add(new TreeSet<PosType>(posNameComparator));
                ++var6_31;
            }
            block9: for (UnifiableApplication unifiableApplication : this.applications) {
                logger.debug("  [have application: " + unifiableApplication + "]");
                int n = 0;
                for (Type t : unifiableApplication.args) {
                    if (n >= arrayList.size()) continue block9;
                    ((Set)arrayList.get(n++)).add(new PosType(unifiableApplication.pos, t));
                    if (t instanceof UnifiableType) {
                        UnifiableType ut6 = ((UnifiableType)t).redirectedTo();
                        logger.debug("  have apply dependency on : " + ut6.id());
                        dag.ensure((Object)ut6);
                        dag.ensureLink((Object)this, (Object)ut6);
                        continue;
                    }
                    if (!(t instanceof PolyInstance)) continue;
                    PolyInstance pi3 = (PolyInstance)t;
                    for (Type ti : pi3.polys()) {
                        if (!(ti instanceof UnifiableType)) continue;
                        UnifiableType ut5 = ((UnifiableType)ti).redirectedTo();
                        dag.ensure((Object)ut5);
                        dag.ensureLink((Object)this, (Object)ut5);
                    }
                }
            }
            ArrayList<Type> arrayList2 = new ArrayList<Type>();
            for (Set set : arrayList) {
                Type type = this.state.consolidate((InputPosition)this.pos, (Collection<PosType>)set).type;
                if (type instanceof UnifiableType) {
                    ut = ((UnifiableType)type).redirectedTo();
                    dag.ensure((Object)ut);
                    dag.ensureLink((Object)this, (Object)ut);
                }
                arrayList2.add(type);
            }
            TreeSet<PosType> treeSet = new TreeSet<PosType>(posNameComparator);
            for (UnifiableApplication unifiableApplication : this.applications) {
                Type r = unifiableApplication.ret;
                if (unifiableApplication.args.size() > cnt) {
                    ArrayList<Type> as = new ArrayList<Type>();
                    for (int i = cnt; i < unifiableApplication.args.size(); ++i) {
                        as.add(unifiableApplication.args.get(i));
                    }
                    r = new Apply(as, r);
                }
                treeSet.add(new PosType(unifiableApplication.pos, r));
                if (r instanceof UnifiableType) {
                    UnifiableType ut2 = ((UnifiableType)r).redirectedTo();
                    logger.debug("  have apply dependency on: " + ut2.id());
                    dag.ensure((Object)ut2);
                    dag.ensureLink((Object)this, (Object)ut2);
                    continue;
                }
                if (!(r instanceof PolyInstance)) continue;
                PolyInstance pi = (PolyInstance)r;
                for (Type t : pi.polys()) {
                    if (!(t instanceof UnifiableType)) continue;
                    UnifiableType ut3 = ((UnifiableType)t).redirectedTo();
                    dag.ensure((Object)ut3);
                    dag.ensureLink((Object)this, (Object)ut3);
                }
            }
            PosType posType = this.state.consolidate(this.pos, treeSet);
            if (posType.type instanceof UnifiableType) {
                UnifiableType unifiableType = ((UnifiableType)posType.type).redirectedTo();
                dag.ensure((Object)unifiableType);
                dag.ensureLink((Object)this, (Object)unifiableType);
            }
            this.tys.add(new PosType(posType.pos, new Apply(arrayList2, posType.type)));
        }
        for (UnifiableType unifiableType : this.polyvars) {
            dag.ensure((Object)unifiableType);
            dag.ensureLink((Object)this, (Object)unifiableType);
        }
        if (this.usedOrReturned > 0) {
            logger.info("  is used or returned");
        }
        for (FieldOf fieldOf : this.fieldExprs) {
            logger.debug("  is field '" + fieldOf.fieldName + "' of " + fieldOf.fieldOf.redirectedTo().id());
            dag.ensure((Object)fieldOf.fieldOf.redirectedTo());
            dag.ensureLink((Object)this, (Object)fieldOf.fieldOf.redirectedTo());
        }
        if (this.redirectedTo != null) {
            dag.ensure((Object)this.redirectedTo);
            dag.ensureLink((Object)this, (Object)this.redirectedTo);
        }
    }

    private void linkPVs(DirectedAcyclicGraph<UnifiableType> dag, Type pv) {
        if (pv instanceof UnifiableType) {
            UnifiableType ut = ((UnifiableType)pv).redirectedTo();
            dag.ensure((Object)ut);
            dag.ensureLink((Object)this, (Object)ut);
        } else if (pv instanceof PolyInstance) {
            this.linkToPVs(dag, (PolyInstance)pv);
        }
    }

    private void linkToPVs(DirectedAcyclicGraph<UnifiableType> dag, PolyInstance pi) {
        for (Type pv : pi.polys()) {
            this.linkPVs(dag, pv);
        }
    }

    @Override
    public Type resolve(ErrorReporter errors) {
        logger.debug("resolving " + this.id + " " + this.motive + " types = " + this.tys);
        if (this.redirectedTo != null && this.redirectedTo.resolvedTo == null) {
            throw new CantHappenException("We shouldn't be asked before our redirection");
        }
        if (this.redirectedTo != null) {
            return this.redirectedTo.resolvedTo;
        }
        if (this.resolvedTo != null) {
            return this.resolvedTo;
        }
        HashSet<PosType> resolved = new HashSet<PosType>();
        for (PosType ty : this.tys) {
            Type rt;
            if (ty.type == this || (rt = this.resolvePolyArg(new HashSet<UnifiableType>(), ty.type)) == null) continue;
            resolved.add(new PosType(ty.pos, rt));
        }
        for (FieldOf ff : this.fieldExprs) {
            AccessorHolder ah;
            FieldAccessor f;
            ObjectDefn od;
            ObjectMethod meth;
            Object r = ff.fieldOf.resolvedTo();
            if (r instanceof PolyInstance) {
                PolyInstance pi = (PolyInstance)r;
                r = pi.struct();
            }
            if (r instanceof ErrorType) {
                this.resolvedTo = r;
                return r;
            }
            if (r instanceof ObjectDefn && (meth = (od = (ObjectDefn)r).getMethod(ff.fieldName)) != null) {
                resolved.add(new PosType(this.pos, meth.type()));
                continue;
            }
            if (r instanceof AccessorHolder && (f = (ah = (AccessorHolder)r).getAccessor(ff.fieldName)) != null) {
                resolved.add(new PosType(this.pos, f.type()));
                continue;
            }
            if (r instanceof Primitive) {
                errors.message(this.pos, "cannot extract field " + ff.fieldName + " from primitive type " + r.signature());
                continue;
            }
            if (r instanceof UnionTypeDefn) {
                errors.message(this.pos, "cannot access members of unions");
                continue;
            }
            errors.message(this.pos, "there is no field " + ff.fieldName + " in " + r.signature());
        }
        if (resolved.isEmpty()) {
            this.resolvedTo = this.usedOrReturned > 0 || !this.acquired.isEmpty() ? this.state.nextPoly(this.pos) : LoadBuiltins.any;
        } else if (resolved.size() == 1) {
            this.resolvedTo = ((PosType)resolved.iterator().next()).type;
        } else {
            logger.debug("want to unify " + resolved);
            TreeSet<Type> alltys = new TreeSet<Type>(this.signatureComparator);
            HashSet<Integer> acs = new HashSet<Integer>();
            for (PosType pt : resolved) {
                if (pt.type instanceof ErrorType) {
                    this.resolvedTo = pt.type;
                    return pt.type;
                }
                alltys.add(pt.type);
                if (pt.type instanceof Apply) {
                    acs.add(((Apply)pt.type).argCount());
                    continue;
                }
                acs.add(0);
            }
            logger.debug("acs = " + acs);
            if (acs.size() != 1) {
                logger.error("different apply sizes");
                for (PosType pt : resolved) {
                    logger.error("  " + pt.type + " @ " + pt.pos);
                }
            } else {
                Integer cnt = (Integer)acs.iterator().next();
                if (cnt != 0) {
                    logger.debug("unifying functions with arity: " + cnt + ": " + alltys);
                    ArrayList<Type> us = new ArrayList<Type>();
                    for (int i = 0; i <= cnt; ++i) {
                        HashSet<Type> ms = new HashSet<Type>();
                        for (Type t : alltys) {
                            ms.add(((Apply)t).tys.get(i));
                        }
                        Type rt = this.repository.findUnionWith(errors, this.pos, ms, this.needAll);
                        if (rt == null) break;
                        us.add(rt);
                    }
                    if (us.size() == cnt + 1) {
                        this.resolvedTo = new Apply(us);
                    }
                } else {
                    logger.debug("looking for union with " + alltys + (this.needAll ? " (need all)" : " (accept subset)"));
                    this.resolvedTo = this.repository.findUnionWith(errors, this.pos, alltys, this.needAll);
                }
            }
            if (this.resolvedTo == null) {
                NamedType shared = null;
                ArrayList args = new ArrayList();
                for (Type ty : alltys) {
                    if (ty instanceof PolyInstance) {
                        int i;
                        PolyInstance pi = (PolyInstance)ty;
                        NamedType po = pi.struct();
                        if (shared == null) {
                            shared = po;
                            for (i = 0; i < pi.polys().size(); ++i) {
                                args.add(new HashSet());
                            }
                        } else if (!shared.equals(po)) {
                            shared = null;
                            break;
                        }
                        for (i = 0; i < pi.polys().size(); ++i) {
                            ((Set)args.get(i)).add(pi.polys().get(i));
                        }
                        continue;
                    }
                    shared = null;
                    break;
                }
                if (shared != null) {
                    ArrayList<Type> unified = new ArrayList<Type>();
                    for (int i = 0; i < args.size(); ++i) {
                        Set tounify = (Set)args.get(i);
                        if (tounify.size() == 1) {
                            unified.add((Type)CollectionUtils.any((Iterable)tounify));
                            continue;
                        }
                        Type asUnion = this.repository.findUnionWith(errors, this.pos, tounify, this.needAll);
                        if (asUnion == null) break;
                        unified.add(asUnion);
                    }
                    if (unified.size() == args.size()) {
                        this.resolvedTo = new PolyInstance(this.pos, shared, unified);
                    }
                }
            }
            if (this.resolvedTo == null) {
                logger.info("could not unify " + this.id);
                TreeSet<String> tyes = new TreeSet<String>();
                TreeSet<InputPosition> locs = new TreeSet<InputPosition>();
                boolean alreadyError = false;
                for (PosType ty : resolved) {
                    alreadyError |= this.containsError(ty.type);
                    tyes.add(ty.type.signature());
                    if (ty.pos == null || ty.pos == LoadBuiltins.pos || ty.pos == Apply.unknown || ty.pos.equals(this.pos)) continue;
                    locs.add(ty.pos);
                }
                if (!alreadyError) {
                    errors.message(this.pos, locs, "cannot unify " + tyes);
                }
                this.resolvedTo = new ErrorType();
            }
        }
        for (ErrorConstraint e : this.errorConstraints) {
            e.apply(errors, this.resolvedTo);
        }
        for (FieldOf ff : this.fieldExprs) {
            ff.fieldExpr.bindContainerType(ff.fieldOf.redirectedTo().resolvedTo());
            ff.fieldExpr.bindContainedType(this.resolvedTo);
        }
        logger.debug("resolved to " + this.resolvedTo);
        return this.resolvedTo;
    }

    private boolean containsError(Type type) {
        if (type instanceof ErrorType) {
            return true;
        }
        if (type instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)type;
            for (Type t : pi.polys()) {
                if (!this.containsError(t)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void afterResolution(ErrorReporter errors) {
        for (CallOnResolution c : this.onResolved) {
            c.typeResolved(this.resolvedTo);
        }
    }

    private Type resolvePolyArg(HashSet<UnifiableType> workingOn, Type ty) {
        workingOn.add(this);
        if (ty instanceof UnifiableType) {
            return ((TypeConstraintSet)ty).resolvingTo(workingOn);
        }
        if (ty instanceof PolyInstance) {
            return this.resolvePolyArgs(workingOn, (PolyInstance)ty);
        }
        if (ty instanceof Apply) {
            return this.resolvePolyArgs(workingOn, (Apply)ty);
        }
        return ty;
    }

    private Type resolvePolyArgs(HashSet<UnifiableType> workingOn, PolyInstance pi) {
        ArrayList<Type> rps = new ArrayList<Type>();
        for (Type t : pi.polys()) {
            Type curr = this.resolvePolyArg(workingOn, t);
            if (curr == null) continue;
            rps.add(curr);
        }
        return new PolyInstance(pi.location(), pi.struct(), rps);
    }

    private Type resolvePolyArgs(HashSet<UnifiableType> workingOn, Apply ty) {
        ArrayList<Type> rps = new ArrayList<Type>();
        for (Type t : ty.tys) {
            Type curr = this.resolvePolyArg(workingOn, t);
            if (curr == null) {
                throw new CantHappenException("resolved type to null");
            }
            rps.add(curr);
        }
        return new Apply(rps);
    }

    @Override
    public void isFieldOf(MemberExpr expr, UnifiableType container, String field) {
        this.fieldExprs.add(new FieldOf(expr, container, field));
    }

    @Override
    public void isReturned(InputPosition pos) {
        this.comments.add(new Comment(pos, "returned", null));
        ++this.usedOrReturned;
    }

    @Override
    public void isUsed(InputPosition pos) {
        this.comments.add(new Comment(pos, "used", null));
        ++this.usedOrReturned;
    }

    public void hasPolyVar(InputPosition pos, UnifiableType pv) {
        this.comments.add(new Comment(pos, "has poly var " + pv.id(), null));
        this.polyvars.add(pv);
    }

    @Override
    public void incorporatedBy(InputPosition pos, Type incorporator) {
        if (incorporator instanceof ErrorType) {
            return;
        }
        if (incorporator == null) {
            throw new NotImplementedException("incorporator shoud not be null");
        }
        this.incorporatedBys.add(new PosType(pos, incorporator));
        this.comments.add(new Comment(pos, "incorporated by", incorporator));
    }

    @Override
    public String signature() {
        if (this.resolvedTo == null) {
            return this.id;
        }
        return this.resolvedTo.signature();
    }

    @Override
    public int argCount() {
        if (this.resolvedTo == null) {
            throw new NotImplementedException("Has not been resolved");
        }
        return this.resolvedTo.argCount();
    }

    @Override
    public Type get(int pos) {
        if (this.resolvedTo == null) {
            throw new NotImplementedException("Has not been resolved");
        }
        return this.resolvedTo.get(pos);
    }

    @Override
    public boolean incorporates(InputPosition pos, Type other) {
        this.comments.add(new Comment(pos, "incorporates " + other, other));
        this.isPassed(pos, other);
        return true;
    }

    @Override
    public StructTypeConstraints canBeStruct(InputPosition pos, FunctionName fn, StructDefn sd) {
        this.comments.add(new Comment(pos, "can be struct " + sd, sd));
        if (!this.ctors.containsKey(sd)) {
            StructFieldConstraints sfc = new StructFieldConstraints(this.repository, fn, this.state, this, pos, sd);
            this.ctors.put(sfc.polyInstance(), sfc);
        }
        return this.ctors.get(sd);
    }

    @Override
    public void sameAs(InputPosition pos, Type ofType) {
        this.comments.add(new Comment(pos, "same as", ofType));
        if (ofType == null) {
            throw new NotImplementedException("types cannot be null");
        }
        this.types.add(new PosType(pos, ofType));
        if (ofType instanceof TypeConstraintSet) {
            this.comments.addAll(((TypeConstraintSet)ofType).comments);
        }
    }

    @Override
    public void canBeType(InputPosition pos, Type ofType) {
        this.comments.add(new Comment(pos, "can be", ofType));
        if (ofType == null) {
            throw new NotImplementedException("types cannot be null");
        }
        this.types.add(new PosType(pos, ofType));
    }

    @Override
    public UnifiableType canBeAppliedTo(InputPosition pos, List<PosType> args) {
        StringBuilder motive = new StringBuilder("apply " + this.id + " to");
        for (PosType t : args) {
            motive.append(" ");
            Type tt = t.type;
            if (tt instanceof UnifiableType) {
                motive.append(((UnifiableType)tt).id());
                continue;
            }
            motive.append(tt.signature());
        }
        UnifiableType ret = this.state.createUT(pos, motive.toString());
        ArrayList<Type> targs = new ArrayList<Type>();
        for (PosType ty : args) {
            targs.add(ty.type);
            if (!(ty.type instanceof UnifiableType)) continue;
            ((UnifiableType)ty.type).isUsed(ty.pos);
        }
        logger.debug(this.id + ": can be applied to " + args + " returning " + ret);
        this.addApplication(pos, targs, ret);
        return ret;
    }

    void consolidatedApplication(InputPosition pos, Apply a) {
        ArrayList<Type> l = new ArrayList<Type>(a.tys);
        Type ret = (Type)l.remove(l.size() - 1);
        logger.debug(this.id + ": have consolidated application " + l + " returning " + ret);
        this.addApplication(pos, l, ret);
    }

    @Override
    public void recordApplication(InputPosition pos, List<Type> args) {
        logger.debug(this.id + ": recording application " + args);
        ArrayList<Type> a2 = new ArrayList<Type>(args);
        Type ret = a2.remove(args.size() - 1);
        this.addApplication(pos, a2, ret);
    }

    private void addApplication(InputPosition pos, List<Type> args, Type ret) {
        this.applications.add(new UnifiableApplication(pos, args, ret));
        this.comments.add(new Comment(pos, "application " + args + " ==> " + ret, ret));
    }

    @Override
    public void determinedType(PosType ofType) {
        if (ofType == null || ofType.type == null) {
            throw new NotImplementedException("types cannot be null");
        }
        if (ofType.type instanceof Apply) {
            Apply a = (Apply)ofType.type;
            List<Type> args = a.tys.subList(0, a.tys.size() - 1);
            Type ret = a.tys.get(a.tys.size() - 1);
            logger.debug(this.id + " has apply type: " + args + " returning " + ret);
            this.addApplication(ofType.pos, args, ret);
        } else {
            this.types.add(ofType);
        }
    }

    @Override
    public void isPassed(InputPosition loc, Type ai) {
        this.comments.add(new Comment(this.pos, "isPassed " + ai, ai));
        this.types.add(new PosType(loc, ai));
    }

    @Override
    public void requireListMessage(InputPosition pos, String err) {
        this.errorConstraints.add(new ErrorConstraint(x -> TypeHelpers.isListMessage(pos, x), pos, err));
    }

    @Override
    public void requirePrimitive(InputPosition pos, String err) {
        this.errorConstraints.add(new ErrorConstraint(x -> TypeHelpers.isPrimitive(x), pos, err));
    }

    @Override
    public void requirePrimitiveOfString(InputPosition pos, String notPrimMsg, String notStringMsg) {
        this.errorConstraints.add(new ErrorConstraint(x -> TypeHelpers.isPrimitiveString(x), pos, notPrimMsg).chain(new ErrorConstraint(x -> TypeHelpers.isPrimitiveString(x), pos, notStringMsg)));
    }

    @Override
    public void requireNonPrimitive(InputPosition pos, String err) {
        this.errorConstraints.add(new ErrorConstraint(x -> !TypeHelpers.isPrimitive(x), pos, err));
    }

    @Override
    public void callOnResolved(CallOnResolution handler) {
        this.onResolved.add(handler);
    }

    public String asTCS() {
        return "TCS:" + this.id + (String)(this.isRedirected() ? "=>" + this.redirectedTo().id() : "") + "{" + (this.pos == null ? "NULL" : this.pos.inFile()) + ":" + (String)(this.motive != null ? ":" + this.motive : "") + "}";
    }

    public String debugInfo() {
        StringBuilder ret = new StringBuilder();
        ret.append(this.asTCS());
        ret.append(" =>");
        if (this.resolvedTo != null) {
            ret.append(" ");
            ret.append("{");
            ret.append(this.resolvedTo);
            ret.append("}");
        }
        if (!this.tys.isEmpty()) {
            this.showTys(ret, this.tys);
        } else {
            this.showTys(ret, this.types);
            this.showTys(ret, this.incorporatedBys);
            this.showCtors(ret, this.ctors);
        }
        if (this.usedOrReturned > 0) {
            ret.append(" +" + this.usedOrReturned);
        }
        return ret.toString();
    }

    private void showTys(StringBuilder ret, Set<PosType> pts) {
        for (PosType pt : pts) {
            ret.append(" ");
            this.showType(ret, pt.type);
        }
    }

    private void showType(StringBuilder ret, Type t) {
        if (t instanceof UnifiableType) {
            ret.append(((UnifiableType)t).id());
        } else if (t instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)t;
            ret.append(pi.struct().signature());
            String sep = "[";
            for (Type i : pi.polys()) {
                ret.append(sep);
                this.showType(ret, i);
                sep = ",";
            }
            ret.append("]");
        } else {
            ret.append(t.signature());
        }
    }

    private void showCtors(StringBuilder ret, Map<NamedType, StructTypeConstraints> ct) {
        for (Map.Entry<NamedType, StructTypeConstraints> e : ct.entrySet()) {
            ret.append(" $");
            this.showType(ret, e.getKey());
        }
    }

    public String toString() {
        if (this.resolvedTo != null) {
            return this.id + ":" + this.signature();
        }
        if (((TypeConstraintSet)this.redirectedTo()).resolvedTo != null) {
            TypeConstraintSet rt = (TypeConstraintSet)this.redirectedTo();
            return this.id + "*" + rt.id + ":" + rt.resolvedTo;
        }
        return this.asTCS();
    }

    public class Comment
    implements Comparable<Comment> {
        private final InputPosition pos;
        private final String msg;
        private final Type type;

        public Comment(InputPosition pos, String msg, Type type) {
            this.pos = pos;
            this.msg = msg;
            this.type = type;
        }

        public String toString() {
            return this.pos + " - " + this.msg + (String)(this.type != null ? " " + this.type : "");
        }

        @Override
        public int compareTo(Comment o) {
            int ret;
            if (this.pos != null && (ret = this.pos.compareTo(o.pos)) != 0) {
                return ret;
            }
            ret = this.msg.compareTo(o.msg);
            if (ret != 0) {
                return ret;
            }
            if (this.type == null) {
                return 0;
            }
            ret = this.type.signature().compareTo(o.type.signature());
            return ret;
        }
    }

    public class UnifiableApplication {
        private final InputPosition pos;
        private final List<Type> args;
        private final Type ret;

        public UnifiableApplication(InputPosition pos, List<Type> args, Type ret) {
            this.pos = pos;
            this.args = args;
            this.ret = ret;
        }

        public PosType asApply() {
            if (this.args.isEmpty()) {
                return new PosType(this.pos, this.ret);
            }
            return new PosType(this.pos, new Apply(this.args, this.ret));
        }

        public String toString() {
            return this.args.toString() + "->" + this.ret;
        }
    }

    public class FieldOf {
        private final MemberExpr fieldExpr;
        private final UnifiableType fieldOf;
        private final String fieldName;

        public FieldOf(MemberExpr fieldExpr, UnifiableType fieldOf, String fieldName) {
            this.fieldExpr = fieldExpr;
            this.fieldOf = fieldOf;
            this.fieldName = fieldName;
        }
    }

    public class ErrorConstraint {
        private final Function<Type, Boolean> predicate;
        private final InputPosition location;
        private final String err;
        private ErrorConstraint chain;

        public ErrorConstraint(Function<Type, Boolean> predicate, InputPosition pos, String err) {
            this.predicate = predicate;
            this.location = pos;
            this.err = err;
        }

        public void apply(ErrorReporter errors, Type t) {
            if (!this.predicate.apply(t).booleanValue()) {
                errors.message(this.location, this.err);
            } else if (this.chain != null) {
                this.chain.apply(errors, t);
            }
        }

        public ErrorConstraint chain(ErrorConstraint errorConstraint) {
            this.chain = errorConstraint;
            return errorConstraint;
        }
    }
}

