/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.FLASError;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.EventHolder;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PolyHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TargetZone;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.ut.UnitTestAssert;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.parsedForm.ut.UnitTestClose;
import org.flasck.flas.parsedForm.ut.UnitTestEvent;
import org.flasck.flas.parsedForm.ut.UnitTestExpect;
import org.flasck.flas.parsedForm.ut.UnitTestExpectCancel;
import org.flasck.flas.parsedForm.ut.UnitTestIdentical;
import org.flasck.flas.parsedForm.ut.UnitTestInput;
import org.flasck.flas.parsedForm.ut.UnitTestInvoke;
import org.flasck.flas.parsedForm.ut.UnitTestMatch;
import org.flasck.flas.parsedForm.ut.UnitTestSend;
import org.flasck.flas.parsedForm.ut.UnitTestShove;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.FunctionGroup;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.resolver.TemplateNestingChain;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.CloseCardChecker;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ExpectCancelChecker;
import org.flasck.flas.tc3.ExpectChecker;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.GroupChecker;
import org.flasck.flas.tc3.ObjectDefnChecker;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.ShoveChecker;
import org.flasck.flas.tc3.SingleFunctionChecker;
import org.flasck.flas.tc3.TemplateOrError;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeHelpers;
import org.flasck.flas.tc3.UDDChecker;
import org.flasck.flas.tc3.UTAChecker;
import org.flasck.flas.tc3.UTEventChecker;
import org.flasck.flas.tc3.UTIChecker;
import org.flasck.flas.tc3.UTInputChecker;
import org.flasck.flas.tc3.UTSendChecker;
import org.flasck.flas.tc3.UnifiableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.splitter.CardData;
import org.ziniki.splitter.FieldType;
import org.ziniki.splitter.NoMetaKeyException;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class TypeChecker
extends LeafAdapter {
    public static final Logger logger = LoggerFactory.getLogger((String)"TypeChecker");
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private final ErrorMark mark;
    private String utName;

    public TypeChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        sv.push(this);
        this.mark = errors.mark();
    }

    @Override
    public void visitObjectDefn(ObjectDefn obj) {
        new ObjectDefnChecker(this.errors, this.repository, this.sv, obj.name().uniqueName(), obj.templates, false);
    }

    @Override
    public void visitCardDefn(CardDefinition cd) {
        new ObjectDefnChecker(this.errors, this.repository, this.sv, cd.name().uniqueName(), cd.templates, true);
    }

    @Override
    public void visitObjectMethod(ObjectMethod meth) {
        new SingleFunctionChecker(this.errors, this.sv, this.repository, meth);
    }

    @Override
    public void visitObjectCtor(ObjectCtor meth) {
        new SingleFunctionChecker(this.errors, this.sv, this.repository, meth);
    }

    @Override
    public void visitFunctionGroup(FunctionGroup grp) {
        new GroupChecker(this.errors, this.repository, this.sv, new FunctionGroupTCState(this.repository, grp), this.mark);
    }

    @Override
    public void visitUnitTest(UnitTestCase e) {
        this.utName = e.name.uniqueName();
    }

    @Override
    public void visitUnitDataDeclaration(UnitDataDeclaration udd) {
        new UDDChecker(this.errors, this.repository, this.sv, this.utName);
    }

    @Override
    public void visitUnitTestInvoke(UnitTestInvoke uti) {
        new UTIChecker(this.errors, this.repository, this.sv, this.utName);
    }

    @Override
    public void visitUnitTestAssert(UnitTestAssert a) {
        new UTAChecker(this.errors, this.repository, this.sv, this.utName);
    }

    @Override
    public void visitUnitTestIdentical(UnitTestIdentical a) {
        new UTAChecker(this.errors, this.repository, this.sv, this.utName);
    }

    @Override
    public void visitUnitTestShove(UnitTestShove s) {
        new ShoveChecker(this.errors, this.repository, this.sv, this.utName);
    }

    @Override
    public void visitUnitTestExpect(UnitTestExpect e) {
        new ExpectChecker(this.errors, this.repository, this.sv, this.utName, e);
    }

    @Override
    public void visitUnitTestClose(UnitTestClose utc) {
        new CloseCardChecker(this.errors, this.repository, this.sv, this.utName, utc);
    }

    @Override
    public void visitUnitTestExpectCancel(UnitTestExpectCancel e) {
        new ExpectCancelChecker(this.errors, this.repository, this.sv, this.utName, e);
    }

    @Override
    public void visitUnitTestSend(UnitTestSend s) {
        new UTSendChecker(this.errors, this.repository, this.sv, this.utName, s);
    }

    @Override
    public void visitUnitTestEvent(UnitTestEvent e) {
        new UTEventChecker(this.errors, this.repository, this.sv, this.utName, e);
    }

    @Override
    public void visitUnitTestInput(UnitTestInput e) {
        new UTInputChecker(this.errors, this.repository, this.sv, this.utName, e);
    }

    @Override
    public void leaveUnitTestMatch(UnitTestMatch m) {
        TypeChecker.resolveTargetZone(this.errors, this.repository, m.card.defn(), m.targetZone, "match", "match text in", true);
    }

    public static void resolveTargetZone(ErrorReporter errors, RepositoryReader repository, RepositoryEntry re, TargetZone tz, String type, String msg, boolean allowContainer) {
        if (tz.isWholeCard()) {
            tz.bindTypes(new ArrayList<FieldType>());
            return;
        }
        UnitDataDeclaration udd = (UnitDataDeclaration)re;
        EventHolder card = (EventHolder)udd.ofType.namedDefn();
        if (card.templates().isEmpty()) {
            errors.message(tz.location, "cannot " + msg + " card with no templates");
            return;
        }
        Template template = card.templates().get(0);
        CardData webInfo = template.webinfo();
        if (webInfo == null) {
            return;
        }
        try {
            ArrayList<FieldType> types = new ArrayList<FieldType>();
            FieldType curr = FieldType.CARD;
            TemplateOrError ct = new TemplateOrError(template, webInfo);
            for (int i = 0; i < tz.fields.size(); ++i) {
                Object part = tz.fields.get(i);
                if (part instanceof Integer) {
                    if (curr != FieldType.CONTAINER) {
                        errors.message(tz.location, "can only use indices to index containers");
                        return;
                    }
                    types.add(FieldType.ITEM);
                    continue;
                }
                if (part instanceof TargetZone.Qualifier) {
                    if (!ct.hasError()) {
                        throw new NotImplementedException("the user has provided an explicit resolution but it isn't needed - we should check here");
                    }
                    TargetZone.Qualifier q = (TargetZone.Qualifier)part;
                    String tn = q.qualifyingTemplate;
                    Type ty = ct.forType();
                    if (!(ty instanceof UnionTypeDefn)) {
                        throw new NotImplementedException("we are kind of assuming here that this is a Union, but if not ...");
                    }
                    UnionTypeDefn u = (UnionTypeDefn)ty;
                    Template chosen = null;
                    for (Template t : card.templates()) {
                        if (!t.name().baseName().equals(tn)) continue;
                        chosen = t;
                    }
                    if (chosen == null) {
                        errors.message(q.location(), "there is no template called '" + tn + "'");
                        return;
                    }
                    if (chosen.nestingChain() == null) {
                        errors.message(q.location(), "the template '" + tn + "' does not have a nesting chain, cannot be used as a qualifier");
                        return;
                    }
                    Type tnc = ((TemplateNestingChain.Link)chosen.nestingChain().iterator().next()).type();
                    if (!(tnc instanceof StructDefn) || !u.hasCase((StructDefn)tnc)) {
                        errors.message(q.location, "template '" + tn + "' expects type " + tnc + " which is not part of the union " + u);
                        return;
                    }
                    ct = new TemplateOrError(chosen, chosen.webinfo());
                    types.add(FieldType.CONTAINER);
                    continue;
                }
                if (part instanceof String) {
                    curr = ct.webInfo().get((String)part);
                    if (curr == FieldType.CONTAINER && (ct = TypeChecker.findCBO(errors, repository, card.templates(), ct.template(), tz, (String)part)) == null) {
                        return;
                    }
                    types.add(curr);
                    continue;
                }
                throw new HaventConsideredThisException("part is a " + part.getClass());
            }
            if (!(curr == FieldType.CONTENT || curr == FieldType.IMAGE || curr == FieldType.LINK || curr == FieldType.STYLE || allowContainer && curr == FieldType.CONTAINER)) {
                errors.message(tz.location, "element " + curr + " '" + tz + "' is not a valid " + type + " target");
                return;
            }
            tz.bindTypes(types);
        }
        catch (NoMetaKeyException ex) {
            errors.message(tz.location, "there is no target '" + tz + "' on the card");
        }
    }

    private static TemplateOrError findCBO(ErrorReporter errors, RepositoryReader repository, List<Template> allTemplates, Template ct, TargetZone tz, String slot) {
        Template ret;
        HashSet<Template> sendsTo = new HashSet<Template>();
        ArrayList<Type> types = new ArrayList<Type>();
        for (TemplateBinding b : ct.bindings()) {
            if (!b.assignsTo.text.equals(slot)) continue;
            for (TemplateBindingOption cb : b.conditionalBindings) {
                types.add(TypeChecker.notList(ExpressionChecker.check(errors, repository, new FunctionGroupTCState(repository, new DependencyGroup(new LogicHolder[0])), ct.name().uniqueName(), false, cb.expr)));
                if (cb.sendsTo == null) continue;
                sendsTo.add(cb.sendsTo.template());
            }
            if (b.defaultBinding == null) continue;
            types.add(TypeChecker.notList(ExpressionChecker.check(errors, repository, new FunctionGroupTCState(repository, new DependencyGroup(new LogicHolder[0])), ct.name().uniqueName(), false, b.defaultBinding.expr)));
            if (b.defaultBinding.sendsTo == null) continue;
            sendsTo.add(b.defaultBinding.sendsTo.template());
        }
        if (sendsTo.isEmpty()) {
            if (types.size() == 1) {
                ret = TypeChecker.selectTemplateFromCollectionBasedOnOperatingType(errors, tz.location, allTemplates, (Type)types.get(0));
                if (ret == null) {
                    return new TemplateOrError(new FLASError(tz.location, "could not find a template for " + ((Type)types.get(0)).signature()), (Type)types.get(0));
                }
                return new TemplateOrError(ret, ret.webinfo());
            }
            errors.message(tz.location, "template " + ct.name().uniqueName() + " does not send to for " + slot);
            return null;
        }
        if (sendsTo.size() > 1) {
            errors.message(tz.location, slot + " is ambiguous for template " + ct.name().uniqueName());
            return null;
        }
        ret = (Template)CollectionUtils.nth(sendsTo, (int)0);
        return new TemplateOrError(ret, ret.webinfo());
    }

    private static Type notList(Type t) {
        if (TypeHelpers.isListLike(t)) {
            return TypeHelpers.extractListPoly(t);
        }
        return t;
    }

    public static Template selectTemplateFromCollectionBasedOnOperatingType(ErrorReporter errors, InputPosition pos, Iterable<Template> allTemplates, Type forType) {
        Template ret = null;
        for (Template t : allTemplates) {
            if (t.nestingChain() == null || !((TemplateNestingChain.Link)t.nestingChain().iterator().next()).type().incorporates(pos, forType)) continue;
            if (ret != null) {
                errors.message(pos, "ambiguous templates for " + forType.signature());
            }
            ret = t;
        }
        return ret;
    }

    public static PosType instantiateFreshPolys(Expr tmp, CurrentTCState state, Map<String, UnifiableType> uts, PosType post, boolean nested) {
        InputPosition pos = post.pos;
        Type type = post.type;
        logger.info("instantiating fresh polys in " + type + " with a current map of " + uts);
        if (type instanceof PolyType) {
            PolyType pt = (PolyType)type;
            if (state.hasPoly(pt)) {
                return TypeChecker.logit(new PosType(pos, state.getPoly(pt)));
            }
            if (uts.containsKey(pt.shortName())) {
                return TypeChecker.logit(new PosType(pos, uts.get(pt.shortName())));
            }
            UnifiableType ret = state.createUT(null, "instantiating " + tmp + "." + pt.shortName());
            uts.put(pt.shortName(), ret);
            return TypeChecker.logit(new PosType(pos, ret));
        }
        if (type instanceof Apply) {
            Apply a = (Apply)type;
            ArrayList<Type> types = new ArrayList<Type>();
            for (Type type2 : a.tys) {
                types.add(TypeChecker.instantiateFreshPolys((Expr)tmp, (CurrentTCState)state, uts, (PosType)new PosType((InputPosition)pos, (Type)type2), (boolean)true).type);
            }
            return TypeChecker.logit(new PosType(pos, new Apply(types).withHandler(a.withHandler())));
        }
        if (type instanceof PolyHolder && ((PolyHolder)type).hasPolys()) {
            PolyHolder sd = (PolyHolder)type;
            ArrayList<Type> polys = new ArrayList<Type>();
            for (Type type3 : sd.polys()) {
                polys.add(TypeChecker.instantiateFreshPolys((Expr)tmp, (CurrentTCState)state, uts, (PosType)new PosType((InputPosition)pos, (Type)type3), (boolean)true).type);
            }
            PolyInstance pi = new PolyInstance(pos, sd, polys);
            if (!nested && type instanceof FieldsDefn) {
                ArrayList<Type> arrayList = new ArrayList<Type>();
                for (StructField sf : ((FieldsDefn)type).fields) {
                    arrayList.add(TypeChecker.instantiateFreshPolys((Expr)tmp, (CurrentTCState)state, uts, (PosType)new PosType((InputPosition)pos, (Type)sf.type.namedDefn()), (boolean)true).type);
                }
                if (arrayList.isEmpty()) {
                    return TypeChecker.logit(new PosType(pos, pi));
                }
                return TypeChecker.logit(new PosType(pos, new Apply(arrayList, (Type)pi)));
            }
            return new PosType(pos, pi);
        }
        if (type instanceof PolyInstance) {
            PolyInstance inst = (PolyInstance)type;
            ArrayList<Type> polys = new ArrayList<Type>();
            for (Type type4 : inst.polys()) {
                polys.add(TypeChecker.instantiateFreshPolys((Expr)tmp, (CurrentTCState)state, uts, (PosType)new PosType((InputPosition)pos, (Type)type4), (boolean)true).type);
            }
            PolyInstance pi = new PolyInstance(pos, inst.struct(), polys);
            if (type instanceof FieldsDefn) {
                ArrayList<Type> arrayList = new ArrayList<Type>();
                for (StructField sf : ((FieldsDefn)type).fields) {
                    arrayList.add(TypeChecker.instantiateFreshPolys((Expr)tmp, (CurrentTCState)state, uts, (PosType)new PosType((InputPosition)pos, (Type)sf.type.namedDefn()), (boolean)true).type);
                }
                if (arrayList.isEmpty()) {
                    return TypeChecker.logit(new PosType(pos, pi));
                }
                return TypeChecker.logit(new PosType(pos, new Apply(arrayList, (Type)pi)));
            }
            return TypeChecker.logit(new PosType(pos, pi));
        }
        return TypeChecker.logit(post);
    }

    private static PosType logit(PosType ret) {
        logger.info("instantiated type is " + ret);
        return ret;
    }
}

