/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.commonBase.names.TemplateName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateReference;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.resolver.TemplateNestingChain;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeChecker;
import org.flasck.flas.tc3.TypeHelpers;
import org.flasck.flas.tc3.UnifiableType;
import org.ziniki.splitter.CardData;
import org.ziniki.splitter.CardType;
import org.ziniki.splitter.FieldType;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class TemplateChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private final Template currentTemplate;
    private Mode mode;
    private InputPosition eloc;
    private ExpressionChecker.ExprResult exprType;
    private List<String> referencedTemplates;
    private List<Template> allTemplates;
    private final String fnCxt;
    private FunctionGroupTCState state;

    public TemplateChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, Template t, List<Template> allTemplates, List<String> referencedTemplates) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.currentTemplate = t;
        this.allTemplates = allTemplates;
        this.referencedTemplates = referencedTemplates;
        this.fnCxt = t.name().uniqueName();
        this.state = new FunctionGroupTCState(repository, new DependencyGroup(new LogicHolder[0]));
        sv.push(this);
    }

    @Override
    public void visitTemplateBindingCondition(Expr cond) {
        this.mode = Mode.COND;
        this.eloc = cond.location();
    }

    @Override
    public void visitTemplateBindingExpr(Expr expr) {
        this.mode = Mode.BINDEXPR;
        this.eloc = expr.location();
    }

    @Override
    public void visitTemplateStyleCond(Expr cond) {
        this.mode = Mode.COND;
        this.eloc = cond.location();
    }

    @Override
    public void visitTemplateStyleExpr(Expr style) {
        this.mode = Mode.STYLEEXPR;
        this.eloc = style.location();
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        if (this.mode == null) {
            throw new NotImplementedException("was not in a mode capable of handling expr");
        }
        this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, this.fnCxt, true));
    }

    @Override
    public void result(Object r) {
        ExpressionChecker.ExprResult ty = (ExpressionChecker.ExprResult)r;
        if (this.mode == Mode.COND) {
            if (!(ty.type.equals(LoadBuiltins.bool) || ty.type.equals(LoadBuiltins.trueT) || ty.type.equals(LoadBuiltins.falseT))) {
                this.errors.message(this.eloc, "conditions must be Boolean");
            }
        } else if (this.mode == Mode.STYLEEXPR) {
            if (!ty.type.equals(LoadBuiltins.string) && !TypeHelpers.isListString(ty.type)) {
                this.errors.message(this.eloc, "styles must be strings or lists of strings");
            }
        } else {
            this.exprType = ty;
        }
        this.mode = null;
    }

    @Override
    public void leaveTemplateBindingOption(TemplateBindingOption option) {
        FieldType dest = option.assignsTo.type();
        InputPosition pos = this.exprType.location();
        Type etype = this.exprType.type;
        if (etype instanceof ErrorType) {
            return;
        }
        switch (dest) {
            case CONTENT: {
                if (etype instanceof ObjectDefn && etype.signature().equals("Html")) {
                    if (option.sendsTo == null) break;
                    this.errors.message(pos, "cannot use templates to render images");
                }
                if (option.sendsTo != null && this.referencedTemplates != null) {
                    this.referencedTemplates.add(option.sendsTo.name.baseName());
                }
                if (etype instanceof UnionTypeDefn && ((UnionTypeDefn)etype).name().uniqueName().equals("Boolean")) {
                    this.errors.message(pos, "must format value as string for field " + option.assignsTo.text);
                    break;
                }
                if (etype instanceof ObjectDefn) {
                    if (option.sendsTo == null || option.sendsTo.template() == null) {
                        this.errors.message(pos, "must use templates to render object " + etype.signature());
                        break;
                    }
                    TemplateName tdb = option.sendsTo.template().name();
                    SolidName obj = ((ObjectDefn)etype).name();
                    if (((Object)obj).equals(tdb.container())) break;
                    this.errors.message(pos, "cannot use template '" + tdb.uniqueName() + "' to render object of type '" + obj.uniqueName());
                    break;
                }
                if (option.sendsTo == null) {
                    String primMsg = "cannot render compound object in field " + option.assignsTo.text;
                    String strMsg = "must format value as string for field " + option.assignsTo.text;
                    if (etype instanceof UnifiableType) {
                        ((UnifiableType)etype).requirePrimitiveOfString(pos, primMsg, strMsg);
                        break;
                    }
                    if (!TypeHelpers.isPrimitive(etype)) {
                        this.errors.message(pos, primMsg);
                        break;
                    }
                    if (TypeHelpers.isPrimitiveString(etype)) break;
                    this.errors.message(pos, strMsg);
                    break;
                }
                String msg = "cannot specify sendsTo operator when value is a primitive";
                if (etype instanceof UnifiableType) {
                    ((UnifiableType)etype).requireNonPrimitive(pos, msg);
                    break;
                }
                if (!TypeHelpers.isPrimitive(etype)) break;
                this.errors.message(option.sendsTo.location(), msg);
                break;
            }
            case IMAGE: {
                if (etype instanceof ObjectDefn && etype.signature().equals("Image")) {
                    if (option.sendsTo == null) break;
                    this.errors.message(pos, "cannot use templates to render images");
                    break;
                }
                this.errors.message(pos, "can only assign images to image content");
                break;
            }
            case LINK: {
                if (etype instanceof StructDefn && etype.signature().equals("Link")) {
                    if (option.sendsTo == null) break;
                    this.errors.message(pos, "cannot use templates to render links");
                    break;
                }
                this.errors.message(pos, "can only assign links to link content");
                break;
            }
            case CONTAINER: {
                if (option.sendsTo != null) {
                    CardData card = option.sendsTo.template().webinfo();
                    if (card != null && card.type() != CardType.ITEM) {
                        this.errors.message(option.sendsTo.location(), "cannot send to " + option.sendsTo.name.baseName() + " which is not an item template");
                        break;
                    }
                    if (this.referencedTemplates != null) {
                        this.referencedTemplates.add(option.sendsTo.name.baseName());
                    }
                }
                if (etype instanceof UnifiableType) {
                    ((UnifiableType)etype).callOnResolved(res -> this.processContainerType(pos, option, res));
                    return;
                }
                if (etype instanceof Apply) {
                    throw new NotImplementedException("you should have thrown an error before getting here: " + etype.signature());
                }
                this.processContainerType(pos, option, etype);
                break;
            }
            case PUNNET: {
                if (LoadBuiltins.crobag.equals(etype) || LoadBuiltins.card.equals(etype) || TypeHelpers.isListCard(etype)) break;
                this.errors.message(pos, "cannot render " + etype.signature() + " in punnet");
                break;
            }
            default: {
                this.errors.message(option.assignsTo.location(), "cannot handle dest type " + dest);
            }
        }
    }

    private void processContainerType(InputPosition pos, TemplateBindingOption option, Type etype) {
        if (TypeHelpers.isPrimitive(etype)) {
            String msg = "cannot render primitive object in container " + option.assignsTo.text;
            this.errors.message(pos, msg);
        } else if (TypeHelpers.isListLike(etype)) {
            this.handleListCases(pos, option, etype);
        } else if (etype instanceof ObjectDefn) {
            this.handleObjectCases(pos, option, (ObjectDefn)etype);
        } else {
            if (option.sendsTo != null) {
                this.errors.message(option.sendsTo.location(), "cannot specify sendsTo operator for a single item when target is a container");
                return;
            }
            if (etype instanceof StructDefn) {
                this.handleStructCases(pos, option, (StructDefn)etype);
            } else if (etype instanceof UnionTypeDefn) {
                this.handleUnionCases(pos, option, (UnionTypeDefn)etype);
            } else {
                this.errors.message(pos, "cannot identify a suitable template to format value into container " + option.assignsTo.text);
            }
        }
    }

    private void handleListCases(InputPosition pos, TemplateBindingOption option, Type etype) {
        etype = TypeHelpers.extractListPoly(etype);
        if (option.sendsTo != null) {
            this.handleSendsToCase(pos, option, etype, option.sendsTo);
            return;
        }
        if (etype instanceof PolyInstance) {
            etype = ((PolyInstance)etype).struct();
        }
        HashMap<NamedType, Template> mapping = new HashMap<NamedType, Template>();
        if (etype instanceof StructDefn) {
            Template which = TypeChecker.selectTemplateFromCollectionBasedOnOperatingType(this.errors, pos, this.allTemplates, etype);
            if (which == null) {
                this.errors.message(pos, "there is no compatible template for " + etype.signature());
            } else {
                this.referencedTemplates.add(which.name().baseName());
                mapping.put((StructDefn)etype, which);
            }
        } else if (etype instanceof UnionTypeDefn) {
            this.distributeUnion(pos, etype, mapping);
        } else if (etype instanceof ObjectDefn) {
            this.errors.message(pos, "cannot assign elements of " + etype.signature() + " to a container");
        } else if (etype instanceof UnifiableType) {
            this.errors.message(pos, "the compiler is not clever enough to do the analysis required to figure out which template to send elements to; please specify a template or make your types clearer");
        } else {
            throw new HaventConsideredThisException("must be struct or union, not " + etype);
        }
        option.attachMapping(mapping);
    }

    private void handleObjectCases(InputPosition pos, TemplateBindingOption option, ObjectDefn etype) {
        if (option.sendsTo == null || option.sendsTo.template() == null) {
            this.errors.message(pos, "must use templates to render object " + etype.signature());
            return;
        }
        TemplateName tdb = option.sendsTo.template().name();
        SolidName obj = etype.name();
        if (!((Object)obj).equals(tdb.container())) {
            this.errors.message(pos, "cannot use template '" + tdb.uniqueName() + "' to render object of type '" + obj.uniqueName());
            return;
        }
    }

    private void handleStructCases(InputPosition pos, TemplateBindingOption option, StructDefn sd) {
        Template wh2 = TypeChecker.selectTemplateFromCollectionBasedOnOperatingType(this.errors, pos, this.allTemplates, sd);
        if (wh2 != null) {
            this.referencedTemplates.add(wh2.name().baseName());
            HashMap<NamedType, Template> mapping = new HashMap<NamedType, Template>();
            mapping.put(sd, wh2);
            option.attachMapping(mapping);
        }
    }

    private void handleUnionCases(InputPosition pos, TemplateBindingOption option, UnionTypeDefn etype) {
        if (option.sendsTo == null) {
            HashMap<NamedType, Template> mapping = new HashMap<NamedType, Template>();
            this.distributeUnion(pos, etype, mapping);
            option.attachMapping(mapping);
        } else {
            this.handleSendsToCase(pos, option, etype, option.sendsTo);
        }
    }

    private void handleSendsToCase(InputPosition pos, TemplateBindingOption option, Type etype, TemplateReference sendsTo) {
        Template t = option.sendsTo.template();
        NestingChain chain = t.nestingChain();
        Iterator it = chain.iterator();
        pos = option.sendsTo.location();
        TemplateNestingChain.Link first = (TemplateNestingChain.Link)it.next();
        Type lp = null;
        if (TypeHelpers.isList(first.type())) {
            lp = TypeHelpers.extractListPoly(first.type());
        }
        if (!(first.type().incorporates(pos, etype) || lp != null && lp.incorporates(pos, etype))) {
            this.errors.message(pos, "template '" + t.name().uniqueName() + "' requires " + first.type().signature() + " not " + etype.signature());
            return;
        }
        ArrayList<Integer> posns = new ArrayList<Integer>();
        block0: while (it.hasNext()) {
            String cv;
            TemplateNestingChain.Link contextVar = (TemplateNestingChain.Link)it.next();
            if (this.currentTemplate.nestingChain() != null) {
                int mp = 0;
                for (TemplateNestingChain.Link mine : this.currentTemplate.nestingChain()) {
                    if (mine.type().incorporates(pos, contextVar.type())) {
                        posns.add(mp);
                        continue block0;
                    }
                    ++mp;
                }
            }
            if ((cv = contextVar.name().var) != null) {
                this.errors.message(pos, "cannot provide required context var " + cv + " required by " + option.sendsTo.name.uniqueName());
                continue;
            }
            this.errors.message(pos, "cannot provide a template context var of type " + contextVar.type().signature() + " required by " + option.sendsTo.name.uniqueName());
        }
        option.sendsTo.bindPosns(posns);
    }

    private void distributeUnion(InputPosition pos, Type etype, Map<NamedType, Template> mapping) {
        Template which = TypeChecker.selectTemplateFromCollectionBasedOnOperatingType(this.errors, pos, this.allTemplates, etype);
        if (which != null) {
            this.referencedTemplates.add(which.name().baseName());
            mapping.put((NamedType)etype, which);
        } else {
            ArrayList<String> missing = new ArrayList<String>();
            for (TypeReference ty : ((UnionTypeDefn)etype).cases) {
                StructDefn sd;
                Template wh2;
                NamedType td = ty.namedDefn();
                if (td instanceof PolyInstance) {
                    td = ((PolyInstance)td).struct();
                }
                if ((wh2 = TypeChecker.selectTemplateFromCollectionBasedOnOperatingType(this.errors, pos, this.allTemplates, sd = (StructDefn)td)) == null) {
                    missing.add(sd.signature());
                    continue;
                }
                this.referencedTemplates.add(wh2.name().baseName());
                mapping.put(sd, wh2);
            }
            if (!missing.isEmpty()) {
                this.errors.message(pos, "cannot distribute across " + etype.signature() + " because not all members have defined cases; missing cases for: " + String.join((CharSequence)", ", missing));
            }
        }
    }

    @Override
    public void leaveTemplate(Template t) {
        this.state.groupDone(this.errors, new HashMap<TypeBinder, PosType>(), new HashMap<TypeBinder, PosType>());
        this.sv.result(null);
    }

    public static enum Mode {
        COND,
        BINDEXPR,
        STYLEEXPR;

    }
}

