/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.StructTypeConstraints;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeChecker;
import org.flasck.flas.tc3.TypeConstraintSet;
import org.flasck.flas.tc3.UnifiableType;

public class StructFieldConstraints
implements StructTypeConstraints {
    private final FunctionName fn;
    private final StructDefn sd;
    private final Map<String, UnifiableType> polys = new TreeMap<String, UnifiableType>();
    private final Map<StructField, UnifiableType> fields = new TreeMap<StructField, UnifiableType>(StructField.nameComparator);
    private final PolyInstance pi;

    public StructFieldConstraints(RepositoryReader repository, FunctionName fn, CurrentTCState state, TypeConstraintSet parent, InputPosition pos, StructDefn sd) {
        this.fn = fn;
        this.sd = sd;
        if (sd.hasPolys()) {
            ArrayList<Type> pvs = new ArrayList<Type>();
            for (PolyType pt : sd.polys()) {
                UnifiableType pv = state.createUT(pos, fn.uniqueName() + " " + sd.name().uniqueName() + "." + pt.shortName());
                parent.hasPolyVar(pos, pv);
                pvs.add(pv);
                this.polys.put(pt.shortName(), pv);
            }
            this.pi = new PolyInstance(pos, sd, pvs);
        } else {
            this.pi = null;
        }
    }

    @Override
    public UnifiableType field(CurrentTCState state, InputPosition pos, StructField fld) {
        if (!this.sd.fields.contains(fld)) {
            throw new RuntimeException("Field is not part of struct: " + fld);
        }
        if (!this.fields.containsKey(fld)) {
            UnifiableType ut = state.createUT(pos, this.fn.uniqueName() + " " + this.sd.name().uniqueName() + "." + fld.name);
            this.fields.put(fld, ut);
            ut.sameAs(pos, TypeChecker.instantiateFreshPolys(null, (CurrentTCState)state, new TreeMap<String, UnifiableType>(this.polys), (PosType)new PosType((InputPosition)pos, (Type)fld.type()), (boolean)false).type);
        }
        return this.fields.get(fld);
    }

    @Override
    public Set<StructField> fields() {
        return this.fields.keySet();
    }

    @Override
    public UnifiableType get(StructField f) {
        return this.fields.get(f);
    }

    public NamedType polyInstance() {
        if (this.pi != null) {
            return this.pi;
        }
        return this.sd;
    }
}

