/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.hsi.ArgSlot;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.hsi.TreeOrderVisitor;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.FunctionChecker;
import org.flasck.flas.tc3.StructTypeConstraints;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.NotImplementedException;

public class SlotChecker
extends LeafAdapter
implements TreeOrderVisitor {
    private final NestedVisitor sv;
    private final FunctionName fnName;
    private final CurrentTCState state;
    private final UnifiableType ty;
    private StructTypeConstraints currentStruct;

    public SlotChecker(NestedVisitor sv, FunctionName fnName, CurrentTCState state, UnifiableType ty) {
        this.fnName = fnName;
        this.ty = ty;
        this.sv = sv;
        this.state = state;
    }

    @Override
    public void argSlot(ArgSlot s) {
        throw new NotImplementedException("This shouldn't happen here");
    }

    @Override
    public void matchConstructor(StructDefn ctor) {
        this.currentStruct = this.ty.canBeStruct(null, this.fnName, ctor);
    }

    @Override
    public void matchField(StructField fld) {
        UnifiableType ft = this.currentStruct.field(this.state, null, fld);
        this.sv.push(new SlotChecker(this.sv, this.fnName, this.state, ft));
    }

    @Override
    public void matchType(Type ofType, VarName var, FunctionIntro intro) {
        FunctionName name = intro != null ? intro.name() : this.fnName;
        this.ty.canBeType(var == null ? null : var.loc, ofType);
        if (var != null) {
            this.state.bindVarToUT(name.uniqueName(), var.uniqueName(), this.ty);
        }
        this.state.recordPolys(ofType);
    }

    @Override
    public void varInIntro(VarName vn, VarPattern vp, FunctionIntro intro) {
        FunctionName name = intro != null ? intro.name() : this.fnName;
        this.state.bindVarToUT(name.uniqueName(), vn.uniqueName(), this.ty);
        if (vp != null) {
            this.state.bindVarPatternToUT(vp, this.ty);
        }
    }

    @Override
    public void endField(StructField fld) {
        this.sv.result(null);
    }

    @Override
    public void endConstructor(StructDefn ctor) {
    }

    @Override
    public void endArg(Slot s) {
        this.sv.result(new FunctionChecker.ArgResult(this.ty));
    }

    @Override
    public void patternsDone(LogicHolder fn) {
        throw new NotImplementedException();
    }
}

