/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.ut.UnitTestShove;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.repository.StackVisitor;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.NotImplementedException;

public class ShoveChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private final String fnCxt;
    private Type curr;
    private List<Type> results = new ArrayList<Type>();

    public ShoveChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, String fnCxt) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.fnCxt = fnCxt;
        sv.push(this);
    }

    @Override
    public void visitShoveSlot(UnresolvedVar v) {
        if (this.curr == null) {
            StackVisitor nv = new StackVisitor(){

                @Override
                public void result(Object r) {
                    ShoveChecker.this.curr = ((ExpressionChecker.ExprResult)r).type;
                }
            };
            ExpressionChecker ec = new ExpressionChecker(this.errors, this.repository, new FunctionGroupTCState(this.repository, new DependencyGroup(new LogicHolder[0])), nv, this.fnCxt, false);
            ec.visitUnresolvedVar(v, 0);
        } else if (!(this.curr instanceof ErrorType)) {
            if (this.curr instanceof PolyInstance) {
                this.curr = ((PolyInstance)this.curr).struct();
            }
            if (this.curr instanceof StateHolder) {
                StateDefinition state = ((StateHolder)((Object)this.curr)).state();
                this.curr = state.findField(v.var).type();
            } else if (this.curr instanceof StructDefn) {
                StructDefn sd = (StructDefn)this.curr;
                this.curr = sd.findField(v.var).type();
            } else {
                throw new NotImplementedException("cannot shove member " + v.var + " into " + this.curr);
            }
        }
    }

    @Override
    public void visitShoveExpr(Expr e) {
        this.sv.push(new ExpressionChecker(this.errors, this.repository, new FunctionGroupTCState(this.repository, new DependencyGroup(new LogicHolder[0])), this.sv, this.fnCxt, false));
    }

    @Override
    public void result(Object r) {
        Type t = ((ExpressionChecker.ExprResult)r).type;
        this.results.add(t);
    }

    @Override
    public void leaveUnitTestShove(UnitTestShove s) {
        if (this.results.size() != 1) {
            throw new NotImplementedException();
        }
        Type expr = this.results.get(0);
        if (expr instanceof ErrorType) {
            this.sv.result(null);
            return;
        }
        if (this.curr != expr) {
            if (expr instanceof UnifiableType) {
                ((UnifiableType)expr).incorporatedBy(s.value.location(), this.curr);
            } else if (!this.curr.incorporates(s.value.location(), expr) && expr != LoadBuiltins.error) {
                this.errors.message(s.value.location(), "value of type " + expr.signature() + " cannot be shoved into a slot of type " + this.curr.signature());
            }
        }
        this.sv.result(null);
    }
}

