/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.parsedForm.AccessorHolder;
import org.flasck.flas.parsedForm.FieldAccessor;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Tuple;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class PolyInstance
implements NamedType,
RepositoryEntry,
AccessorHolder {
    private final InputPosition loc;
    private final NamedType ty;
    private final List<Type> polys;

    public PolyInstance(InputPosition loc, NamedType ty, List<Type> polys) {
        if (ty == null) {
            throw new CantHappenException("PolyInstance of null type");
        }
        if (ty instanceof PolyInstance) {
            throw new CantHappenException("Don't wrap a poly in a poly");
        }
        this.loc = loc;
        this.ty = ty;
        this.polys = polys;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolyInstance)) {
            return false;
        }
        PolyInstance o = (PolyInstance)obj;
        if (o.struct() != this.struct()) {
            return false;
        }
        Iterator<Type> mine = this.polys.iterator();
        Iterator<Type> other = o.polys.iterator();
        while (mine.hasNext()) {
            if (mine.next().equals(other.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.ty.hashCode();
    }

    public NamedType struct() {
        return this.ty;
    }

    public List<Type> polys() {
        return this.polys;
    }

    @Override
    public InputPosition location() {
        return this.loc;
    }

    @Override
    public String signature() {
        StringBuilder ret = new StringBuilder();
        if (this.ty instanceof Tuple) {
            ret.append("(");
        } else {
            ret.append(this.ty.name().uniqueName());
            ret.append("[");
        }
        String sep = "";
        for (Type p : this.polys) {
            ret.append(sep);
            ret.append(p.signature());
            sep = ",";
        }
        if (this.ty instanceof Tuple) {
            ret.append(")");
        } else {
            ret.append("]");
        }
        return ret.toString();
    }

    @Override
    public int argCount() {
        return 0;
    }

    @Override
    public Type get(int pos) {
        if (pos == 0) {
            return this;
        }
        throw new NotImplementedException();
    }

    @Override
    public boolean incorporates(InputPosition pos, Type other) {
        if (other instanceof PolyInstance) {
            PolyInstance o = (PolyInstance)other;
            if (!this.ty.incorporates(pos, o.ty)) {
                return false;
            }
            for (int i = 0; i < this.polys.size(); ++i) {
                if (this.polys.get(i).incorporates(pos, o.polys.get(i))) continue;
                return false;
            }
            return true;
        }
        if (other instanceof UnifiableType) {
            ((UnifiableType)other).incorporatedBy(pos, this);
            return true;
        }
        if (this.ty == other) {
            return true;
        }
        if (this.ty instanceof UnionTypeDefn && other instanceof StructDefn && !((StructDefn)other).hasPolys()) {
            return this.ty.incorporates(pos, other);
        }
        return false;
    }

    @Override
    public NameOfThing name() {
        return this.ty.name();
    }

    @Override
    public FieldAccessor getAccessor(String called) {
        return ((AccessorHolder)((Object)this.ty)).getAccessor(called);
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        throw new NotImplementedException();
    }

    public String toString() {
        return this.ty.name().uniqueName() + this.polys;
    }
}

