/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.TemplateChecker;

public class ObjectDefnChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private final String fnCxt;
    private final List<Template> allTemplates;
    private final boolean checkReferencing;
    private ExpressionChecker.ExprResult result;
    private final List<String> currentTemplates = new ArrayList<String>();
    private final List<String> referencedTemplates = new ArrayList<String>();

    public ObjectDefnChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, String fnCxt, List<Template> templates, boolean checkReferencing) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.fnCxt = fnCxt;
        this.allTemplates = templates;
        this.checkReferencing = checkReferencing;
        sv.push(this);
    }

    @Override
    public void visitStructField(StructField sf) {
        this.result = null;
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        this.sv.push(new ExpressionChecker(this.errors, this.repository, new FunctionGroupTCState(this.repository, new DependencyGroup(new LogicHolder[0])), this.sv, this.fnCxt, false));
    }

    @Override
    public void leaveStructField(StructField sf) {
        if (this.result == null) {
            return;
        }
        if (!sf.type().incorporates(this.result.pos, this.result.type)) {
            this.errors.message(this.result.pos, "cannot initialize " + sf.name + " from " + this.result.type.signature());
        }
    }

    @Override
    public void visitTemplate(Template t, boolean isFirst) {
        if (!isFirst && this.checkReferencing && !this.referencedTemplates.contains(t.name().baseName())) {
            this.errors.message(t.location(), "template " + t.name().baseName() + " has not been referenced yet");
        }
        this.currentTemplates.add(t.name().baseName());
        new TemplateChecker(this.errors, this.repository, this.sv, t, this.allTemplates, this.referencedTemplates);
    }

    @Override
    public void leaveObjectDefn(ObjectDefn obj) {
        this.sv.result(null);
    }

    @Override
    public void leaveCardDefn(CardDefinition obj) {
        this.sv.result(null);
    }

    @Override
    public void result(Object r) {
        this.result = (ExpressionChecker.ExprResult)r;
    }
}

