/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ActionMessage;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.SendMessage;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeHelpers;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class MessageChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final NestedVisitor sv;
    private final String fnCxt;
    private final ObjectActionHandler inMeth;
    private final AssignMessage assign;
    private boolean expectHandler;
    private ExpressionChecker.ExprResult rhsType;
    private ExpressionChecker.ExprResult handlerType;

    public MessageChecker(ErrorReporter errors, RepositoryReader repository, CurrentTCState state, NestedVisitor sv, String fnCxt, ObjectActionHandler inMeth, AssignMessage assign) {
        this.errors = errors;
        this.repository = repository;
        this.state = state;
        this.sv = sv;
        this.fnCxt = fnCxt;
        this.inMeth = inMeth;
        this.assign = assign;
        sv.push(this);
        sv.push(new ExpressionChecker(errors, repository, state, sv, fnCxt, false));
    }

    @Override
    public void result(Object r) {
        if (this.expectHandler) {
            if (this.handlerType != null) {
                throw new CantHappenException("not expecting multiple handlers");
            }
            this.handlerType = (ExpressionChecker.ExprResult)r;
        } else {
            if (this.rhsType != null) {
                throw new NotImplementedException("was not expecting multiple results");
            }
            this.rhsType = (ExpressionChecker.ExprResult)r;
        }
    }

    @Override
    public void visitSendHandler(Expr handlerExpr) {
        this.expectHandler = true;
        this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, this.fnCxt, false));
    }

    @Override
    public void leaveSendHandler(Expr handlerExpr) {
        this.expectHandler = false;
    }

    @Override
    public void visitAssignSlot(Expr toSlot) {
        if (this.rhsType.type instanceof ErrorType) {
            return;
        }
        ExpressionChecker.ExprResult container = this.unpackMembers(toSlot);
        if (container instanceof CheckChain) {
            ((CheckChain)container).finalSlot = toSlot;
            return;
        }
        if (container.type instanceof ErrorType) {
            this.rhsType = container;
            return;
        }
        this.checkFinal(toSlot, container.type);
    }

    private void checkFinal(Expr toSlot, Type container) {
        PolyInstance tmp;
        if (container instanceof UnifiableType) {
            throw new CantHappenException("this should have been resolved");
        }
        if (this.assign != null && container instanceof PolyInstance && (tmp = (PolyInstance)container).struct() == LoadBuiltins.assignItem) {
            container = tmp.polys().get(0);
            this.assign.willAssignToCons();
        }
        if (!container.incorporates(this.rhsType.pos, this.rhsType.type)) {
            if (toSlot instanceof UnresolvedVar) {
                UnresolvedVar uv = (UnresolvedVar)toSlot;
                this.errors.message(this.rhsType.pos, "the field " + uv.var + " is of type " + container.signature() + ", not " + this.rhsType.type.signature());
            } else {
                MemberExpr me = (MemberExpr)toSlot;
                UnresolvedVar fld = (UnresolvedVar)me.fld;
                this.errors.message(this.rhsType.pos, "the field " + fld.var + " in " + me.containedType() + " is of type " + container.signature() + ", not " + this.rhsType.type.signature());
            }
            this.rhsType = new ExpressionChecker.ExprResult(this.rhsType.pos, new ErrorType());
            return;
        }
    }

    private ExpressionChecker.ExprResult unpackMembers(Expr toSlot) {
        InputPosition pos = toSlot.location();
        if (toSlot instanceof UnresolvedVar) {
            UnresolvedVar var = (UnresolvedVar)toSlot;
            RepositoryEntry vardefn = var.defn();
            if (vardefn instanceof StructField) {
                StructField sf = (StructField)vardefn;
                if (!(sf.container() instanceof StateDefinition)) {
                    this.errors.message(pos, "cannot use " + var.var + " as the main slot in assignment");
                    return new ExpressionChecker.ExprResult(this.rhsType.pos, new ErrorType());
                }
                return new ExpressionChecker.ExprResult(var.location, sf.type());
            }
            if (vardefn instanceof TypedPattern) {
                return new ExpressionChecker.ExprResult(var.location, ((TypedPattern)vardefn).type.namedDefn());
            }
            if (vardefn instanceof VarPattern) {
                VarPattern vp = (VarPattern)vardefn;
                if (vp.hasBoundType()) {
                    return new ExpressionChecker.ExprResult(var.location, vp.type());
                }
                UnifiableType vt = this.state.createUT(var.location, "vardefn:" + vp.var);
                vp.bindType(vt);
                return new ExpressionChecker.ExprResult(var.location, vt);
            }
            if (vardefn instanceof FunctionDefinition) {
                FunctionDefinition fd = (FunctionDefinition)vardefn;
                if (fd.hasType()) {
                    Type ty = fd.type();
                    return this.checkInnermostType(var, ty);
                }
                UnifiableType utf = this.state.requireVarConstraints(var.location(), fd.name().uniqueName(), fd.name().uniqueName());
                CheckChain ret = new CheckChain(var, utf);
                utf.callOnResolved(ret::check);
                return ret;
            }
            throw new NotImplementedException("cannot handle assigning to (member of) " + vardefn);
        }
        if (toSlot instanceof MemberExpr) {
            MemberExpr me = (MemberExpr)toSlot;
            ExpressionChecker.ExprResult res = this.unpackMembers(me.from);
            if (res instanceof CheckChain) {
                ((CheckChain)res).addLink(pos, me, toSlot);
                return res;
            }
            Type ty = res.type;
            if (ty instanceof ErrorType) {
                return res;
            }
            return this.analyzeContainer(toSlot, pos, me, ty);
        }
        throw new NotImplementedException(toSlot + " is a " + toSlot.getClass());
    }

    private ExpressionChecker.ExprResult checkInnermostType(UnresolvedVar var, Type ty) {
        Type rem = ty;
        if (ty instanceof Apply) {
            int discardNested;
            if (!(var.defn() instanceof FunctionDefinition)) {
                throw new HaventConsideredThisException("expecting var to be a function");
            }
            FunctionDefinition fd = (FunctionDefinition)var.defn();
            Apply app = (Apply)ty;
            StateHolder state = ((ObjectMethod)this.inMeth).state();
            if (!app.tys.get(0).equals((Type)((Object)state))) {
                throw new HaventConsideredThisException("expecting first arg to be the current object");
            }
            rem = app.appliedTo(state);
            if (rem instanceof UnifiableType) {
                rem = ((UnifiableType)rem).resolvedTo();
            }
            if ((discardNested = fd.nestedVars().size()) > 0) {
                Apply da = (Apply)rem;
                rem = da.discard(discardNested);
            }
        }
        if (rem instanceof UnifiableType) {
            rem = ((UnifiableType)rem).resolvedTo();
        }
        return new ExpressionChecker.ExprResult(var.location, rem);
    }

    private ExpressionChecker.ExprResult analyzeContainer(Expr toSlot, InputPosition pos, MemberExpr me, Type ty) {
        UnresolvedVar v = (UnresolvedVar)me.fld;
        me.bindContainerType(ty);
        if (ty instanceof StructDefn) {
            StructDefn sd = (StructDefn)ty;
            StructField fld = sd.findField(v.var);
            if (fld == null) {
                this.errors.message(toSlot.location(), "there is no field " + v.var + " in " + sd.name().uniqueName());
                return new ExpressionChecker.ExprResult(this.rhsType.pos, new ErrorType());
            }
            if ("source".equals(v.var)) {
                List<Type> sources = ((ObjectMethod)this.inMeth).sources();
                if (sources.size() != 1) {
                    throw new NotImplementedException("we need to check the consistency of sources");
                }
                me.bindContainedType(LoadBuiltins.event);
                return new ExpressionChecker.ExprResult(v.location, sources.get(0));
            }
            me.bindContainedType(fld.type());
            return new ExpressionChecker.ExprResult(v.location, fld.type());
        }
        if (ty instanceof StateHolder) {
            StateHolder type = (StateHolder)((Object)ty);
            StateDefinition state = type.state();
            if (state == null) {
                this.errors.message(pos, type.name().uniqueName() + " does not have state");
                return new ExpressionChecker.ExprResult(this.rhsType.pos, new ErrorType());
            }
            StructField fld = state.findField(v.var);
            if (fld == null) {
                this.errors.message(toSlot.location(), "there is no field " + v.var + " in " + type.name().uniqueName());
                return new ExpressionChecker.ExprResult(this.rhsType.pos, new ErrorType());
            }
            me.bindContainedType(fld.type());
            return new ExpressionChecker.ExprResult(v.location, fld.type());
        }
        if (v.var == null) {
            throw new NotImplementedException("there is no state at the top level in: " + ty.getClass());
        }
        if (me.from instanceof UnresolvedVar) {
            UnresolvedVar uvf = (UnresolvedVar)me.from;
            this.errors.message(toSlot.location(), "field " + uvf.var + " is not a container");
        } else {
            MemberExpr inner = (MemberExpr)me.from;
            UnresolvedVar uvf = (UnresolvedVar)inner.fld;
            this.errors.message(toSlot.location(), "field " + uvf.var + " in " + inner.containedType().signature() + " is not a container");
        }
        return new ExpressionChecker.ExprResult(this.rhsType.pos, new ErrorType());
    }

    @Override
    public void leaveMessage(ActionMessage msg) {
        InputPosition pos = this.rhsType.pos;
        Type ty = this.rhsType.type;
        if (msg instanceof SendMessage) {
            SendMessage sm = (SendMessage)msg;
            if (TypeHelpers.isListMessage(pos, ty)) {
                if (this.handlerType != null) {
                    this.errors.message(pos, ty.signature() + " cannot have a handler");
                }
            } else {
                boolean isError = true;
                if (!(ty instanceof ErrorType)) {
                    if (TypeHelpers.isList(ty)) {
                        this.errors.message(pos, ((PolyInstance)ty).polys().get(0).signature() + " cannot be a Message");
                    } else if (ty instanceof Apply && this.handlerType != null) {
                        Apply ae = (Apply)ty;
                        if (ae.argCount() != 1) {
                            this.errors.message(sm.expr.location().locAtEnd().plus(1), "insufficient arguments");
                        } else if (!ae.tys.get(0).incorporates(pos, this.handlerType.type)) {
                            this.errors.message(sm.expr.location().locAtEnd().plus(1), "message method was expecting a handler of " + ae.tys.get(0).signature() + " not " + this.handlerType.type.signature());
                        } else {
                            isError = false;
                        }
                    } else {
                        this.errors.message(pos, ty.signature() + " cannot be a Message");
                    }
                }
                if (isError) {
                    this.sv.result(new ExpressionChecker.ExprResult(pos, new ErrorType()));
                    return;
                }
            }
        }
        this.sv.result(new ExpressionChecker.ExprResult(pos, LoadBuiltins.listMessages));
    }

    public class CheckChain
    extends ExpressionChecker.ExprResult {
        private final UnresolvedVar var;
        private final List<Link> links;
        public Expr finalSlot;

        public CheckChain(UnresolvedVar var, UnifiableType utf) {
            super(var.location, utf);
            this.links = new ArrayList<Link>();
            this.var = var;
        }

        public void addLink(InputPosition pos, MemberExpr me, Expr toSlot) {
            this.links.add(new Link(pos, me, toSlot));
        }

        public void check(Type rty) {
            ErrorMark mark = MessageChecker.this.errors.mark();
            ExpressionChecker.ExprResult ity = MessageChecker.this.checkInnermostType(this.var, rty);
            for (Link l : this.links) {
                if (mark.hasMoreNow()) {
                    return;
                }
                ity = l.analyze(ity);
            }
            if (mark.hasMoreNow()) {
                return;
            }
            MessageChecker.this.checkFinal(this.finalSlot, ity.type);
        }
    }

    public class Link {
        private final InputPosition pos;
        private final MemberExpr me;
        private final Expr toSlot;

        public Link(InputPosition pos, MemberExpr me, Expr toSlot) {
            this.pos = pos;
            this.me = me;
            this.toSlot = toSlot;
        }

        public ExpressionChecker.ExprResult analyze(ExpressionChecker.ExprResult ty) {
            Type rt = ty.type;
            if (rt instanceof UnifiableType) {
                rt = ((UnifiableType)rt).resolvedTo();
            }
            return MessageChecker.this.analyzeContainer(this.toSlot, this.pos, this.me, rt);
        }
    }
}

