/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.SendMessage;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.MessageChecker;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.NotImplementedException;

public class GuardedMessagesChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final NestedVisitor sv;
    private final String fnCxt;
    private final ObjectActionHandler inMeth;
    private InputPosition pos;

    public GuardedMessagesChecker(ErrorReporter errors, RepositoryReader repository, CurrentTCState state, NestedVisitor sv, String fnCxt, ObjectActionHandler inMeth) {
        this.errors = errors;
        this.repository = repository;
        this.state = state;
        this.sv = sv;
        this.fnCxt = fnCxt;
        this.inMeth = inMeth;
        sv.push(this);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        if (expr != null) {
            this.pos = expr.location();
        }
        this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, this.fnCxt, false));
    }

    @Override
    public void visitSendMessage(SendMessage sm) {
        new MessageChecker(this.errors, this.repository, this.state, this.sv, this.fnCxt, this.inMeth, null);
    }

    @Override
    public void visitAssignMessage(AssignMessage assign) {
        new MessageChecker(this.errors, this.repository, this.state, this.sv, this.fnCxt, this.inMeth, assign);
    }

    @Override
    public void result(Object r) {
        Type ret;
        if (!(r instanceof ExpressionChecker.ExprResult)) {
            throw new NotImplementedException("should be an expr result");
        }
        ExpressionChecker.ExprResult exprResult = (ExpressionChecker.ExprResult)r;
        if (this.pos == null) {
            this.pos = exprResult.pos;
        }
        if ((ret = exprResult.type) instanceof UnifiableType) {
            ((UnifiableType)ret).isReturned(exprResult.pos);
        }
    }

    @Override
    public void leaveGuardedMessage(GuardedMessages gm) {
        this.sv.result(new ExpressionChecker.ExprResult(this.pos, LoadBuiltins.listMessages));
    }
}

