/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.repository.FunctionGroup;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionChecker;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.HaventConsideredThisException;

public class GroupChecker
extends LeafAdapter
implements ResultAware {
    private static final Logger logger = LoggerFactory.getLogger((String)"TypeChecker");
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private CurrentTCState state;
    private TypeBinder currentFunction;
    private final Map<TypeBinder, PosType> memberTypes = new HashMap<TypeBinder, PosType>();
    private final Map<TypeBinder, PosType> resultTypes = new HashMap<TypeBinder, PosType>();

    public GroupChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, CurrentTCState state, ErrorMark mark) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.state = state;
        sv.push(this);
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        new FunctionChecker(this.errors, this.repository, this.sv, fn.name(), this.state, null);
        this.currentFunction = fn;
    }

    @Override
    public void visitObjectMethod(ObjectMethod meth) {
        new FunctionChecker(this.errors, this.repository, this.sv, meth.name(), this.state, meth);
        this.currentFunction = meth;
    }

    @Override
    public void visitObjectCtor(ObjectCtor meth) {
        new FunctionChecker(this.errors, this.repository, this.sv, meth.name(), this.state, meth);
        this.currentFunction = meth;
    }

    @Override
    public void visitTuple(TupleAssignment ta) {
        new FunctionChecker(this.errors, this.repository, this.sv, ta.name(), this.state, null);
        this.currentFunction = ta;
        this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, ta.name().uniqueName(), false));
    }

    @Override
    public void leaveTupleMember(TupleMember tm) {
        this.memberTypes.put(tm, new PosType(tm.location(), tm.type()));
    }

    @Override
    public void result(Object r) {
        PosType pt = (PosType)r;
        this.memberTypes.put(this.currentFunction, pt);
        this.resultTypes.put(this.currentFunction, GroupChecker.extractResult(this.currentFunction, pt));
        if (pt != null) {
            logger.info("result of " + this.currentFunction + " is " + this.resultTypes.get((Object)this.currentFunction).type);
        }
        this.currentFunction = null;
    }

    public static PosType extractResult(TypeBinder fn, PosType pt) {
        if (pt == null) {
            logger.info("  nothing deduced for " + fn);
            return null;
        }
        if (pt.type instanceof ErrorType) {
            return pt;
        }
        logger.debug("  deduced type of " + fn + " is: " + pt.type);
        int ac = fn.argCount();
        logger.debug("    argCount including everything = " + ac);
        if (ac == 0) {
            return pt;
        }
        if (!(pt.type instanceof Apply)) {
            throw new HaventConsideredThisException("need to strip args from " + pt.type + " for " + fn + " but it is not an apply");
        }
        Apply ap = (Apply)pt.type;
        if (ac == ap.argCount()) {
            return new PosType(pt.pos, ap.tys.get(ac));
        }
        if (ac > ap.argCount()) {
            throw new HaventConsideredThisException("want to strip " + ac + " args from " + pt.type + " for " + fn);
        }
        List<Type> sl = ap.tys.subList(ac, ap.tys.size());
        return new PosType(pt.pos, new Apply(sl));
    }

    @Override
    public void leaveFunctionGroup(FunctionGroup grp) {
        this.state.groupDone(this.errors, this.memberTypes, this.resultTypes);
        this.sv.result(null);
    }

    public CurrentTCState testsWantToCheckState() {
        return this.state;
    }
}

