/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.FunctionGroup;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeChecker;
import org.flasck.flas.tc3.TypeConstraintSet;
import org.flasck.flas.tc3.UnifiableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.MapMap;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.CycleDetectedException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.graphs.DirectedAcyclicGraph;
import org.zinutils.graphs.Node;
import org.zinutils.graphs.NodeWalker;

public class FunctionGroupTCState
implements CurrentTCState {
    private static final Logger uniflogger = LoggerFactory.getLogger((String)"TCUnification");
    private final RepositoryReader repository;
    private final MapMap<String, String, UnifiableType> constraints = new MapMap();
    private final Map<String, UnifiableType> polys = new TreeMap<String, UnifiableType>();
    private final Map<VarPattern, UnifiableType> patts = new TreeMap<VarPattern, UnifiableType>(VarPattern.comparator);
    private final Map<IntroduceVar, UnifiableType> introductions = new TreeMap<IntroduceVar, UnifiableType>(IntroduceVar.comparator);
    int polyCount = 0;
    private List<UnifiableType> allUTs = new ArrayList<UnifiableType>();
    private final boolean hasGroup;
    private Map<String, Type> memberTypes = new TreeMap<String, Type>();

    public FunctionGroupTCState(RepositoryReader repository, FunctionGroup grp) {
        this.repository = repository;
        uniflogger.info("  binding return types for group");
        for (LogicHolder x : grp.functions()) {
            this.bindVarToUT(x.name().uniqueName(), x.name().uniqueName(), this.createUT(x.location(), x.name().uniqueName() + " returns", false));
        }
        this.hasGroup = !grp.isEmpty();
    }

    @Override
    public void recordMember(FunctionName name, List<Type> ats) {
        if (ats.isEmpty()) {
            this.memberTypes.put(name.uniqueName(), this.requireVarConstraints(null, name.uniqueName(), name.uniqueName()));
        } else {
            this.memberTypes.put(name.uniqueName(), new Apply(ats, (Type)this.requireVarConstraints(null, name.uniqueName(), name.uniqueName())));
        }
    }

    @Override
    public Type getMember(FunctionName name) {
        return this.memberTypes.get(name.uniqueName());
    }

    @Override
    public boolean hasGroup() {
        return this.hasGroup;
    }

    @Override
    public UnifiableType createUT(InputPosition pos, String motive) {
        return this.createUT(pos, motive, true);
    }

    @Override
    public UnifiableType createUT(InputPosition pos, String motive, boolean unionNeedsAll) {
        TypeConstraintSet ret = new TypeConstraintSet(this.repository, this, pos, "ret_" + this.allUTs.size(), motive, unionNeedsAll);
        this.allUTs.add(ret);
        return ret;
    }

    @Override
    public void bindVarToUT(String fnCxt, String name, UnifiableType ty) {
        if (!this.allUTs.contains(ty)) {
            throw new NotImplementedException("Where did this come from?");
        }
        if (this.constraints.contains((Object)fnCxt, (Object)name)) {
            throw new CantHappenException("duplicate name for one var: " + name + " in " + fnCxt);
        }
        uniflogger.info("    binding " + fnCxt + " :: " + name + " to " + ty.id() + " for " + ty.motive());
        this.constraints.add((Object)fnCxt, (Object)name, (Object)ty);
    }

    @Override
    public void bindVarPatternToUT(VarPattern vp, UnifiableType ty) {
        if (!this.allUTs.contains(ty)) {
            throw new NotImplementedException("Where did this come from?");
        }
        this.patts.put(vp, ty);
        if (vp.hasBoundType()) {
            ty.canBeType(vp.location(), vp.type());
        }
    }

    @Override
    public void bindIntroducedVarToUT(IntroduceVar v, UnifiableType ut) {
        if (!this.allUTs.contains(ut)) {
            throw new NotImplementedException("Where did this come from?");
        }
        this.introductions.put(v, ut);
    }

    @Override
    public void bindVarPatternTypes(ErrorReporter errors) {
        for (Map.Entry<VarPattern, UnifiableType> e : this.patts.entrySet()) {
            UnifiableType ut = e.getValue();
            e.getKey().bindType(ut.resolvedTo());
        }
    }

    @Override
    public void bindIntroducedVarTypes(ErrorReporter errors) {
        for (Map.Entry<IntroduceVar, UnifiableType> e : this.introductions.entrySet()) {
            e.getKey().bindType(e.getValue());
        }
    }

    @Override
    public void recordPolys(Type ofType) {
        if (ofType instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)ofType;
            for (int i = 0; i < pi.polys().size(); ++i) {
                Type t = pi.polys().get(i);
                if (t instanceof PolyType) {
                    UnifiableType ut = this.createUT(pi.location(), "poly var " + ((PolyType)t).name().uniqueName());
                    this.rememberPoly((PolyType)t, ut);
                    continue;
                }
                this.recordPolys(t);
            }
        }
    }

    @Override
    public void rememberPoly(PolyType pt, UnifiableType pv) {
        this.polys.put(pt.name().uniqueName(), pv);
    }

    @Override
    public boolean hasPoly(PolyType pt) {
        return this.polys.containsKey(pt.name().uniqueName());
    }

    @Override
    public Type getPoly(PolyType pt) {
        return this.polys.get(pt.name().uniqueName());
    }

    @Override
    public UnifiableType requireVarConstraints(InputPosition pos, String fnCxt, String var) {
        if (!this.constraints.contains((Object)fnCxt, (Object)var)) {
            throw new RuntimeException("We don't have var constraints for " + var + " in " + fnCxt + " but it should have been bound during arg processing: " + this.constraints.key2Set((Object)fnCxt));
        }
        return (UnifiableType)this.constraints.get((Object)fnCxt, (Object)var);
    }

    @Override
    public UnifiableType hasVar(String fnCxt, String var) {
        return (UnifiableType)this.constraints.get((Object)fnCxt, (Object)var);
    }

    @Override
    public PolyType nextPoly(InputPosition pos) {
        if (this.polyCount >= 26) {
            throw new NotImplementedException("Cannot handle more than 26 poly types at once");
        }
        return new PolyType(pos, new SolidName(new PackageName(true), new String(new char[]{(char)(65 + this.polyCount++)})));
    }

    @Override
    public void groupDone(final ErrorReporter errors, Map<TypeBinder, PosType> memberTypes, Map<TypeBinder, PosType> resultTypes) {
        ErrorMark mark = errors.mark();
        TypeChecker.logger.debug("starting to unify types found in group: " + memberTypes.keySet());
        for (Map.Entry<TypeBinder, PosType> e : memberTypes.entrySet()) {
            if (e.getValue() == null) {
                return;
            }
            uniflogger.debug("  " + e.getKey() + " :: " + e.getValue().type);
        }
        for (Map.Entry<TypeBinder, PosType> m : resultTypes.entrySet()) {
            String name = m.getKey().name().uniqueName();
            UnifiableType ut = this.requireVarConstraints(m.getKey().location(), name, name);
            ut.determinedType(m.getValue());
        }
        this.debugInfo("initial");
        this.expandUsed();
        this.debugInfo("moreused");
        this.expandUnions();
        this.debugInfo("expanded");
        this.mergePolyVars();
        this.debugInfo("merged");
        this.acquireEquivalent();
        this.debugInfo("acquired");
        DirectedAcyclicGraph<UnifiableType> dag = this.collate(errors);
        if (dag == null) {
            return;
        }
        uniflogger.debug("UT DAG:\n" + dag.toString());
        List roots = dag.roots();
        Comparator<UnifiableType> order = new Comparator<UnifiableType>(){

            @Override
            public int compare(UnifiableType o1, UnifiableType o2) {
                return o1.id().compareTo(o2.id());
            }
        };
        Collections.sort(roots, order);
        uniflogger.debug("ROOTS: " + dag.roots());
        for (UnifiableType unifiableType : roots) {
            dag.postOrderFromWithOrder((NodeWalker)new NodeWalker<UnifiableType>(){

                public void present(Node<UnifiableType> node) {
                    if (((UnifiableType)node.getEntry()).isRedirected()) {
                        return;
                    }
                    ((UnifiableType)node.getEntry()).resolve(errors);
                }
            }, (Object)unifiableType, (Comparator)order);
        }
        if (!mark.hasMoreNow()) {
            for (UnifiableType unifiableType : roots) {
                dag.postOrderFromWithOrder((NodeWalker)new NodeWalker<UnifiableType>(){

                    public void present(Node<UnifiableType> node) {
                        if (((UnifiableType)node.getEntry()).isRedirected()) {
                            return;
                        }
                        ((UnifiableType)node.getEntry()).afterResolution(errors);
                    }
                }, (Object)unifiableType, (Comparator)order);
            }
        }
        uniflogger.debug("binding group:");
        for (Map.Entry entry : memberTypes.entrySet()) {
            Type as = this.cleanUTs(errors, ((PosType)entry.getValue()).pos, ((PosType)entry.getValue()).type, new ArrayList<UnifiableType>(), new HashMap<PolyType, PolyType>());
            uniflogger.debug(entry.getKey() + " :: " + as);
            TypeChecker.logger.info(entry.getKey() + " :: " + as);
            ((TypeBinder)entry.getKey()).bindType(as);
        }
        this.bindVarPatternTypes(errors);
    }

    private void expandUnions() {
        for (UnifiableType ut : this.allUTs) {
            ut.expandUnions();
        }
    }

    private void expandUsed() {
        for (UnifiableType ut : this.allUTs) {
            ut.expandUsed();
        }
    }

    private void mergePolyVars() {
        for (int i = 0; i < this.allUTs.size(); ++i) {
            UnifiableType ut = this.allUTs.get(i);
            ut.mergePolyVars();
        }
    }

    private void acquireEquivalent() {
        ArrayList<UnifiableType> considered = new ArrayList<UnifiableType>();
        for (int i = 0; i < this.allUTs.size(); ++i) {
            UnifiableType ut = this.allUTs.get(i);
            ut.acquireOthers(considered);
            considered.add(ut);
        }
    }

    private DirectedAcyclicGraph<UnifiableType> collate(ErrorReporter errors) {
        DirectedAcyclicGraph ret = new DirectedAcyclicGraph();
        for (int i = 0; i < this.allUTs.size(); ++i) {
            UnifiableType ut = this.allUTs.get(i);
            ret.ensure((Object)ut);
            if (ut.isRedirected()) {
                uniflogger.debug("not collecting info on " + ut.id() + " because redirected to " + ut.redirectedTo());
                ret.ensure((Object)ut.redirectedTo());
                ret.ensureLink((Object)ut, (Object)ut.redirectedTo());
                continue;
            }
            try {
                ut.collectInfo(errors, (DirectedAcyclicGraph<UnifiableType>)ret);
                continue;
            }
            catch (CycleDetectedException ex) {
                errors.message(ut.location(), "cycle detected in type");
                return null;
            }
        }
        return ret;
    }

    private Type cleanUTs(ErrorReporter errors, InputPosition pos, Type ty, List<UnifiableType> recs, Map<PolyType, PolyType> inorderPolys) {
        uniflogger.debug("Cleaning " + ty + " " + ty.getClass());
        if (ty instanceof UnifiableType) {
            ArrayList<UnifiableType> dontUse = new ArrayList<UnifiableType>(recs);
            UnifiableType ut = (UnifiableType)ty;
            dontUse.add(ut);
            return this.cleanUTs(errors, pos, ut.resolvedTo(), dontUse, inorderPolys);
        }
        if (ty instanceof Apply) {
            Apply a = (Apply)ty;
            ArrayList<Type> tys = new ArrayList<Type>();
            for (Type t : a.tys) {
                if (recs.contains(t)) {
                    errors.message(pos, "circular polymorphic type inferred");
                    return new ErrorType();
                }
                tys.add(this.cleanUTs(errors, pos, t, recs, inorderPolys));
            }
            return new Apply(tys);
        }
        if (ty instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)ty;
            ArrayList<Type> polys = new ArrayList<Type>();
            for (Type t : pi.polys()) {
                if (recs.contains(t)) {
                    errors.message(pos, "circular polymorphic type inferred");
                    return new ErrorType();
                }
                polys.add(this.cleanUTs(errors, pos, t, recs, inorderPolys));
            }
            return new PolyInstance(pi.location(), (NamedType)this.cleanUTs(errors, pos, pi.struct(), recs, inorderPolys), polys);
        }
        if (ty instanceof PolyType) {
            if (inorderPolys.containsKey(ty)) {
                return inorderPolys.get(ty);
            }
            PolyType curr = (PolyType)ty;
            PolyType ret = new PolyType(curr.location(), new SolidName(curr.name().container(), new String(new char[]{(char)(65 + inorderPolys.size())})));
            inorderPolys.put(curr, ret);
            return ret;
        }
        return ty;
    }

    @Override
    public PosType consolidate(InputPosition pos, Collection<PosType> types) {
        if (types.isEmpty()) {
            throw new NotImplementedException("Cannot handle consolidating no types");
        }
        PosType ret = types.iterator().next();
        if (types.size() == 1) {
            return ret;
        }
        int commonApply = -1;
        pos = ret.pos;
        boolean allMatch = true;
        boolean haveUTs = false;
        for (PosType t : types) {
            if (t.type instanceof ErrorType) {
                return t;
            }
            if (t.type == LoadBuiltins.error) continue;
            if (ret.type == LoadBuiltins.error) {
                ret = t;
            }
            if (!(t.type instanceof UnifiableType)) {
                pos = t.pos;
            }
            if (ret.type != t.type) {
                allMatch = false;
            }
            if (t.type instanceof Apply) {
                if (commonApply == -1) {
                    commonApply = ((Apply)t.type).argCount();
                    continue;
                }
                if (commonApply == ((Apply)t.type).argCount()) continue;
                throw new HaventConsideredThisException("we could be asked to unify different levels of apply, providing UTs are involved somewhere; if not, I think that has to be a type error: " + types);
            }
            if (t.type instanceof UnifiableType) {
                haveUTs = true;
                continue;
            }
            commonApply = 0;
        }
        if (allMatch) {
            return ret;
        }
        if (haveUTs) {
            return this.collapse(pos, types);
        }
        if (commonApply > 0) {
            ArrayList<Type> args = new ArrayList<Type>();
            for (int i = 0; i <= commonApply; ++i) {
                ArrayList ai = new ArrayList();
                for (PosType pt : types) {
                    if (!(pt.type instanceof Apply)) continue;
                    ai.add(new PosType(pos, ((Apply)pt.type).get(i)));
                }
                PosType ct = this.consolidate(pos, ai);
                args.add(ct.type);
            }
            Apply c = new Apply(args);
            for (PosType pt : types) {
                if (!(pt.type instanceof UnifiableType)) continue;
                ((UnifiableType)pt.type).recordApplication(pt.pos, args);
            }
            return new PosType(pos, c);
        }
        StringBuilder motive = new StringBuilder("consolidating");
        for (PosType t : types) {
            motive.append(" ");
            Type tt = t.type;
            if (tt instanceof UnifiableType) {
                motive.append(((UnifiableType)tt).id());
                continue;
            }
            motive.append(tt.signature());
        }
        UnifiableType ut = this.createUT(pos, motive.toString(), false);
        uniflogger.debug("  " + motive + " as " + ut.id());
        for (PosType t : types) {
            if (t.type instanceof Apply) {
                ((TypeConstraintSet)ut).consolidatedApplication(pos, (Apply)t.type);
                continue;
            }
            ut.sameAs(t.pos, t.type);
        }
        return new PosType(pos, ut);
    }

    @Override
    public PosType collapse(InputPosition pos, Collection<PosType> types) {
        if (types.isEmpty()) {
            throw new NotImplementedException("Cannot handle consolidating no types");
        }
        PosType ret = types.iterator().next();
        if (types.size() == 1) {
            return ret;
        }
        pos = ret.pos;
        boolean allMatch = true;
        TreeSet<? super PosType> uts = new TreeSet<PosType>(TypeConstraintSet.posNameComparator);
        HashSet<Type> others = new HashSet<Type>();
        for (PosType t : types) {
            if (t.type instanceof ErrorType) {
                return t;
            }
            if (t.type instanceof UnifiableType) {
                uts.add(new PosType(t.pos, ((UnifiableType)t.type).redirectedTo()));
            } else {
                if (t.pos != null) {
                    pos = t.pos;
                }
                others.add(t.type);
            }
            if (ret.type == t.type) continue;
            allMatch = false;
        }
        if (allMatch) {
            return ret;
        }
        if (others.isEmpty() && uts.size() == 1) {
            return (PosType)uts.iterator().next();
        }
        UnifiableType ut = (UnifiableType)((PosType)uts.iterator().next()).type;
        uniflogger.debug("  allowing " + ut.id() + " to collapse " + types);
        for (PosType t : types) {
            if (t.type instanceof Apply) {
                ((TypeConstraintSet)ut).consolidatedApplication(t.pos, (Apply)t.type);
                continue;
            }
            if (t.type instanceof UnifiableType) {
                ut.acquire((UnifiableType)t.type);
                continue;
            }
            ut.sameAs(t.pos, t.type);
        }
        return new PosType(pos, ut);
    }

    @Override
    public void debugInfo(String when) {
        uniflogger.debug("------ " + when + " # = " + this.allUTs.size());
        for (UnifiableType ut : this.allUTs) {
            TypeConstraintSet tcs = (TypeConstraintSet)ut;
            uniflogger.debug(tcs.debugInfo());
        }
        uniflogger.debug("======");
    }
}

