/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.hsi.ArgSlot;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.hsi.TreeOrderVisitor;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.FunctionCaseDefn;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.SendMessage;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.resolver.TemplateNestingChain;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.ContainerChecker;
import org.flasck.flas.tc3.ContractSlotChecker;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.GuardedMessagesChecker;
import org.flasck.flas.tc3.MessageChecker;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.SlotChecker;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeHelpers;
import org.flasck.flas.tc3.UnifiableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.NotImplementedException;

public class FunctionChecker
extends LeafAdapter
implements ResultAware,
TreeOrderVisitor {
    public static final Logger logger = LoggerFactory.getLogger((String)"TypeChecker");
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor sv;
    private final List<PosType> argTypes = new ArrayList<PosType>();
    private final List<PosType> resultTypes = new ArrayList<PosType>();
    private final CurrentTCState state;
    private final ObjectActionHandler inMeth;
    private final ContractSlotChecker csc;
    private FunctionName name;

    public FunctionChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, FunctionName name, CurrentTCState state, ObjectActionHandler inMeth) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.name = name;
        this.state = state;
        this.inMeth = inMeth;
        this.csc = inMeth != null && inMeth.contractMethod() != null ? new ContractSlotChecker(errors, sv, state, inMeth) : null;
        sv.push(this);
        Type t = state.getMember(name);
        if (t != null && t instanceof Apply) {
            List<Type> att = ((Apply)t).tys;
            List<Type> sl = att.subList(0, att.size() - 1);
            for (Type ti : sl) {
                this.argTypes.add(new PosType(null, ti));
            }
        }
    }

    @Override
    public void visitEventSource(Template t) {
        if (t.nestingChain() == null) {
            ((ObjectMethod)this.inMeth).bindEventSource(this.inMeth.getCard());
        } else {
            ((ObjectMethod)this.inMeth).bindEventSource(((TemplateNestingChain.Link)t.nestingChain().iterator().next()).type());
        }
    }

    @Override
    public void visitHandlerLambda(HandlerLambda hl) {
        Pattern patt = hl.patt;
        if (patt instanceof VarPattern) {
            if (hl.usedBy.contains(this.name)) {
                VarPattern vp = (VarPattern)patt;
                UnifiableType lt = this.state.createUT(null, "hl " + vp.var);
                this.state.bindVarToUT(this.name.uniqueName(), vp.name().uniqueName(), lt);
                if (hl.isNested) {
                    hl.unifiableType(lt);
                }
                this.state.bindVarPatternToUT(vp, lt);
            }
        } else if (patt instanceof TypedPattern) {
            TypedPattern tp = (TypedPattern)patt;
            UnifiableType lt = this.state.createUT(null, "hl " + tp.var);
            lt.canBeType(tp.var.loc, tp.type.namedDefn());
            this.state.bindVarToUT(hl.name().uniqueName(), tp.name().uniqueName(), lt);
        } else {
            throw new NotImplementedException("not supported as lambda: " + patt.getClass());
        }
    }

    @Override
    public void argSlot(ArgSlot s) {
        if (this.inMeth != null && this.inMeth.contractMethod() != null) {
            this.sv.push(this.csc);
        } else if (s.isContainer()) {
            new ContainerChecker(this.sv, s.containerType());
        } else {
            UnifiableType currentArg = this.state.createUT(null, this.name.uniqueName() + " slot " + s);
            this.sv.push(new SlotChecker(this.sv, this.name, this.state, currentArg));
        }
    }

    @Override
    public void matchConstructor(StructDefn ctor) {
        throw new NotImplementedException("This should not happen here .. just argslots");
    }

    @Override
    public void matchField(StructField fld) {
        throw new NotImplementedException("This should not happen here .. just argslots");
    }

    @Override
    public void matchType(Type ty, VarName var, FunctionIntro intro) {
        throw new NotImplementedException("This should not happen here .. just argslots");
    }

    @Override
    public void varInIntro(VarName vn, VarPattern vp, FunctionIntro intro) {
        throw new NotImplementedException("This should not happen here .. just argslots");
    }

    @Override
    public void endField(StructField fld) {
        throw new NotImplementedException("This should not happen here .. just argslots");
    }

    @Override
    public void endConstructor(StructDefn ctor) {
        throw new NotImplementedException("This should not happen here .. just argslots");
    }

    @Override
    public void endArg(Slot s) {
        throw new NotImplementedException("This should not happen here .. just argslots");
    }

    @Override
    public void patternsDone(LogicHolder fn) {
        if (fn instanceof ObjectCtor && !((ObjectCtor)fn).generate) {
            return;
        }
        if (fn instanceof ObjectMethod && !((ObjectMethod)fn).generate) {
            return;
        }
        ArrayList<Type> ats = new ArrayList<Type>();
        for (PosType ar : this.argTypes) {
            ats.add(ar.type);
        }
        this.state.recordMember(fn.name(), ats);
    }

    @Override
    public void visitFunctionIntro(FunctionIntro fi) {
        this.name = fi.name();
    }

    @Override
    public void visitCase(FunctionCaseDefn fcd) {
        this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, this.name.uniqueName(), false));
    }

    @Override
    public void visitGuardedMessage(GuardedMessages gm) {
        new GuardedMessagesChecker(this.errors, this.repository, this.state, this.sv, this.name.uniqueName(), this.inMeth);
    }

    @Override
    public void visitSendMessage(SendMessage sm) {
        new MessageChecker(this.errors, this.repository, this.state, this.sv, this.name.uniqueName(), this.inMeth, null);
    }

    @Override
    public void visitAssignMessage(AssignMessage assign) {
        new MessageChecker(this.errors, this.repository, this.state, this.sv, this.name.uniqueName(), this.inMeth, assign);
    }

    @Override
    public void result(Object r) {
        if (!(r instanceof PosType)) {
            throw new NotImplementedException("should be some kind of PosType");
        }
        if (r instanceof ArgResult) {
            this.argTypes.add((ArgResult)r);
        } else if (r instanceof ExpressionChecker.GuardResult) {
            ExpressionChecker.GuardResult gr = (ExpressionChecker.GuardResult)r;
            Type ret = gr.type;
            if (!LoadBuiltins.bool.incorporates(gr.location(), ret)) {
                this.errors.message(gr.location(), "guards must be booleans");
            }
            this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, this.name.uniqueName(), false));
        } else {
            ExpressionChecker.ExprResult exprResult = (ExpressionChecker.ExprResult)r;
            InputPosition pos = exprResult.pos;
            Type ret = exprResult.type;
            this.markUsed(pos, ret);
            this.resultTypes.add(exprResult);
        }
    }

    private void markUsed(InputPosition pos, Type ret) {
        if (ret instanceof UnifiableType) {
            ((UnifiableType)ret).isReturned(pos);
        } else if (ret instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)ret;
            for (Type ty : pi.polys()) {
                this.markUsed(pos, ty);
            }
        }
    }

    @Override
    public void leaveFunction(FunctionDefinition fn) {
        if (fn.intros().isEmpty()) {
            this.sv.result(null);
        } else if (this.resultTypes.isEmpty()) {
            this.sv.result(null);
        } else {
            PosType c = this.state.consolidate(fn.location(), this.resultTypes);
            this.sv.result(this.buildApplyType(c.pos, c));
        }
    }

    @Override
    public void leaveTuple(TupleAssignment e) {
        PosType c = this.state.consolidate(e.location(), this.resultTypes);
        this.sv.result(this.buildApplyType(c.pos, c));
    }

    @Override
    public void leaveObjectMethod(ObjectMethod meth) {
        if (!meth.generate) {
            this.sv.result(null);
            return;
        }
        if (!meth.hasMessages()) {
            this.sv.result(this.buildApplyType(meth.location(), new PosType(meth.location(), LoadBuiltins.nil)));
        } else if (this.resultTypes.isEmpty()) {
            this.sv.result(null);
        } else {
            PosType posty = this.state.consolidate(meth.location(), this.resultTypes);
            InputPosition pos = posty.pos;
            Type ty = posty.type;
            if (!TypeHelpers.isListMessage(pos, ty)) {
                if (!(ty instanceof ErrorType)) {
                    if (TypeHelpers.isList(ty)) {
                        this.errors.message(pos, ((PolyInstance)ty).polys().get(0).signature() + " cannot be a Message");
                    } else {
                        this.errors.message(pos, ty.signature() + " cannot be a Message");
                    }
                }
                this.sv.result(new ExpressionChecker.ExprResult(pos, new ErrorType()));
                return;
            }
            this.sv.result(this.buildApplyType(meth.location(), new PosType(posty.pos, LoadBuiltins.listMessages)));
        }
    }

    @Override
    public void leaveObjectCtor(ObjectCtor ctor) {
        if (!ctor.generate) {
            this.sv.result(null);
        } else if (ctor.hasMessages() && this.resultTypes.isEmpty()) {
            this.sv.result(null);
        } else {
            this.sv.result(this.buildApplyType(ctor.location(), new PosType(ctor.location(), ctor.getObject())));
        }
    }

    private PosType buildApplyType(InputPosition pos, PosType result) {
        if (this.argTypes.isEmpty()) {
            return result;
        }
        ArrayList<Type> args = new ArrayList<Type>();
        for (PosType p : this.argTypes) {
            args.add(p.type);
        }
        return new PosType(pos, new Apply(args, result.type));
    }

    public static class ArgResult
    extends PosType {
        public ArgResult(Type t) {
            super(null, t);
        }
    }
}

