/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.NumericLiteral;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AnonymousVar;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.CheckTypeExpr;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.CurrentContainer;
import org.flasck.flas.parsedForm.FunctionCaseDefn;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TemplateNestedField;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.parsedForm.TypeExpr;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.repository.StackVisitor;
import org.flasck.flas.repository.Traverser;
import org.flasck.flas.tc3.ApplyExpressionChecker;
import org.flasck.flas.tc3.CaptureChecker;
import org.flasck.flas.tc3.CastExprChecker;
import org.flasck.flas.tc3.CheckTypeExprChecker;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.CurryArgumentType;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.MemberExpressionChecker;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Tuple;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeExprChecker;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class ExpressionChecker
extends LeafAdapter
implements ResultAware {
    private final NestedVisitor nv;
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final ErrorReporter errors;
    private InputPosition guardPos;
    private InputPosition exprPos;
    private final String fnCxt;
    private final boolean inTemplate;

    public ExpressionChecker(ErrorReporter errors, RepositoryReader repository, CurrentTCState state, NestedVisitor nv, String fnCxt, boolean inTemplate) {
        this.errors = errors;
        this.repository = repository;
        this.state = state;
        this.nv = nv;
        this.fnCxt = fnCxt;
        this.inTemplate = inTemplate;
    }

    @Override
    public void visitGuard(FunctionCaseDefn c) {
        this.guardPos = c.guard.location();
    }

    @Override
    public void visitCheckTypeExpr(CheckTypeExpr expr) {
        new CheckTypeExprChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate);
    }

    @Override
    public void visitTypeExpr(TypeExpr expr) {
        new TypeExprChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate);
    }

    @Override
    public void visitCastExpr(CastExpr expr) {
        new CastExprChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate);
    }

    @Override
    public void visitNumericLiteral(NumericLiteral number) {
        this.announce(number.location, LoadBuiltins.number);
    }

    @Override
    public void visitStringLiteral(StringLiteral s) {
        this.announce(s.location(), LoadBuiltins.string);
    }

    @Override
    public void visitCurrentContainer(CurrentContainer expr, boolean isObjState, boolean wouldWantState) {
        if (isObjState && !wouldWantState) {
            this.nv.result(new IgnoreMe());
        } else {
            this.announce(expr.location(), expr.type);
        }
    }

    @Override
    public void visitUnresolvedVar(UnresolvedVar var, int nargs) {
        InputPosition pos = var.location();
        if (var == null || var.defn() == null) {
            throw new NullPointerException("undefined var: " + var);
        }
        RepositoryEntry defn = var.defn();
        if (defn instanceof StructDefn || defn instanceof ObjectDefn || defn instanceof HandlerImplements) {
            throw new CantHappenException("should be TypeReferences");
        }
        if (defn instanceof FunctionDefinition) {
            FunctionDefinition fn = (FunctionDefinition)defn;
            if (fn.hasType()) {
                this.announce(pos, fn.type());
            } else if (this.state.getMember(fn.name()) == null) {
                this.announce(pos, new ErrorType());
            } else {
                this.announce(pos, this.state.getMember(fn.name()));
            }
        } else if (defn instanceof TupleMember) {
            TupleMember tm = (TupleMember)defn;
            if (tm.type() != null) {
                this.announce(pos, tm.type());
            } else {
                this.announce(pos, this.state.requireVarConstraints(tm.location(), tm.name().uniqueName(), tm.name().uniqueName()));
            }
        } else if (defn instanceof StandaloneMethod) {
            StandaloneMethod fn = (StandaloneMethod)defn;
            if (fn.hasType()) {
                this.announce(pos, fn.type());
            } else {
                this.announce(pos, this.state.getMember(fn.name()));
            }
        } else if (defn instanceof ObjectMethod) {
            ObjectMethod meth = (ObjectMethod)defn;
            if (meth.hasType()) {
                this.announce(pos, meth.type());
            } else {
                this.announce(pos, this.state.getMember(meth.name()));
            }
        } else if (defn instanceof VarPattern) {
            VarPattern vp = (VarPattern)defn;
            if (vp.type() != null) {
                this.announce(pos, vp.type());
            } else {
                this.announce(pos, this.state.requireVarConstraints(vp.location(), this.fnCxt, vp.name().uniqueName()));
            }
        } else if (defn instanceof TypedPattern) {
            TypedPattern vp = (TypedPattern)defn;
            this.announce(pos, vp.type.namedDefn());
        } else if (defn instanceof HandlerLambda) {
            HandlerLambda hl = (HandlerLambda)defn;
            this.announce(pos, hl.type());
        } else if (defn instanceof StructField) {
            StructField sf = (StructField)defn;
            this.announce(pos, sf.type.namedDefn());
        } else if (defn instanceof TemplateNestedField) {
            TemplateNestedField tnf = (TemplateNestedField)defn;
            this.announce(pos, tnf.type());
        } else if (defn instanceof RequiresContract) {
            this.announce(pos, ((RequiresContract)defn).implementsType().namedDefn());
        } else if (defn instanceof Provides) {
            this.announce(pos, ((Provides)defn).implementsType().namedDefn());
        } else if (defn instanceof ObjectContract) {
            this.announce(pos, ((ObjectContract)defn).implementsType().namedDefn());
        } else if (defn instanceof UnitDataDeclaration) {
            this.announce(pos, ((UnitDataDeclaration)defn).ofType.namedDefn());
        } else if (defn instanceof IntroduceVar) {
            Type ia = ((IntroduceVar)defn).introducedAs();
            if (ia == null) {
                ia = new ErrorType();
            }
            this.announce(pos, ia);
        } else {
            throw new RuntimeException("Cannot handle " + defn + " of type " + defn.getClass());
        }
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        InputPosition pos = var.location();
        if (var == null || var.namedDefn() == null) {
            throw new NullPointerException("undefined var: " + var);
        }
        NamedType defn = var.namedDefn();
        if (defn instanceof ContractDecl) {
            this.errors.message(pos, "cannot pass a contract to a function");
            this.announce(pos, new ErrorType());
        } else {
            this.announce(pos, defn);
        }
    }

    @Override
    public void visitAnonymousVar(AnonymousVar var) {
        this.announce(var.location(), new CurryArgumentType(var.location()));
    }

    @Override
    public void visitIntroduceVar(IntroduceVar var) {
        UnifiableType ut = this.state.createUT(var.location(), var.name().uniqueName());
        this.state.bindIntroducedVarToUT(var, ut);
        this.announce(var.location(), ut);
    }

    @Override
    public void visitUnresolvedOperator(UnresolvedOperator op, int nargs) {
        if (op.defn() instanceof StructDefn) {
            this.announce(op.location(), (Type)((Object)op.defn()));
        } else if (op.defn() instanceof FunctionDefinition) {
            FunctionDefinition fn = (FunctionDefinition)op.defn();
            if (fn == LoadBuiltins.makeTuple) {
                this.announce(op.location(), new Tuple(fn.location(), nargs));
            } else {
                this.announce(op.location(), fn.type());
            }
        } else {
            throw new RuntimeException("Cannot handle " + op);
        }
    }

    @Override
    public void visitApplyExpr(ApplyExpr expr) {
        this.exprPos = expr.location;
        this.nv.push(new ApplyExpressionChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate));
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        this.exprPos = expr.location;
        if (!expr.boundEarly()) {
            this.nv.push(new MemberExpressionChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate));
        }
        return expr.boundEarly();
    }

    @Override
    public void leaveMemberExpr(MemberExpr expr, boolean done) {
        if (expr.boundEarly()) {
            if (expr.defn() instanceof Type) {
                this.announce(this.exprPos, (Type)((Object)expr.defn()));
            } else if (expr.defn() instanceof FunctionDefinition) {
                this.announce(this.exprPos, ((FunctionDefinition)expr.defn()).type());
            } else {
                throw new HaventConsideredThisException("non-function package names");
            }
        }
    }

    @Override
    public void result(Object r) {
        this.announce(this.exprPos, (Type)r);
    }

    private void announce(InputPosition pos, Type ty) {
        if (ty == null) {
            throw new NotImplementedException("Cannot announce that a type is null");
        }
        if (this.guardPos != null) {
            this.nv.result(new GuardResult(pos, ty));
        } else {
            this.nv.result(new ExprResult(pos, ty));
        }
    }

    public static Type check(ErrorReporter errors, RepositoryReader repository, CurrentTCState state, String fnCxt, boolean inTemplate, Expr expr) {
        StackVisitor sv = new StackVisitor();
        CaptureChecker cc = new CaptureChecker(errors, repository, state, sv, fnCxt, inTemplate);
        Traverser t = new Traverser(sv);
        t.visitExpr(expr, 0);
        return ((ExprResult)cc.get()).type;
    }

    public static class IgnoreMe {
    }

    public static class GuardResult
    extends PosType {
        public GuardResult(InputPosition pos, Type t) {
            super(pos, t);
        }
    }

    public static class ExprResult
    extends PosType {
        public ExprResult(InputPosition pos, Type t) {
            super(pos, t);
        }
    }
}

