/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.AnonymousVar;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.parsedForm.ut.UnitTestExpect;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Type;

public class ExpectChecker
extends LeafAdapter
implements ResultAware {
    private final NestedVisitor sv;
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final String fnCxt;
    private boolean isHandler;
    private Type mock;
    private List<Type> args = new ArrayList<Type>();
    private Type handler;

    public ExpectChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, String fnCxt, UnitTestExpect e) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.fnCxt = fnCxt;
        sv.push(this);
        this.state = new FunctionGroupTCState(repository, new DependencyGroup(new LogicHolder[0]));
        sv.push(new ExpressionChecker(errors, repository, this.state, sv, fnCxt, false));
    }

    @Override
    public void visitExpr(Expr e, int nargs) {
        this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, this.fnCxt, false));
    }

    @Override
    public void expectHandlerNext() {
        this.isHandler = true;
    }

    @Override
    public void result(Object r) {
        Type t = ((ExpressionChecker.ExprResult)r).type;
        if (this.mock == null) {
            this.mock = t;
        } else if (this.isHandler) {
            this.handler = t;
        } else {
            this.args.add(t);
        }
    }

    @Override
    public void leaveUnitTestExpect(UnitTestExpect e) {
        if (this.mock instanceof ErrorType || this.handler instanceof ErrorType) {
            this.sv.result(this.mock);
            return;
        }
        for (Type t : this.args) {
            if (!(t instanceof ErrorType)) continue;
            this.sv.result(null);
            return;
        }
        if (!(this.mock instanceof ContractDecl)) {
            this.errors.message(e.ctr.location(), "expect requires a contract variable");
            this.sv.result(null);
            return;
        }
        ContractDecl cd = (ContractDecl)this.mock;
        String methName = e.method.var;
        ContractMethodDecl m = cd.getMethod(methName);
        if (m == null) {
            this.errors.message(e.method.location(), "there is no method " + methName + " in " + cd.name().uniqueName());
            this.sv.result(null);
            return;
        }
        if (m.args.size() != this.args.size()) {
            this.errors.message(e.method.location(), "incorrect number of arguments for " + cd.name().uniqueName() + "." + methName);
            this.sv.result(null);
            return;
        }
        for (int i = 0; i < m.args.size(); ++i) {
            InputPosition aloc = e.args.get(i).location();
            Type atype = m.args.get(i).type();
            if (atype.incorporates(aloc, this.args.get(i))) continue;
            this.errors.message(aloc, "type error: " + atype + " " + this.args.get(i));
            this.sv.result(new ErrorType());
            return;
        }
        if (e.handler != null && !(e.handler instanceof AnonymousVar)) {
            if (m.handler == null) {
                this.errors.message(e.handler.location(), "contract method " + m.name.uniqueName() + " does not expect a handler");
                this.sv.result(new ErrorType());
                return;
            }
            NamedType htype = m.handler.type.namedDefn();
            if (!htype.incorporates(e.handler.location(), this.handler)) {
                this.errors.message(e.handler.location(), "type error: " + htype + " " + this.handler);
                this.sv.result(new ErrorType());
                return;
            }
        }
        this.state.groupDone(this.errors, new HashMap<TypeBinder, PosType>(), new HashMap<TypeBinder, PosType>());
        this.state.bindIntroducedVarTypes(this.errors);
        this.sv.result(null);
    }
}

